
#ifndef	_HTC_H_
#endif

/* header file for the MICROCHIP PIC microcontroller
 *  16C54A
 */


#ifndef __PIC18P235l_H
#define __PIC18P235l_H


// Special function register definitions
//
//----- BANK0 Register -----------------------------------------------------
volatile   unsigned char           INDF0               @ 0x000;
volatile   unsigned char           INDF1               @ 0x001;
volatile   unsigned char           PCL                 @ 0x002;
volatile   unsigned char           STATUS              @ 0x003;
volatile   unsigned char           FSR0L               @ 0x004;
volatile   unsigned char           FSR0H               @ 0x005;
volatile   unsigned char           FSR1L               @ 0x006;
volatile  unsigned char            FSR1H               @ 0x007;
volatile  unsigned char            PCLATH              @ 0x008;
volatile  unsigned char            INTCON              @ 0x009;

volatile  unsigned char           TRISA               @ 0x010;
volatile  unsigned char           TRISB               @ 0x011;
volatile  unsigned char           TRISC               @ 0x012;
volatile  unsigned char           TRISD               @ 0x013;
volatile  unsigned char           TRISE               @ 0x014;
volatile  unsigned char           TRISF               @ 0x015;
volatile  unsigned char           PORTA               @ 0x01C;
volatile  unsigned char           PORTB               @ 0x01D;
volatile  unsigned char           PORTC               @ 0x01E;
volatile  unsigned char           PORTD               @ 0x01F;
volatile  unsigned char           PORTE               @ 0x020;
volatile  unsigned char           PORTF               @ 0x021;
volatile  unsigned char           WPUA                @ 0x028;
volatile  unsigned char           WPUB                @ 0x029;
volatile  unsigned char           WPUC                @ 0x02A;
volatile  unsigned char           WPUD                @ 0x02B;
volatile  unsigned char           WPUE                @ 0x02C;
volatile  unsigned char           WPUF                @ 0x02D;
volatile  unsigned char           WPDA                @ 0x034;
volatile  unsigned char           WPDB                @ 0x035;
volatile  unsigned char           WPDC                @ 0x036;
volatile  unsigned char           WPDD                @ 0x037;
volatile  unsigned char           WPDE                @ 0x038;
volatile  unsigned char           WPDF                @ 0x039;
volatile  unsigned char           IOCA                @ 0x040;
volatile  unsigned char           IOCB                @ 0x041;
volatile  unsigned char           IOCC                @ 0x042;
volatile  unsigned char           IOCD                @ 0x043;
volatile  unsigned char           IOCE                @ 0x044;
volatile  unsigned char           IOCF                @ 0x045;
volatile  unsigned char           PORCTR              @ 0x04C;
volatile  unsigned char           LAEN                @ 0x04D;
volatile  unsigned char           LBEN                @ 0x04E;
volatile  unsigned char           LCEN                @ 0x04F;
volatile  unsigned char           LDEN                @ 0x050;
volatile  unsigned char           LEEN                @ 0x051;
volatile  unsigned char           LFEN                @ 0x052;
volatile  unsigned char           PIR1                @ 0x054;
volatile  unsigned char           PIR2                @ 0x055;
volatile  unsigned char           PIR3                @ 0x056;
volatile  unsigned char           T1L                 @ 0x058;
volatile  unsigned char           T1H                 @ 0x059;
volatile  unsigned char           T1CON               @ 0x05A;
volatile  unsigned char           T0                  @ 0x05B;
volatile  unsigned char           T2                  @ 0x05C;
volatile  unsigned char           PR2                 @ 0x05D;
volatile  unsigned char           T2CON               @ 0x05E;
volatile  unsigned char           PR1L                @ 0x05F;
volatile  unsigned char           PR1CON              @ 0x060;
volatile  unsigned char           PIE1                @ 0x070;
volatile  unsigned char           PIE2                @ 0x071;
volatile  unsigned char           PIE3                @ 0x072;
volatile  unsigned char           OPTION              @ 0x078;
volatile  unsigned char           PCON                @ 0x079;
volatile  unsigned char           OSCCON              @ 0x07A;
volatile  unsigned char           CCPR2L              @ 0x080;
volatile  unsigned char           CCPR2H              @ 0x081;
volatile  unsigned char           CCP2CON             @ 0x082;
volatile  unsigned char           CCPR1L              @ 0x083;
volatile  unsigned char           CCPR1H              @ 0x084;
volatile  unsigned char           CCP1CON             @ 0x085;
volatile  unsigned char           ANSELL              @ 0x08C;
volatile  unsigned char           ANSELH              @ 0x08D;
volatile  unsigned char           ADRESL              @ 0x092;
volatile  unsigned char           ADRESH              @ 0x093;
volatile  unsigned char           ADCON0              @ 0x094;
volatile  unsigned char           ADCON1              @ 0x095;
volatile  unsigned char           ADCLK               @ 0x096;
volatile  unsigned char           PMDATL              @ 0x09A;
volatile  unsigned char           PMDATH              @ 0x09B;
volatile  unsigned char           PMADRL              @ 0x09C;
volatile  unsigned char           PMADRH              @ 0x09D;
volatile  unsigned char           PMCON               @ 0x09E;
volatile  unsigned char           itemp               @ 0x100;
volatile  unsigned char           OCCUPY18A           @ 0x18A;
//----- BANK1 Register -----------------------------------------------------
volatile  unsigned char           SPSTAT              @ 0x230;
volatile  unsigned char           SPCTL               @ 0x231;
volatile  unsigned char           SPDAT               @ 0x232;
volatile  unsigned char           BRT                 @ 0x23A;
volatile  unsigned char           AUXR                @ 0x23B;
volatile  unsigned char           SCON                @ 0x23C;
volatile  unsigned char           SBUF                @ 0x23D;
volatile  unsigned char           SADEN               @ 0x23E;
volatile  unsigned char           SADDR               @ 0x23F;
volatile  unsigned char           PWM2DT              @ 0x250;
volatile  unsigned char           PWM2D               @ 0x251;
volatile  unsigned char           PWM2P               @ 0x252;
volatile  unsigned char           PWM2C               @ 0x253;
volatile  unsigned char           PWM1DT              @ 0x254;
volatile  unsigned char           PWM1D               @ 0x255;
volatile  unsigned char           PWM1P               @ 0x256;
volatile  unsigned char           PWM1C               @ 0x257;
volatile  unsigned char           PWM0DT              @ 0x258;
volatile  unsigned char           PWM0DL              @ 0x259;
volatile  unsigned char           PWM0DH              @ 0x25A;
volatile  unsigned char           PWM0PL              @ 0x25B;
volatile  unsigned char           PWM0PH              @ 0x25C;
volatile  unsigned char           PWM0C               @ 0x25D;
volatile  unsigned char           PWMEN               @ 0x25E;
volatile  unsigned char           FLTM                @ 0x25F;
volatile  unsigned char           LCDCON              @ 0x2B0;
volatile  unsigned char           LCDPS               @ 0x2B1;
volatile  unsigned char           DISPCTR             @ 0x2B2;
volatile  unsigned char           LCDLVD              @ 0x2B3;
volatile  unsigned char           SEGSE0              @ 0x2B6;
volatile  unsigned char           SEGSE1              @ 0x2B7;
volatile  unsigned char           SEGSE2              @ 0x2B8;
volatile  unsigned char           SEGSE3              @ 0x2B9;
volatile  unsigned char           SEGDATA0            @ 0x2C0;
volatile  unsigned char           SEGDATA1            @ 0x2C1;
volatile  unsigned char           SEGDATA2            @ 0x2C2;
volatile  unsigned char           SEGDATA3            @ 0x2C3;
volatile  unsigned char           SEGDATA4            @ 0x2C4;
volatile  unsigned char           SEGDATA5            @ 0x2C5;
volatile  unsigned char           SEGDATA6            @ 0x2C6;
volatile  unsigned char           SEGDATA7            @ 0x2C7;
volatile  unsigned char           SEGDATA8            @ 0x2C8;
volatile  unsigned char           SEGDATA9            @ 0x2C9;
volatile  unsigned char           SEGDATA10           @ 0x2CA;
volatile  unsigned char           SEGDATA11           @ 0x2CB;
volatile  unsigned char           SEGDATA12           @ 0x2CC;
volatile  unsigned char           SEGDATA13           @ 0x2CD;
volatile  unsigned char           SEGDATA14           @ 0x2CE;
volatile  unsigned char           SEGDATA15           @ 0x2CF;
volatile  unsigned char           SEGDATA16           @ 0x2D0;
volatile  unsigned char           SEGDATA17           @ 0x2D1;
volatile  unsigned char           SEGDATA18           @ 0x2D2;
volatile  unsigned char           SEGDATA19           @ 0x2D3;
volatile  unsigned char           SEGDATA20           @ 0x2D4;
volatile  unsigned char           SEGDATA21           @ 0x2D5;
volatile  unsigned char           SEGDATA22           @ 0x2D6;
volatile  unsigned char           SEGDATA23           @ 0x2D7;
volatile  unsigned char           SEGDATA24           @ 0x2D8;
volatile  unsigned char           SEGDATA25           @ 0x2D9;
volatile  unsigned char           SEGDATA26           @ 0x2DA;
volatile  unsigned char           SEGDATA27           @ 0x2DB;
volatile  unsigned char           SEGDATA28           @ 0x2DC;
volatile  unsigned char           SEGDATA29           @ 0x2DD;
volatile  unsigned char           SEGDATA30           @ 0x2DE;
volatile  unsigned char           SEGDATA31           @ 0x2DF;

//----- BANK1 Register -----------------------------------------------------
//----- BANK1 Register -----------------------------------------------------
// bit and bitfield definitions
volatile bit RBIF                     @ ((unsigned)&INTCON*8)+0;
volatile bit INTF                     @ ((unsigned)&INTCON*8)+1;
volatile bit T0IF                     @ ((unsigned)&INTCON*8)+2;
volatile bit RBIE                     @ ((unsigned)&INTCON*8)+3;
volatile bit INTE                     @ ((unsigned)&INTCON*8)+4;
volatile bit T0IE                     @ ((unsigned)&INTCON*8)+5;
volatile bit PEIE                     @ ((unsigned)&INTCON*8)+6;
volatile bit GIE                     @ ((unsigned)&INTCON*8)+7;
// bit and bitfield definitions
volatile bit C                     @ ((unsigned)&STATUS*8)+0;
volatile bit DC                     @ ((unsigned)&STATUS*8)+1;
volatile bit Z                     @ ((unsigned)&STATUS*8)+2;
volatile bit PD                     @ ((unsigned)&STATUS*8)+3;
volatile bit TO                     @ ((unsigned)&STATUS*8)+4;
volatile bit RP0                     @ ((unsigned)&STATUS*8)+5;

// bit and bitfield definitions
volatile bit TRISA0                     @ ((unsigned)&TRISA*8)+0;
volatile bit TRISA1                     @ ((unsigned)&TRISA*8)+1;
volatile bit TRISA2                     @ ((unsigned)&TRISA*8)+2;
volatile bit TRISA3                     @ ((unsigned)&TRISA*8)+3;
volatile bit TRISA4                     @ ((unsigned)&TRISA*8)+4;
volatile bit TRISA5                     @ ((unsigned)&TRISA*8)+5;
volatile bit TRISA6                     @ ((unsigned)&TRISA*8)+6;
volatile bit TRISA7                     @ ((unsigned)&TRISA*8)+7;
// bit and bitfield definitions
volatile bit TRISB0                     @ ((unsigned)&TRISB*8)+0;
volatile bit TRISB1                     @ ((unsigned)&TRISB*8)+1;
volatile bit TRISB2                     @ ((unsigned)&TRISB*8)+2;
volatile bit TRISB3                     @ ((unsigned)&TRISB*8)+3;
volatile bit TRISB4                     @ ((unsigned)&TRISB*8)+4;
volatile bit TRISB5                     @ ((unsigned)&TRISB*8)+5;
volatile bit TRISB6                     @ ((unsigned)&TRISB*8)+6;
volatile bit TRISB7                     @ ((unsigned)&TRISB*8)+7;
// bit and bitfield definitions
volatile bit TRISC0                     @ ((unsigned)&TRISC*8)+0;
volatile bit TRISC1                     @ ((unsigned)&TRISC*8)+1;
volatile bit TRISC2                     @ ((unsigned)&TRISC*8)+2;
volatile bit TRISC3                     @ ((unsigned)&TRISC*8)+3;
volatile bit TRISC4                     @ ((unsigned)&TRISC*8)+4;
volatile bit TRISC5                     @ ((unsigned)&TRISC*8)+5;
volatile bit TRISC6                     @ ((unsigned)&TRISC*8)+6;
volatile bit TRISC7                     @ ((unsigned)&TRISC*8)+7;
// bit and bitfield definitions
volatile bit TRISD0                     @ ((unsigned)&TRISD*8)+0;
volatile bit TRISD1                     @ ((unsigned)&TRISD*8)+1;
volatile bit TRISD2                     @ ((unsigned)&TRISD*8)+2;
volatile bit TRISD3                     @ ((unsigned)&TRISD*8)+3;
volatile bit TRISD4                     @ ((unsigned)&TRISD*8)+4;
volatile bit TRISD5                     @ ((unsigned)&TRISD*8)+5;
volatile bit TRISD6                     @ ((unsigned)&TRISD*8)+6;
volatile bit TRISD7                     @ ((unsigned)&TRISD*8)+7;
// bit and bitfield definitions
volatile bit TRISE0                     @ ((unsigned)&TRISE*8)+0;
volatile bit TRISE1                     @ ((unsigned)&TRISE*8)+1;
volatile bit TRISE2                     @ ((unsigned)&TRISE*8)+2;
volatile bit TRISE3                     @ ((unsigned)&TRISE*8)+3;
volatile bit TRISE4                     @ ((unsigned)&TRISE*8)+4;
volatile bit TRISE5                     @ ((unsigned)&TRISE*8)+5;
volatile bit TRISE6                     @ ((unsigned)&TRISE*8)+6;
volatile bit TRISE7                     @ ((unsigned)&TRISE*8)+7;
// bit and bitfield definitions
volatile bit TRISF0                     @ ((unsigned)&TRISF*8)+0;
volatile bit TRISF1                     @ ((unsigned)&TRISF*8)+1;
volatile bit TRISF2                     @ ((unsigned)&TRISF*8)+2;
volatile bit TRISF3                     @ ((unsigned)&TRISF*8)+3;
volatile bit TRISF4                     @ ((unsigned)&TRISF*8)+4;
volatile bit TRISF5                     @ ((unsigned)&TRISF*8)+5;
volatile bit TRISF6                     @ ((unsigned)&TRISF*8)+6;
volatile bit TRISF7                     @ ((unsigned)&TRISF*8)+7;
// bit and bitfield definitions
volatile bit PORTA0                     @ ((unsigned)&PORTA*8)+0;
volatile bit PORTA1                     @ ((unsigned)&PORTA*8)+1;
volatile bit PORTA2                     @ ((unsigned)&PORTA*8)+2;
volatile bit PORTA3                     @ ((unsigned)&PORTA*8)+3;
volatile bit PORTA4                     @ ((unsigned)&PORTA*8)+4;
volatile bit PORTA5                     @ ((unsigned)&PORTA*8)+5;
volatile bit PORTA6                     @ ((unsigned)&PORTA*8)+6;
volatile bit PORTA7                     @ ((unsigned)&PORTA*8)+7;
// bit and bitfield definitions
volatile bit PORTB0                     @ ((unsigned)&PORTB*8)+0;
volatile bit PORTB1                     @ ((unsigned)&PORTB*8)+1;
volatile bit PORTB2                     @ ((unsigned)&PORTB*8)+2;
volatile bit PORTB3                     @ ((unsigned)&PORTB*8)+3;
volatile bit PORTB4                     @ ((unsigned)&PORTB*8)+4;
volatile bit PORTB5                     @ ((unsigned)&PORTB*8)+5;
volatile bit PORTB6                     @ ((unsigned)&PORTB*8)+6;
volatile bit PORTB7                     @ ((unsigned)&PORTB*8)+7;
// bit and bitfield definitions
volatile bit PORTC0                     @ ((unsigned)&PORTC*8)+0;
volatile bit PORTC1                     @ ((unsigned)&PORTC*8)+1;
volatile bit PORTC2                     @ ((unsigned)&PORTC*8)+2;
volatile bit PORTC3                     @ ((unsigned)&PORTC*8)+3;
volatile bit PORTC4                     @ ((unsigned)&PORTC*8)+4;
volatile bit PORTC5                     @ ((unsigned)&PORTC*8)+5;
volatile bit PORTC6                     @ ((unsigned)&PORTC*8)+6;
volatile bit PORTC7                     @ ((unsigned)&PORTC*8)+7;
// bit and bitfield definitions
volatile bit PORTD0                     @ ((unsigned)&PORTD*8)+0;
volatile bit PORTD1                     @ ((unsigned)&PORTD*8)+1;
volatile bit PORTD2                     @ ((unsigned)&PORTD*8)+2;
volatile bit PORTD3                     @ ((unsigned)&PORTD*8)+3;
volatile bit PORTD4                     @ ((unsigned)&PORTD*8)+4;
volatile bit PORTD5                     @ ((unsigned)&PORTD*8)+5;
volatile bit PORTD6                     @ ((unsigned)&PORTD*8)+6;
volatile bit PORTD7                     @ ((unsigned)&PORTD*8)+7;
// bit and bitfield definitions
volatile bit PORTE0                     @ ((unsigned)&PORTE*8)+0;
volatile bit PORTE1                     @ ((unsigned)&PORTE*8)+1;
volatile bit PORTE2                     @ ((unsigned)&PORTE*8)+2;
volatile bit PORTE3                     @ ((unsigned)&PORTE*8)+3;
volatile bit PORTE4                     @ ((unsigned)&PORTE*8)+4;
volatile bit PORTE5                     @ ((unsigned)&PORTE*8)+5;
volatile bit PORTE6                     @ ((unsigned)&PORTE*8)+6;
volatile bit PORTE7                     @ ((unsigned)&PORTE*8)+7;
// bit and bitfield definitions
volatile bit PORTF0                     @ ((unsigned)&PORTF*8)+0;
volatile bit PORTF1                     @ ((unsigned)&PORTF*8)+1;
volatile bit PORTF2                     @ ((unsigned)&PORTF*8)+2;
volatile bit PORTF3                     @ ((unsigned)&PORTF*8)+3;
volatile bit PORTF4                     @ ((unsigned)&PORTF*8)+4;
volatile bit PORTF5                     @ ((unsigned)&PORTF*8)+5;
volatile bit PORTF6                     @ ((unsigned)&PORTF*8)+6;
volatile bit PORTF7                     @ ((unsigned)&PORTF*8)+7;
// bit and bitfield definitions
volatile bit WPUA0                     @ ((unsigned)&WPUA*8)+0;
volatile bit WPUA1                     @ ((unsigned)&WPUA*8)+1;
volatile bit WPUA2                     @ ((unsigned)&WPUA*8)+2;
volatile bit WPUA3                     @ ((unsigned)&WPUA*8)+3;
volatile bit WPUA4                     @ ((unsigned)&WPUA*8)+4;
volatile bit WPUA5                     @ ((unsigned)&WPUA*8)+5;
volatile bit WPUA6                     @ ((unsigned)&WPUA*8)+6;
volatile bit WPUA7                     @ ((unsigned)&WPUA*8)+7;
// bit and bitfield definitions
volatile bit WPUB0                     @ ((unsigned)&WPUB*8)+0;
volatile bit WPUB1                     @ ((unsigned)&WPUB*8)+1;
volatile bit WPUB2                     @ ((unsigned)&WPUB*8)+2;
volatile bit WPUB3                     @ ((unsigned)&WPUB*8)+3;
volatile bit WPUB4                     @ ((unsigned)&WPUB*8)+4;
volatile bit WPUB5                     @ ((unsigned)&WPUB*8)+5;
volatile bit WPUB6                     @ ((unsigned)&WPUB*8)+6;
volatile bit WPUB7                     @ ((unsigned)&WPUB*8)+7;
// bit and bitfield definitions
volatile bit WPUC0                     @ ((unsigned)&WPUC*8)+0;
volatile bit WPUC1                     @ ((unsigned)&WPUC*8)+1;
volatile bit WPUC2                     @ ((unsigned)&WPUC*8)+2;
volatile bit WPUC3                     @ ((unsigned)&WPUC*8)+3;
volatile bit WPUC4                     @ ((unsigned)&WPUC*8)+4;
volatile bit WPUC5                     @ ((unsigned)&WPUC*8)+5;
volatile bit WPUC6                     @ ((unsigned)&WPUC*8)+6;
volatile bit WPUC7                     @ ((unsigned)&WPUC*8)+7;
// bit and bitfield definitions
volatile bit WPUD0                     @ ((unsigned)&WPUD*8)+0;
volatile bit WPUD1                     @ ((unsigned)&WPUD*8)+1;
volatile bit WPUD2                     @ ((unsigned)&WPUD*8)+2;
volatile bit WPUD3                     @ ((unsigned)&WPUD*8)+3;
volatile bit WPUD4                     @ ((unsigned)&WPUD*8)+4;
volatile bit WPUD5                     @ ((unsigned)&WPUD*8)+5;
volatile bit WPUD6                     @ ((unsigned)&WPUD*8)+6;
volatile bit WPUD7                     @ ((unsigned)&WPUD*8)+7;
// bit and bitfield definitions
volatile bit WPUE0                     @ ((unsigned)&WPUE*8)+0;
volatile bit WPUE1                     @ ((unsigned)&WPUE*8)+1;
volatile bit WPUE2                     @ ((unsigned)&WPUE*8)+2;
volatile bit WPUE3                     @ ((unsigned)&WPUE*8)+3;
volatile bit WPUE4                     @ ((unsigned)&WPUE*8)+4;
volatile bit WPUE5                     @ ((unsigned)&WPUE*8)+5;
volatile bit WPUE6                     @ ((unsigned)&WPUE*8)+6;
volatile bit WPUE7                     @ ((unsigned)&WPUE*8)+7;
// bit and bitfield definitions
volatile bit WPUF0                     @ ((unsigned)&WPUF*8)+0;
volatile bit WPUF1                     @ ((unsigned)&WPUF*8)+1;
volatile bit WPUF2                     @ ((unsigned)&WPUF*8)+2;
volatile bit WPUF3                     @ ((unsigned)&WPUF*8)+3;
volatile bit WPUF4                     @ ((unsigned)&WPUF*8)+4;
volatile bit WPUF5                     @ ((unsigned)&WPUF*8)+5;
volatile bit WPUF6                     @ ((unsigned)&WPUF*8)+6;
volatile bit WPUF7                     @ ((unsigned)&WPUF*8)+7;
// bit and bitfield definitions
volatile bit WPDA0                     @ ((unsigned)&WPDA*8)+0;
volatile bit WPDA1                     @ ((unsigned)&WPDA*8)+1;
volatile bit WPDA2                     @ ((unsigned)&WPDA*8)+2;
volatile bit WPDA3                     @ ((unsigned)&WPDA*8)+3;
volatile bit WPDA4                     @ ((unsigned)&WPDA*8)+4;
volatile bit WPDA5                     @ ((unsigned)&WPDA*8)+5;
volatile bit WPDA6                     @ ((unsigned)&WPDA*8)+6;
volatile bit WPDA7                     @ ((unsigned)&WPDA*8)+7;
// bit and bitfield definitions
volatile bit WPDB0                     @ ((unsigned)&WPDB*8)+0;
volatile bit WPDB1                     @ ((unsigned)&WPDB*8)+1;
volatile bit WPDB2                     @ ((unsigned)&WPDB*8)+2;
volatile bit WPDB3                     @ ((unsigned)&WPDB*8)+3;
volatile bit WPDB4                     @ ((unsigned)&WPDB*8)+4;
volatile bit WPDB5                     @ ((unsigned)&WPDB*8)+5;
volatile bit WPDB6                     @ ((unsigned)&WPDB*8)+6;
volatile bit WPDB7                     @ ((unsigned)&WPDB*8)+7;
// bit and bitfield definitions
volatile bit WPDC0                     @ ((unsigned)&WPDC*8)+0;
volatile bit WPDC1                     @ ((unsigned)&WPDC*8)+1;
volatile bit WPDC2                     @ ((unsigned)&WPDC*8)+2;
volatile bit WPDC3                     @ ((unsigned)&WPDC*8)+3;
volatile bit WPDC4                     @ ((unsigned)&WPDC*8)+4;
volatile bit WPDC5                     @ ((unsigned)&WPDC*8)+5;
volatile bit WPDC6                     @ ((unsigned)&WPDC*8)+6;
volatile bit WPDC7                     @ ((unsigned)&WPDC*8)+7;
// bit and bitfield definitions
volatile bit WPDD0                     @ ((unsigned)&WPDD*8)+0;
volatile bit WPDD1                     @ ((unsigned)&WPDD*8)+1;
volatile bit WPDD2                     @ ((unsigned)&WPDD*8)+2;
volatile bit WPDD3                     @ ((unsigned)&WPDD*8)+3;
volatile bit WPDD4                     @ ((unsigned)&WPDD*8)+4;
volatile bit WPDD5                     @ ((unsigned)&WPDD*8)+5;
volatile bit WPDD6                     @ ((unsigned)&WPDD*8)+6;
volatile bit WPDD7                     @ ((unsigned)&WPDD*8)+7;
// bit and bitfield definitions
volatile bit WPDE0                     @ ((unsigned)&WPDE*8)+0;
volatile bit WPDE1                     @ ((unsigned)&WPDE*8)+1;
volatile bit WPDE2                     @ ((unsigned)&WPDE*8)+2;
volatile bit WPDE3                     @ ((unsigned)&WPDE*8)+3;
volatile bit WPDE4                     @ ((unsigned)&WPDE*8)+4;
volatile bit WPDE5                     @ ((unsigned)&WPDE*8)+5;
volatile bit WPDE6                     @ ((unsigned)&WPDE*8)+6;
volatile bit WPDE7                     @ ((unsigned)&WPDE*8)+7;
// bit and bitfield definitions
volatile bit WPDF0                     @ ((unsigned)&WPDF*8)+0;
volatile bit WPDF1                     @ ((unsigned)&WPDF*8)+1;
volatile bit WPDF2                     @ ((unsigned)&WPDF*8)+2;
volatile bit WPDF3                     @ ((unsigned)&WPDF*8)+3;
volatile bit WPDF4                     @ ((unsigned)&WPDF*8)+4;
volatile bit WPDF5                     @ ((unsigned)&WPDF*8)+5;
volatile bit WPDF6                     @ ((unsigned)&WPDF*8)+6;
volatile bit WPDF7                     @ ((unsigned)&WPDF*8)+7;
// bit and bitfield definitions
volatile bit IOCA0                     @ ((unsigned)&IOCA*8)+0;
volatile bit IOCA1                     @ ((unsigned)&IOCA*8)+1;
volatile bit IOCA2                     @ ((unsigned)&IOCA*8)+2;
volatile bit IOCA3                     @ ((unsigned)&IOCA*8)+3;
volatile bit IOCA4                     @ ((unsigned)&IOCA*8)+4;
volatile bit IOCA5                     @ ((unsigned)&IOCA*8)+5;
volatile bit IOCA6                     @ ((unsigned)&IOCA*8)+6;
volatile bit IOCA7                     @ ((unsigned)&IOCA*8)+7;
// bit and bitfield definitions
volatile bit IOCB0                     @ ((unsigned)&IOCB*8)+0;
volatile bit IOCB1                     @ ((unsigned)&IOCB*8)+1;
volatile bit IOCB2                     @ ((unsigned)&IOCB*8)+2;
volatile bit IOCB3                     @ ((unsigned)&IOCB*8)+3;
volatile bit IOCB4                     @ ((unsigned)&IOCB*8)+4;
volatile bit IOCB5                     @ ((unsigned)&IOCB*8)+5;
volatile bit IOCB6                     @ ((unsigned)&IOCB*8)+6;
volatile bit IOCB7                     @ ((unsigned)&IOCB*8)+7;
// bit and bitfield definitions
volatile bit IOCC0                     @ ((unsigned)&IOCC*8)+0;
volatile bit IOCC1                     @ ((unsigned)&IOCC*8)+1;
volatile bit IOCC2                     @ ((unsigned)&IOCC*8)+2;
volatile bit IOCC3                     @ ((unsigned)&IOCC*8)+3;
volatile bit IOCC4                     @ ((unsigned)&IOCC*8)+4;
volatile bit IOCC5                     @ ((unsigned)&IOCC*8)+5;
volatile bit IOCC6                     @ ((unsigned)&IOCC*8)+6;
volatile bit IOCC7                     @ ((unsigned)&IOCC*8)+7;
// bit and bitfield definitions
volatile bit IOCD0                     @ ((unsigned)&IOCD*8)+0;
volatile bit IOCD1                     @ ((unsigned)&IOCD*8)+1;
volatile bit IOCD2                     @ ((unsigned)&IOCD*8)+2;
volatile bit IOCD3                     @ ((unsigned)&IOCD*8)+3;
volatile bit IOCD4                     @ ((unsigned)&IOCD*8)+4;
volatile bit IOCD5                     @ ((unsigned)&IOCD*8)+5;
volatile bit IOCD6                     @ ((unsigned)&IOCD*8)+6;
volatile bit IOCD7                     @ ((unsigned)&IOCD*8)+7;
// bit and bitfield definitions
volatile bit IOCE0                     @ ((unsigned)&IOCE*8)+0;
volatile bit IOCE1                     @ ((unsigned)&IOCE*8)+1;
volatile bit IOCE2                     @ ((unsigned)&IOCE*8)+2;
volatile bit IOCE3                     @ ((unsigned)&IOCE*8)+3;
volatile bit IOCE4                     @ ((unsigned)&IOCE*8)+4;
volatile bit IOCE5                     @ ((unsigned)&IOCE*8)+5;
volatile bit IOCE6                     @ ((unsigned)&IOCE*8)+6;
volatile bit IOCE7                     @ ((unsigned)&IOCE*8)+7;
// bit and bitfield definitions
volatile bit IOCF0                     @ ((unsigned)&IOCF*8)+0;
volatile bit IOCF1                     @ ((unsigned)&IOCF*8)+1;
volatile bit IOCF2                     @ ((unsigned)&IOCF*8)+2;
volatile bit IOCF3                     @ ((unsigned)&IOCF*8)+3;
volatile bit IOCF4                     @ ((unsigned)&IOCF*8)+4;
volatile bit IOCF5                     @ ((unsigned)&IOCF*8)+5;
volatile bit IOCF6                     @ ((unsigned)&IOCF*8)+6;
volatile bit IOCF7                     @ ((unsigned)&IOCF*8)+7;
// bit and bitfield definitions
volatile bit UAPCT0                     @ ((unsigned)&PORCTR*8)+0;
volatile bit UAPCT1                     @ ((unsigned)&PORCTR*8)+1;
volatile bit SPPCT0                     @ ((unsigned)&PORCTR*8)+2;
volatile bit SPPCT1                     @ ((unsigned)&PORCTR*8)+3;
volatile bit CCPCT                      @ ((unsigned)&PORCTR*8)+4;
// bit and bitfield definitions
volatile bit LAEN0                     @ ((unsigned)&LAEN*8)+0;
volatile bit LAEN1                     @ ((unsigned)&LAEN*8)+1;
volatile bit LAEN2                     @ ((unsigned)&LAEN*8)+2;
volatile bit LAEN3                     @ ((unsigned)&LAEN*8)+3;
volatile bit LAEN4                     @ ((unsigned)&LAEN*8)+4;
volatile bit LAEN5                     @ ((unsigned)&LAEN*8)+5;
volatile bit LAEN6                     @ ((unsigned)&LAEN*8)+6;
volatile bit LAEN7                    @ ((unsigned)&LAEN*8)+7;
// bit and bitfield definitions
volatile bit LBEN0                     @ ((unsigned)&LBEN*8)+0;
volatile bit LBEN1                     @ ((unsigned)&LBEN*8)+1;
volatile bit LBEN2                     @ ((unsigned)&LBEN*8)+2;
volatile bit LBEN3                     @ ((unsigned)&LBEN*8)+3;
volatile bit LBEN4                     @ ((unsigned)&LBEN*8)+4;
volatile bit LBEN5                     @ ((unsigned)&LBEN*8)+5;
volatile bit LBEN6                     @ ((unsigned)&LBEN*8)+6;
volatile bit LBEN7                     @ ((unsigned)&LBEN*8)+7;
// bit and bitfield definitions
volatile bit LCEN0                     @ ((unsigned)&LCEN*8)+0;
volatile bit LCEN1                     @ ((unsigned)&LCEN*8)+1;
volatile bit LCEN2                     @ ((unsigned)&LCEN*8)+2;
volatile bit LCEN3                     @ ((unsigned)&LCEN*8)+3;
volatile bit LCEN4                     @ ((unsigned)&LCEN*8)+4;
volatile bit LCEN5                     @ ((unsigned)&LCEN*8)+5;
volatile bit LCEN6                     @ ((unsigned)&LCEN*8)+6;
volatile bit LCEN7                     @ ((unsigned)&LCEN*8)+7;
// bit and bitfield definitions
volatile bit LDEN0                     @ ((unsigned)&LDEN*8)+0;
volatile bit LDEN1                     @ ((unsigned)&LDEN*8)+1;
volatile bit LDEN2                     @ ((unsigned)&LDEN*8)+2;
volatile bit LDEN3                     @ ((unsigned)&LDEN*8)+3;
volatile bit LDEN4                     @ ((unsigned)&LDEN*8)+4;
volatile bit LDEN5                     @ ((unsigned)&LDEN*8)+5;
volatile bit LDEN6                     @ ((unsigned)&LDEN*8)+6;
volatile bit LDEN7                     @ ((unsigned)&LDEN*8)+7;
// bit and bitfield definitions
volatile bit LEEN0                     @ ((unsigned)&LEEN*8)+0;
volatile bit LEEN1                     @ ((unsigned)&LEEN*8)+1;
volatile bit LEEN2                     @ ((unsigned)&LEEN*8)+2;
volatile bit LEEN3                     @ ((unsigned)&LEEN*8)+3;
volatile bit LEEN4                     @ ((unsigned)&LEEN*8)+4;
volatile bit LEEN5                     @ ((unsigned)&LEEN*8)+5;
volatile bit LEEN6                     @ ((unsigned)&LEEN*8)+6;
volatile bit LEEN7                     @ ((unsigned)&LEEN*8)+7;
// bit and bitfield definitions
volatile bit LFEN0                     @ ((unsigned)&LFEN*8)+0;
volatile bit LFEN1                     @ ((unsigned)&LFEN*8)+1;
volatile bit LFEN2                     @ ((unsigned)&LFEN*8)+2;
volatile bit LFEN3                     @ ((unsigned)&LFEN*8)+3;
volatile bit LFEN4                     @ ((unsigned)&LFEN*8)+4;
volatile bit LFEN5                     @ ((unsigned)&LFEN*8)+5;
volatile bit LFEN6                     @ ((unsigned)&LFEN*8)+6;
volatile bit LFEN7                     @ ((unsigned)&LFEN*8)+7;
// bit and bitfield definitions
volatile bit T1IF                     @ ((unsigned)&PIR1*8)+0;
volatile bit T2IF                     @ ((unsigned)&PIR1*8)+1;
volatile bit CCP1IF                   @ ((unsigned)&PIR1*8)+2;
volatile bit ADIF                     @ ((unsigned)&PIR1*8)+6;
// bit and bitfield definitions
volatile bit CCP2IF                     @ ((unsigned)&PIR2*8)+0;
volatile bit SPIF                       @ ((unsigned)&PIR2*8)+1;
volatile bit TXIF                       @ ((unsigned)&PIR2*8)+2;
volatile bit RXIF                       @ ((unsigned)&PIR2*8)+3;
volatile bit PWM0IF                     @ ((unsigned)&PIR2*8)+5;
volatile bit PWM1IF                     @ ((unsigned)&PIR2*8)+6;
volatile bit PWM2IF                     @ ((unsigned)&PIR2*8)+7;
// bit and bitfield definitions
volatile bit RAIF                     @ ((unsigned)&PIR3*8)+0;
volatile bit RCIF                     @ ((unsigned)&PIR3*8)+1;
volatile bit RDIF                     @ ((unsigned)&PIR3*8)+2;
volatile bit REIF                     @ ((unsigned)&PIR3*8)+3;
volatile bit RFIF                     @ ((unsigned)&PIR3*8)+4;
// bit and bitfield definitions
volatile bit T1ON                     @ ((unsigned)&T1CON*8)+0;
volatile bit T1SYNC                     @ ((unsigned)&T1CON*8)+2;
volatile bit T1OSCEN                     @ ((unsigned)&T1CON*8)+3;
volatile bit T1CKPS0                     @ ((unsigned)&T1CON*8)+4;
volatile bit T1CKPS1                     @ ((unsigned)&T1CON*8)+5;
volatile bit T1CS0                     @ ((unsigned)&T1CON*8)+6;
volatile bit T1CS1                     @ ((unsigned)&T1CON*8)+7;
// bit and bitfield definitions
volatile bit T2ON                     @ ((unsigned)&T2CON*8)+2;
volatile bit T2CKPS0                     @ ((unsigned)&T2CON*8)+3;
volatile bit T2CKPS1                     @ ((unsigned)&T2CON*8)+4;
volatile bit T2CKPS2                     @ ((unsigned)&T2CON*8)+5;
volatile bit T2CKPS3                     @ ((unsigned)&T2CON*8)+6;
// bit and bitfield definitions
volatile bit PR1EN                     @ ((unsigned)&PR1CON*8)+0;
volatile bit PWMPR1                     @ ((unsigned)&PR1CON*8)+1;
volatile bit T1CKPS2                     @ ((unsigned)&PR1CON*8)+2;
volatile bit T1CKPS3                     @ ((unsigned)&PR1CON*8)+3;
volatile bit PWM2T0                     @ ((unsigned)&PR1CON*8)+4;
volatile bit PWM2T1                     @ ((unsigned)&PR1CON*8)+5;
volatile bit PWM1T0                     @ ((unsigned)&PR1CON*8)+6;
volatile bit PWM1T1                     @ ((unsigned)&PR1CON*8)+7;
// bit and bitfield definitions
volatile bit T1IE                     @ ((unsigned)&PIE1*8)+0;
volatile bit T2IE                     @ ((unsigned)&PIE1*8)+1;
volatile bit CCP1IE                     @ ((unsigned)&PIE1*8)+2;
volatile bit ADIE                     @ ((unsigned)&PIE1*8)+6;
// bit and bitfield definitions
volatile bit CCP2IE                     @ ((unsigned)&PIE2*8)+0;
volatile bit SPIE                       @ ((unsigned)&PIE2*8)+1;
volatile bit UARTIE                     @ ((unsigned)&PIE2*8)+2;
volatile bit PWM0IE                     @ ((unsigned)&PIE2*8)+5;
volatile bit PWM1IE                     @ ((unsigned)&PIE2*8)+6;
volatile bit PWM2IE                     @ ((unsigned)&PIE2*8)+7;
// bit and bitfield definitions
volatile bit RAIE                     @ ((unsigned)&PIE3*8)+0;
volatile bit RCIE                     @ ((unsigned)&PIE3*8)+1;
volatile bit RDIE                     @ ((unsigned)&PIE3*8)+2;
volatile bit REIE                     @ ((unsigned)&PIE3*8)+3;
volatile bit RFIE                     @ ((unsigned)&PIE3*8)+4;
// bit and bitfield definitions
volatile bit PS0                     @ ((unsigned)&OPTION*8)+0;
volatile bit PS1                     @ ((unsigned)&OPTION*8)+1;
volatile bit PS2                     @ ((unsigned)&OPTION*8)+2;
volatile bit PSA                     @ ((unsigned)&OPTION*8)+3;
volatile bit T0SE                    @ ((unsigned)&OPTION*8)+4;
volatile bit T0CS                    @ ((unsigned)&OPTION*8)+5;
volatile bit INTEDG                  @ ((unsigned)&OPTION*8)+6;
volatile bit RBPUB                   @ ((unsigned)&OPTION*8)+7;
// bit and bitfield definitions
volatile bit BOR                     @ ((unsigned)&PCON*8)+0;
volatile bit POR                     @ ((unsigned)&PCON*8)+1;
volatile bit LVD1F                   @ ((unsigned)&PCON*8)+2;
volatile bit LVD2F                   @ ((unsigned)&PCON*8)+3;
volatile bit WDTENS                  @ ((unsigned)&PCON*8)+4;
volatile bit LVD1EN                  @ ((unsigned)&PCON*8)+6;
volatile bit LVD2EN                  @ ((unsigned)&PCON*8)+7;
// bit and bitfield definitions
volatile bit SCS                     @ ((unsigned)&OSCCON*8)+0;
volatile bit HXEN                     @ ((unsigned)&OSCCON*8)+1;
volatile bit T0OSCEN                     @ ((unsigned)&OSCCON*8)+7;
// bit and bitfield definitions
volatile bit CCP2M0                     @ ((unsigned)&CCP2CON*8)+0;
volatile bit CCP2M1                     @ ((unsigned)&CCP2CON*8)+1;
volatile bit CCP2M2                     @ ((unsigned)&CCP2CON*8)+2;
volatile bit CCP2M3                     @ ((unsigned)&CCP2CON*8)+3;
volatile bit DC2B0                     @ ((unsigned)&CCP2CON*8)+4;
volatile bit DC2B1                      @ ((unsigned)&CCP2CON*8)+5;
// bit and bitfield definitions
volatile bit CCP1M0                     @ ((unsigned)&CCP1CON*8)+0;
volatile bit CCP1M1                     @ ((unsigned)&CCP1CON*8)+1;
volatile bit CCP1M2                     @ ((unsigned)&CCP1CON*8)+2;
volatile bit CCP1M3                     @ ((unsigned)&CCP1CON*8)+3;
volatile bit DC1B0                     @ ((unsigned)&CCP1CON*8)+4;
volatile bit DC1B1                      @ ((unsigned)&CCP1CON*8)+5;
// bit and bitfield definitions
volatile bit ANSEL0                     @ ((unsigned)&ANSELL*8)+0;
volatile bit ANSEL1                     @ ((unsigned)&ANSELL*8)+1;
volatile bit ANSEL2                     @ ((unsigned)&ANSELL*8)+2;
volatile bit ANSEL3                     @ ((unsigned)&ANSELL*8)+3;
volatile bit ANSEL4                     @ ((unsigned)&ANSELL*8)+4;
volatile bit ANSEL6                      @ ((unsigned)&ANSELL*8)+6;
volatile bit ANSEL7                      @ ((unsigned)&ANSELL*8)+7;
// bit and bitfield definitions
volatile bit ANSEL8                     @ ((unsigned)&ANSELH*8)+0;
volatile bit ANSEL9                     @ ((unsigned)&ANSELH*8)+1;
volatile bit ANSEL10                     @ ((unsigned)&ANSELH*8)+2;
volatile bit ANSEL11                     @ ((unsigned)&ANSELH*8)+3;
volatile bit ANSEL12                     @ ((unsigned)&ANSELH*8)+4;
volatile bit ANSEL13                     @ ((unsigned)&ANSELH*8)+5;
volatile bit ANSEL14                      @ ((unsigned)&ANSELH*8)+6;
volatile bit ANSEL15                      @ ((unsigned)&ANSELH*8)+7;
// bit and bitfield definitions
volatile bit ADEN                     @ ((unsigned)&ADCON0*8)+0;
volatile bit ADON                     @ ((unsigned)&ADCON0*8)+1;
volatile bit CHS0                     @ ((unsigned)&ADCON0*8)+2;
volatile bit CHS1                     @ ((unsigned)&ADCON0*8)+3;
volatile bit CHS2                      @ ((unsigned)&ADCON0*8)+4;
volatile bit CHS3                      @ ((unsigned)&ADCON0*8)+5;
volatile bit VHS0                      @ ((unsigned)&ADCON0*8)+6;
volatile bit VHS1                      @ ((unsigned)&ADCON0*8)+7;
// bit and bitfield definitions
volatile bit ADREF                     @ ((unsigned)&ADCON1*8)+0;
volatile bit ADCS0                      @ ((unsigned)&ADCON1*8)+4;
volatile bit ADCS1                      @ ((unsigned)&ADCON1*8)+5;
volatile bit ADCS2                      @ ((unsigned)&ADCON1*8)+6;
volatile bit ADFM                      @ ((unsigned)&ADCON1*8)+7;
// bit and bitfield definitions
volatile bit WCOL                     @ ((unsigned)&SPSTAT*8)+0;
volatile bit MODF                     @ ((unsigned)&SPSTAT*8)+1;
volatile bit RXOV                     @ ((unsigned)&SPSTAT*8)+2;
// bit and bitfield definitions
volatile bit SPR0                     @ ((unsigned)&SPCTL*8)+0;
volatile bit SPR1                     @ ((unsigned)&SPCTL*8)+1;
volatile bit CPHA                     @ ((unsigned)&SPCTL*8)+2;
volatile bit CPOL                     @ ((unsigned)&SPCTL*8)+3;
volatile bit MSTR                     @ ((unsigned)&SPCTL*8)+4;
volatile bit DORD                     @ ((unsigned)&SPCTL*8)+5;
volatile bit SPEN                     @ ((unsigned)&SPCTL*8)+6;
volatile bit SSIG                     @ ((unsigned)&SPCTL*8)+7;
// bit and bitfield definitions
volatile bit SMOD0                     @ ((unsigned)&AUXR*8)+0;
volatile bit SMOD                     @ ((unsigned)&AUXR*8)+1;
volatile bit S1BRS                     @ ((unsigned)&AUXR*8)+2;
volatile bit BRTX12                     @ ((unsigned)&AUXR*8)+3;
volatile bit BRTR                      @ ((unsigned)&AUXR*8)+4;
volatile bit UARTM0                      @ ((unsigned)&AUXR*8)+5;
volatile bit UARTEN                      @ ((unsigned)&AUXR*8)+6;
// bit and bitfield definitions
volatile bit RXWK                     @ ((unsigned)&SCON*8)+1;
volatile bit RB8                     @ ((unsigned)&SCON*8)+2;
volatile bit TR8                     @ ((unsigned)&SCON*8)+3;
volatile bit REN                      @ ((unsigned)&SCON*8)+4;
volatile bit SM2                      @ ((unsigned)&SCON*8)+5;
volatile bit SM1                      @ ((unsigned)&SCON*8)+6;
volatile bit SM0                      @ ((unsigned)&SCON*8)+7;
// bit and bitfield definitions
volatile bit CK20                     @ ((unsigned)&PWM2C*8)+0;
volatile bit CK21                     @ ((unsigned)&PWM2C*8)+1;
volatile bit PWM2S0                     @ ((unsigned)&PWM2C*8)+2;
volatile bit PWM2S1                     @ ((unsigned)&PWM2C*8)+3;
// bit and bitfield definitions
volatile bit CK10                     @ ((unsigned)&PWM1C*8)+0;
volatile bit CK11                     @ ((unsigned)&PWM1C*8)+1;
volatile bit PWM1S0                     @ ((unsigned)&PWM1C*8)+2;
volatile bit PWM1S1                     @ ((unsigned)&PWM1C*8)+3;
// bit and bitfield definitions
volatile bit CK00                     @ ((unsigned)&PWM0C*8)+0;
volatile bit CK01                     @ ((unsigned)&PWM0C*8)+1;
volatile bit PWM0S0                     @ ((unsigned)&PWM0C*8)+2;
volatile bit PWM0S1                     @ ((unsigned)&PWM0C*8)+3;
volatile bit FLTC                      @ ((unsigned)&PWM0C*8)+4;
volatile bit FLTS                      @ ((unsigned)&PWM0C*8)+5;
// bit and bitfield definitions
volatile bit EPWM0                     @ ((unsigned)&PWMEN*8)+0;
volatile bit EPWM1                     @ ((unsigned)&PWMEN*8)+1;
volatile bit EPWM2                     @ ((unsigned)&PWMEN*8)+2;
volatile bit EPWM01                     @ ((unsigned)&PWMEN*8)+3;
volatile bit EPWM11                     @ ((unsigned)&PWMEN*8)+4;
volatile bit EPWM21                     @ ((unsigned)&PWMEN*8)+5;
volatile bit EFLT                      @ ((unsigned)&PWMEN*8)+6;
// bit and bitfield definitions
volatile bit FLT0M0                     @ ((unsigned)&FLTM*8)+0;
volatile bit FLT0M1                     @ ((unsigned)&FLTM*8)+1;
volatile bit FLT1M0                     @ ((unsigned)&FLTM*8)+2;
volatile bit FLT1M1                     @ ((unsigned)&FLTM*8)+3;
volatile bit FLT2M0                     @ ((unsigned)&FLTM*8)+4;
volatile bit FLT2M1                     @ ((unsigned)&FLTM*8)+5;
// bit and bitfield definitions
volatile bit RLCD0                     @ ((unsigned)&LCDCON*8)+0;
volatile bit RLCD1                     @ ((unsigned)&LCDCON*8)+1;
volatile bit CS0                     @ ((unsigned)&LCDCON*8)+2;
volatile bit CS1                     @ ((unsigned)&LCDCON*8)+3;
volatile bit DUTCT                     @ ((unsigned)&LCDCON*8)+5;
volatile bit BIASCT0                     @ ((unsigned)&LCDCON*8)+6;
volatile bit BIASCT1                     @ ((unsigned)&LCDCON*8)+7;
// bit and bitfield definitions
volatile bit LP0                     @ ((unsigned)&LCDPS*8)+0;
volatile bit LP1                     @ ((unsigned)&LCDPS*8)+1;
volatile bit LP2                     @ ((unsigned)&LCDPS*8)+2;
volatile bit LP3                     @ ((unsigned)&LCDPS*8)+3;
// bit and bitfield definitions
volatile bit DISPCT                     @ ((unsigned)&DISPCTR*8)+0;
volatile bit DISPON                     @ ((unsigned)&DISPCTR*8)+1;
volatile bit SLPENB                     @ ((unsigned)&DISPCTR*8)+2;
// bit and bitfield definitions
volatile bit LCDVD0                     @ ((unsigned)&LCDLVD*8)+0;
volatile bit LCDVD1                     @ ((unsigned)&LCDLVD*8)+1;
volatile bit LCDVD2                     @ ((unsigned)&LCDLVD*8)+2;
volatile bit LCDVD3                     @ ((unsigned)&LCDLVD*8)+3;
#endif

