
#ifndef	_HTC_H_
#endif

/* header file for the MICROCHIP PIC microcontroller
 *  16C54A
 */


#ifndef __18m002_H
#define __18m002_H


// Special function register definitions
//
//----- BANK0 Register -----------------------------------------------------
volatile   unsigned char           INDF0               @ 0x000;
volatile   unsigned char           INDF1               @ 0x001;
volatile   unsigned char           PCL                 @ 0x002;
volatile   unsigned char           STATUS              @ 0x003;
volatile   unsigned char           FSR0L               @ 0x004;
volatile   unsigned char           FSR0H               @ 0x005;
volatile   unsigned char           FSR1L               @ 0x006;
volatile  unsigned char            FSR1H               @ 0x007;
volatile  unsigned char            PCLATH              @ 0x008;
volatile  unsigned char            INTCON              @ 0x009;

volatile  unsigned char           TRISA               @ 0x010;
volatile  unsigned char           TRISB               @ 0x011;
volatile  unsigned char           TRISC               @ 0x012;
volatile  unsigned char           TRISD               @ 0x013;
volatile  unsigned char           PORTA               @ 0x01C;
volatile  unsigned char           PORTB               @ 0x01D;
volatile  unsigned char           PORTC               @ 0x01E;
volatile  unsigned char           PORTD               @ 0x01F;
volatile  unsigned char           WPUA                @ 0x028;
volatile  unsigned char           WPUB                @ 0x029;
volatile  unsigned char           WPUC                @ 0x02A;
volatile  unsigned char           WPUD                @ 0x02B;
volatile  unsigned char           WPDA                @ 0x034;
volatile  unsigned char           WPDB                @ 0x035;
volatile  unsigned char           WPDC                @ 0x036;
volatile  unsigned char           WPDD                @ 0x037;
volatile  unsigned char           IOCB                @ 0x038;
volatile  unsigned char           PIR1                @ 0x054;
volatile  unsigned char           PIR2                @ 0x055;
volatile  unsigned char           T1L                 @ 0x058;
volatile  unsigned char           T1H                 @ 0x059;
volatile  unsigned char           T1CON               @ 0x05A;
volatile  unsigned char           T0                  @ 0x05B;
volatile  unsigned char           T2                  @ 0x05C;
volatile  unsigned char           PR2                 @ 0x05D;
volatile  unsigned char           T2CON               @ 0x05E;
volatile  unsigned char           PR1L                @ 0x05F;
volatile  unsigned char           PR1CON              @ 0x060;
volatile  unsigned char           PIE1                @ 0x070;
volatile  unsigned char           PIE2                @ 0x071;
volatile  unsigned char           OPTION              @ 0x078;
volatile  unsigned char           PCON                @ 0x079;
volatile  unsigned char           OSCCON              @ 0x07A;
volatile  unsigned char           OSCRDY              @ 0x07B;
volatile  unsigned char           TRMEN               @ 0x07C;
volatile  unsigned char           TRMV                @ 0x07D;
volatile  unsigned char           ANSELA              @ 0x08C;
volatile  unsigned char           ANSELB              @ 0x08D;
volatile  unsigned char           ANSELC              @ 0x08E;
volatile  unsigned char           ANSELD              @ 0x08F;
volatile  unsigned char           ADRESL              @ 0x092;
volatile  unsigned char           ADRESH              @ 0x093;
volatile  unsigned char           ADCON0              @ 0x094;
volatile  unsigned char           ADCON1              @ 0x095;
volatile  unsigned char           ADCLK               @ 0x096;
volatile  unsigned char           PMDATL              @ 0x09A;
volatile  unsigned char           PMDATH              @ 0x09B;
volatile  unsigned char           PMADRL              @ 0x09C;
volatile  unsigned char           PMADRH              @ 0x09D;
volatile  unsigned char           PMCON               @ 0x09E;
volatile  unsigned char           PFGCON              @ 0x0A6;
volatile  unsigned char           PFGADH              @ 0x0A7;
volatile  unsigned char           PFGADL              @ 0x0A8;
volatile  unsigned char           RBCSEL              @ 0x0A9;
volatile  unsigned char           CTKCLK              @ 0x0AB;
volatile  unsigned char           DSCR                @ 0x0AC;
volatile  unsigned char           TMODCON             @ 0x0AD;
volatile  unsigned char           CTKCON              @ 0x0AE;
volatile  unsigned char           CTKCHS              @ 0x0B0;
volatile  unsigned char           CDCRL               @ 0x0B3;
volatile  unsigned char           CDCRH               @ 0x0B4;
volatile  unsigned char           EEPCON              @ 0x0B8;
volatile  unsigned char           EEPDAT              @ 0x0B9;
volatile  unsigned char           EEPADR              @ 0x0BA;
volatile  unsigned char           EEPREFLESH          @ 0x0BB;
volatile  unsigned char           BORC                @ 0x0C0;
volatile  unsigned char           BORDBC              @ 0x0C1;
volatile  unsigned char           RSTFR               @ 0x0C2;
volatile  unsigned char           SLEWC               @ 0x0C8;
volatile  unsigned char           UARTMAP             @ 0x0C9;
volatile  unsigned char           IICMAP              @ 0x0CA;
volatile  unsigned char           SPIMAP              @ 0x0CB;
volatile  unsigned char           INTMAP              @ 0x0CC;
volatile  unsigned char           PWMMAP              @ 0x0CD;
volatile  unsigned char           PWMEN               @ 0x0D0;
volatile  unsigned char           FLTMODE             @ 0x0D1;
volatile  unsigned char           PWMM                @ 0x0D2;
volatile  unsigned char           PWM0C               @ 0x0D3;
volatile  unsigned char           PWM0PL			  @ 0x0D8;
volatile  unsigned char           PWM0PH              @ 0x0D9;
volatile  unsigned char           PWM0DL              @ 0x0DA;
volatile  unsigned char           PWM0DH              @ 0x0DB;
volatile  unsigned char           PWM0DTL             @ 0x0DC;
volatile  unsigned char           PWM0DTH             @ 0x0DD;
volatile  unsigned char           itemp               @ 0x100;
volatile  unsigned char           OCCUPY18A           @ 0x18A;
//----- BANK1 Register -----------------------------------------------------
volatile  unsigned char           SCON				  @ 0x230;
volatile  unsigned char           SCON2               @ 0x231;
volatile  unsigned char           SBUF                @ 0x232;
volatile  unsigned char           BRTL                @ 0x235;
volatile  unsigned char           BRTH                @ 0x236;
volatile  unsigned char           SPCTL               @ 0x238;
volatile  unsigned char           SPSTAT              @ 0x239;
volatile  unsigned char           SPDAT               @ 0x23A;
volatile  unsigned char           IICCON              @ 0x240;
volatile  unsigned char           IICSTA              @ 0x241;
volatile  unsigned char           IICDAT              @ 0x242;
volatile  unsigned char           IICADR              @ 0x243;

volatile  unsigned char           break0              @ 0x0250;
volatile  unsigned char           break1              @ 0x0251;
volatile  unsigned char           break2              @ 0x0252;
volatile  unsigned char           break3              @ 0x0253;
volatile  unsigned char           break4              @ 0x0254;
volatile  unsigned char           break5              @ 0x0255;
volatile  unsigned char           break6              @ 0x0256;
volatile  unsigned char           break7              @ 0x0257;
volatile  unsigned char           break8              @ 0x0258;
volatile  unsigned char           break9              @ 0x0259;

//----- BANK1 Register -----------------------------------------------------
//----- BANK1 Register -----------------------------------------------------
// bit and bitfield definitions
volatile bit RBIF                     @ ((unsigned)&INTCON*8)+0;
volatile bit INTF                     @ ((unsigned)&INTCON*8)+1;
volatile bit T0IF                     @ ((unsigned)&INTCON*8)+2;
volatile bit RBIE                     @ ((unsigned)&INTCON*8)+3;
volatile bit INTE                     @ ((unsigned)&INTCON*8)+4;
volatile bit T0IE                     @ ((unsigned)&INTCON*8)+5;
volatile bit PEIE                     @ ((unsigned)&INTCON*8)+6;
volatile bit GIE                     @ ((unsigned)&INTCON*8)+7;
// bit and bitfield definitions
volatile bit C                     @ ((unsigned)&STATUS*8)+0;
volatile bit DC                     @ ((unsigned)&STATUS*8)+1;
volatile bit Z                     @ ((unsigned)&STATUS*8)+2;
volatile bit PD                     @ ((unsigned)&STATUS*8)+3;
volatile bit TO                     @ ((unsigned)&STATUS*8)+4;
volatile bit RP0                     @ ((unsigned)&STATUS*8)+5;

// bit and bitfield definitions
volatile bit TRISA0					@ ((unsigned)&TRISA*8)+0;
volatile bit TRISA1					@ ((unsigned)&TRISA*8)+1;
volatile bit TRISA2					@ ((unsigned)&TRISA*8)+2;
volatile bit TRISA3					@ ((unsigned)&TRISA*8)+3;
volatile bit TRISA4					@ ((unsigned)&TRISA*8)+4;
volatile bit TRISA5					@ ((unsigned)&TRISA*8)+5;
volatile bit TRISA6					@ ((unsigned)&TRISA*8)+6;
volatile bit TRISA7					@ ((unsigned)&TRISA*8)+7;
// bit and bitfield definitions
volatile bit TRISB0					@ ((unsigned)&TRISB*8)+0;
volatile bit TRISB1					@ ((unsigned)&TRISB*8)+1;
volatile bit TRISB2					@ ((unsigned)&TRISB*8)+2;
volatile bit TRISB3					@ ((unsigned)&TRISB*8)+3;
volatile bit TRISB4					@ ((unsigned)&TRISB*8)+4;
volatile bit TRISB5					@ ((unsigned)&TRISB*8)+5;
volatile bit TRISB6					@ ((unsigned)&TRISB*8)+6;
volatile bit TRISB7					@ ((unsigned)&TRISB*8)+7;
// bit and bitfield definitions
volatile bit TRISC0					@ ((unsigned)&TRISC*8)+0;
volatile bit TRISC1					@ ((unsigned)&TRISC*8)+1;
volatile bit TRISC2					@ ((unsigned)&TRISC*8)+2;
volatile bit TRISC3					@ ((unsigned)&TRISC*8)+3;
volatile bit TRISC4					@ ((unsigned)&TRISC*8)+4;
volatile bit TRISC5					@ ((unsigned)&TRISC*8)+5;
volatile bit TRISC6					@ ((unsigned)&TRISC*8)+6;
volatile bit TRISC7					@ ((unsigned)&TRISC*8)+7;
// bit and bitfield definitions
volatile bit TRISD4					@ ((unsigned)&TRISD*8)+4;
volatile bit TRISD5					@ ((unsigned)&TRISD*8)+5;
// bit and bitfield definitions
volatile bit PORTA0					@ ((unsigned)&PORTA*8)+0;
volatile bit PORTA1					@ ((unsigned)&PORTA*8)+1;
volatile bit PORTA2					@ ((unsigned)&PORTA*8)+2;
volatile bit PORTA3					@ ((unsigned)&PORTA*8)+3;
volatile bit PORTA4					@ ((unsigned)&PORTA*8)+4;
volatile bit PORTA5					@ ((unsigned)&PORTA*8)+5;
volatile bit PORTA6					@ ((unsigned)&PORTA*8)+6;
volatile bit PORTA7					@ ((unsigned)&PORTA*8)+7;
// bit and bitfield definitions
volatile bit PORTB0					@ ((unsigned)&PORTB*8)+0;
volatile bit PORTB1					@ ((unsigned)&PORTB*8)+1;
volatile bit PORTB2					@ ((unsigned)&PORTB*8)+2;
volatile bit PORTB3					@ ((unsigned)&PORTB*8)+3;
volatile bit PORTB4					@ ((unsigned)&PORTB*8)+4;
volatile bit PORTB5					@ ((unsigned)&PORTB*8)+5;
volatile bit PORTB6					@ ((unsigned)&PORTB*8)+6;
volatile bit PORTB7					@ ((unsigned)&PORTB*8)+7;
// bit and bitfield definitions
volatile bit PORTC0					@ ((unsigned)&PORTC*8)+0;
volatile bit PORTC1					@ ((unsigned)&PORTC*8)+1;
volatile bit PORTC2					@ ((unsigned)&PORTC*8)+2;
volatile bit PORTC3					@ ((unsigned)&PORTC*8)+3;
volatile bit PORTC4					@ ((unsigned)&PORTC*8)+4;
volatile bit PORTC5					@ ((unsigned)&PORTC*8)+5;
volatile bit PORTC6					@ ((unsigned)&PORTC*8)+6;
volatile bit PORTC7					@ ((unsigned)&PORTC*8)+7;
// bit and bitfield definitions
volatile bit PORTD4					@ ((unsigned)&PORTD*8)+4;
volatile bit PORTD5					@ ((unsigned)&PORTD*8)+5;
// bit and bitfield definitions
volatile bit WPUA0					@ ((unsigned)&WPUA*8)+0;
volatile bit WPUA1					@ ((unsigned)&WPUA*8)+1;
volatile bit WPUA2					@ ((unsigned)&WPUA*8)+2;
volatile bit WPUA3					@ ((unsigned)&WPUA*8)+3;
volatile bit WPUA4					@ ((unsigned)&WPUA*8)+4;
volatile bit WPUA5					@ ((unsigned)&WPUA*8)+5;
volatile bit WPUA6					@ ((unsigned)&WPUA*8)+6;
volatile bit WPUA7					@ ((unsigned)&WPUA*8)+7;
// bit and bitfield definitions
volatile bit WPUB0					@ ((unsigned)&WPUB*8)+0;
volatile bit WPUB1					@ ((unsigned)&WPUB*8)+1;
volatile bit WPUB2					@ ((unsigned)&WPUB*8)+2;
volatile bit WPUB3					@ ((unsigned)&WPUB*8)+3;
volatile bit WPUB4					@ ((unsigned)&WPUB*8)+4;
volatile bit WPUB5					@ ((unsigned)&WPUB*8)+5;
volatile bit WPUB6					@ ((unsigned)&WPUB*8)+6;
volatile bit WPUB7					@ ((unsigned)&WPUB*8)+7;
// bit and bitfield definitions
volatile bit WPUC0					@ ((unsigned)&WPUC*8)+0;
volatile bit WPUC1					@ ((unsigned)&WPUC*8)+1;
volatile bit WPUC2					@ ((unsigned)&WPUC*8)+2;
volatile bit WPUC3					@ ((unsigned)&WPUC*8)+3;
volatile bit WPUC4					@ ((unsigned)&WPUC*8)+4;
volatile bit WPUC5					@ ((unsigned)&WPUC*8)+5;
volatile bit WPUC6					@ ((unsigned)&WPUC*8)+6;
volatile bit WPUC7					@ ((unsigned)&WPUC*8)+7;
// bit and bitfield definitions
volatile bit WPUD4					@ ((unsigned)&WPUD*8)+4;
volatile bit WPUD5					@ ((unsigned)&WPUD*8)+5;
// bit and bitfield definitions
volatile bit WPDA0					@ ((unsigned)&WPDA*8)+0;
volatile bit WPDA1					@ ((unsigned)&WPDA*8)+1;
volatile bit WPDA2					@ ((unsigned)&WPDA*8)+2;
volatile bit WPDA3					@ ((unsigned)&WPDA*8)+3;
volatile bit WPDA4					@ ((unsigned)&WPDA*8)+4;
volatile bit WPDA5					@ ((unsigned)&WPDA*8)+5;
volatile bit WPDA6					@ ((unsigned)&WPDA*8)+6;
volatile bit WPDA7					@ ((unsigned)&WPDA*8)+7;
// bit and bitfield definitions
volatile bit WPDB0					@ ((unsigned)&WPDB*8)+0;
volatile bit WPDB1					@ ((unsigned)&WPDB*8)+1;
volatile bit WPDB2					@ ((unsigned)&WPDB*8)+2;
volatile bit WPDB3					@ ((unsigned)&WPDB*8)+3;
volatile bit WPDB4					@ ((unsigned)&WPDB*8)+4;
volatile bit WPDB5					@ ((unsigned)&WPDB*8)+5;
volatile bit WPDB6					@ ((unsigned)&WPDB*8)+6;
volatile bit WPDB7					@ ((unsigned)&WPDB*8)+7;
// bit and bitfield definitions
volatile bit WPDC0					@ ((unsigned)&WPDC*8)+0;
volatile bit WPDC1					@ ((unsigned)&WPDC*8)+1;
volatile bit WPDC2					@ ((unsigned)&WPDC*8)+2;
volatile bit WPDC3					@ ((unsigned)&WPDC*8)+3;
volatile bit WPDC4					@ ((unsigned)&WPDC*8)+4;
volatile bit WPDC5					@ ((unsigned)&WPDC*8)+5;
volatile bit WPDC6					@ ((unsigned)&WPDC*8)+6;
volatile bit WPDC7					@ ((unsigned)&WPDC*8)+7;
// bit and bitfield definitions
volatile bit WPDD4					@ ((unsigned)&WPDD*8)+4;
volatile bit WPDD5					@ ((unsigned)&WPDD*8)+5;
// bit and bitfield definitions
volatile bit IOCB0					@ ((unsigned)&IOCB*8)+0;
volatile bit IOCB1					@ ((unsigned)&IOCB*8)+1;
volatile bit IOCB2					@ ((unsigned)&IOCB*8)+2;
volatile bit IOCB3					@ ((unsigned)&IOCB*8)+3;
volatile bit IOCB4					@ ((unsigned)&IOCB*8)+4;
volatile bit IOCB5					@ ((unsigned)&IOCB*8)+5;
volatile bit IOCB6					@ ((unsigned)&IOCB*8)+6;
volatile bit IOCB7					@ ((unsigned)&IOCB*8)+7;
// bit and bitfield definitions
volatile bit T1IF					@ ((unsigned)&PIR1*8)+0;
volatile bit T2IF					@ ((unsigned)&PIR1*8)+1;
volatile bit IICIF					@ ((unsigned)&PIR1*8)+3;
volatile bit SPIIF					@ ((unsigned)&PIR1*8)+4;
volatile bit MODF					@ ((unsigned)&PIR1*8)+5;
volatile bit ADIF					@ ((unsigned)&PIR1*8)+6;
// bit and bitfield definitions
volatile bit EEPIF					@ ((unsigned)&PIR2*8)+1;
volatile bit TXIF					@ ((unsigned)&PIR2*8)+2;
volatile bit RXIF					@ ((unsigned)&PIR2*8)+3;
volatile bit PWM0IF					@ ((unsigned)&PIR2*8)+5;
volatile bit WDTIF					@ ((unsigned)&PIR2*8)+6;
volatile bit CTKIF 					@ ((unsigned)&PIR2*8)+7;
// bit and bitfield definitions
volatile bit T1ON					@ ((unsigned)&T1CON*8)+0;
volatile bit T1SYNC					@ ((unsigned)&T1CON*8)+2;
volatile bit T1OSCEN				@ ((unsigned)&T1CON*8)+3;
volatile bit T1CKPS0				@ ((unsigned)&T1CON*8)+4;
volatile bit T1CKPS1				@ ((unsigned)&T1CON*8)+5;
volatile bit T1CS0					@ ((unsigned)&T1CON*8)+6;
volatile bit T1CS1					@ ((unsigned)&T1CON*8)+7;
// bit and bitfield definitions
volatile bit T2ON					@ ((unsigned)&T2CON*8)+2;
volatile bit T2CKPS0				@ ((unsigned)&T2CON*8)+3;
volatile bit T2CKPS1				@ ((unsigned)&T2CON*8)+4;
volatile bit T2CKPS2				@ ((unsigned)&T2CON*8)+5;
volatile bit T2CKPS3				@ ((unsigned)&T2CON*8)+6;
// bit and bitfield definitions
volatile bit T1CKPS2				@ ((unsigned)&PR1CON*8)+2;
volatile bit T1CKPS3				@ ((unsigned)&PR1CON*8)+3;
// bit and bitfield definitions
volatile bit T1IE					@ ((unsigned)&PIE1*8)+0;
volatile bit T2IE					@ ((unsigned)&PIE1*8)+1;
volatile bit IICIE					@ ((unsigned)&PIE1*8)+3;
volatile bit SPIIE					@ ((unsigned)&PIE1*8)+4;
volatile bit ADIE					@ ((unsigned)&PIE1*8)+6;
// bit and bitfield definitions
volatile bit EEPIE					@ ((unsigned)&PIE2*8)+1;
volatile bit UARTIE					@ ((unsigned)&PIE2*8)+2;
volatile bit PWM0IE					@ ((unsigned)&PIE2*8)+5;
volatile bit WDTIE					@ ((unsigned)&PIE2*8)+6;
volatile bit CTKIE					@ ((unsigned)&PIE2*8)+7;
// bit and bitfield definitions
volatile bit PS0					@ ((unsigned)&OPTION*8)+0;
volatile bit PS1					@ ((unsigned)&OPTION*8)+1;
volatile bit PS2					@ ((unsigned)&OPTION*8)+2;
volatile bit PSA					@ ((unsigned)&OPTION*8)+3;
volatile bit T0SE					@ ((unsigned)&OPTION*8)+4;
volatile bit T0CS					@ ((unsigned)&OPTION*8)+5;
volatile bit INTEDG					@ ((unsigned)&OPTION*8)+6;
volatile bit RBPUB					@ ((unsigned)&OPTION*8)+7;
// bit and bitfield definitions
volatile bit WDTENS					@ ((unsigned)&PCON*8)+4;
// bit and bitfield definitions
volatile bit SCS					@ ((unsigned)&OSCCON*8)+0;
volatile bit CPU_DIV0				@ ((unsigned)&OSCCON*8)+1;
volatile bit CPU_DIV1				@ ((unsigned)&OSCCON*8)+2;
volatile bit CPU_DIV2				@ ((unsigned)&OSCCON*8)+3;
volatile bit HXEN					@ ((unsigned)&OSCCON*8)+4;
volatile bit RC32M_DIV0				@ ((unsigned)&OSCCON*8)+5;
volatile bit RC32M_DIV1				@ ((unsigned)&OSCCON*8)+6;
volatile bit T0OSCEN				@ ((unsigned)&OSCCON*8)+7;
// bit and bitfield definitions
volatile bit LSRCRDY				@ ((unsigned)&OSCRDY*8)+0;
volatile bit HSRCRDY				@ ((unsigned)&OSCRDY*8)+1;
// bit and bitfield definitions
volatile bit RCTRMEN				@ ((unsigned)&TRMEN*8)+0;
// bit and bitfield definitions
volatile bit ANSELA0				@ ((unsigned)&ANSELA*8)+0;
volatile bit ANSELA1				@ ((unsigned)&ANSELA*8)+1;
volatile bit ANSELA2				@ ((unsigned)&ANSELA*8)+2;
volatile bit ANSELA3				@ ((unsigned)&ANSELA*8)+3;
volatile bit ANSELA4				@ ((unsigned)&ANSELA*8)+4;
volatile bit ANSELA5				@ ((unsigned)&ANSELA*8)+5;
volatile bit ANSELA6				@ ((unsigned)&ANSELA*8)+6;
volatile bit ANSELA7				@ ((unsigned)&ANSELA*8)+7;
// bit and bitfield definitions
volatile bit ANSELB0				@ ((unsigned)&ANSELB*8)+0;
volatile bit ANSELB1				@ ((unsigned)&ANSELB*8)+1;
volatile bit ANSELB2				@ ((unsigned)&ANSELB*8)+2;
volatile bit ANSELB3				@ ((unsigned)&ANSELB*8)+3;
volatile bit ANSELB4				@ ((unsigned)&ANSELB*8)+4;
volatile bit ANSELB5				@ ((unsigned)&ANSELB*8)+5;
volatile bit ANSELB6				@ ((unsigned)&ANSELB*8)+6;
volatile bit ANSELB7				@ ((unsigned)&ANSELB*8)+7;
// bit and bitfield definitions
volatile bit ANSELC0				@ ((unsigned)&ANSELC*8)+0;
volatile bit ANSELC1				@ ((unsigned)&ANSELC*8)+1;
volatile bit ANSELC2				@ ((unsigned)&ANSELC*8)+2;
volatile bit ANSELC3				@ ((unsigned)&ANSELC*8)+3;
volatile bit ANSELC4				@ ((unsigned)&ANSELC*8)+4;
volatile bit ANSELC5				@ ((unsigned)&ANSELC*8)+5;
volatile bit ANSELC6				@ ((unsigned)&ANSELC*8)+6;
volatile bit ANSELC7				@ ((unsigned)&ANSELC*8)+7;
// bit and bitfield definitions
volatile bit ANSELD4				@ ((unsigned)&ANSELD*8)+4;
volatile bit ANSELD5				@ ((unsigned)&ANSELD*8)+5;
// bit and bitfield definitions
volatile bit ADEN					@ ((unsigned)&ADCON0*8)+0;
volatile bit ADON					@ ((unsigned)&ADCON0*8)+1;
volatile bit CHS0					@ ((unsigned)&ADCON0*8)+2;
volatile bit CHS1					@ ((unsigned)&ADCON0*8)+3;
volatile bit CHS2					@ ((unsigned)&ADCON0*8)+4;
volatile bit CHS3					@ ((unsigned)&ADCON0*8)+5;
// bit and bitfield definitions
volatile bit VREFS					@ ((unsigned)&ADCON1*8)+0;
volatile bit INREFS0				@ ((unsigned)&ADCON1*8)+1;
volatile bit INREFS1				@ ((unsigned)&ADCON1*8)+2;
volatile bit INREFS2				@ ((unsigned)&ADCON1*8)+3;
volatile bit ADCS0					@ ((unsigned)&ADCON1*8)+4;
volatile bit ADCS1					@ ((unsigned)&ADCON1*8)+5;
volatile bit ADCS2					@ ((unsigned)&ADCON1*8)+6;
volatile bit ADFM					@ ((unsigned)&ADCON1*8)+7;
// bit and bitfield definitions
volatile bit ADCLK0					@ ((unsigned)&ADCLK*8)+0;
volatile bit ADCLK1					@ ((unsigned)&ADCLK*8)+1;
volatile bit ADCLK2					@ ((unsigned)&ADCLK*8)+2;
// bit and bitfield definitions
volatile bit RDON					@ ((unsigned)&PMCON*8)+0;
// bit and bitfield definitions
volatile bit PFGCF0					@ ((unsigned)&PFGCON*8)+5;
volatile bit PFGCF1					@ ((unsigned)&PFGCON*8)+6;
volatile bit PFGEN					@ ((unsigned)&PFGCON*8)+7;
// bit and bitfield definitions
volatile bit PFGADH0				@ ((unsigned)&PFGADH*8)+0;
volatile bit PFGADH1				@ ((unsigned)&PFGADH*8)+1;
volatile bit PFGADH2				@ ((unsigned)&PFGADH*8)+2;
volatile bit PFGADH3				@ ((unsigned)&PFGADH*8)+3;
volatile bit PFGADH4				@ ((unsigned)&PFGADH*8)+4;
volatile bit PFGADH5				@ ((unsigned)&PFGADH*8)+5;
volatile bit PFGADH6				@ ((unsigned)&PFGADH*8)+6;
// bit and bitfield definitions
volatile bit PFGADL0				@ ((unsigned)&PFGADL*8)+0;
volatile bit PFGADL1				@ ((unsigned)&PFGADL*8)+1;
volatile bit PFGADL2				@ ((unsigned)&PFGADL*8)+2;
volatile bit PFGADL3				@ ((unsigned)&PFGADL*8)+3;
volatile bit PFGADL4				@ ((unsigned)&PFGADL*8)+4;
volatile bit PFGADL5				@ ((unsigned)&PFGADL*8)+5;
// bit and bitfield definitions
volatile bit RBSEL0				@ ((unsigned)&RBCSEL*8)+0;
volatile bit RBSEL1				@ ((unsigned)&RBCSEL*8)+1;
volatile bit RBSEL2				@ ((unsigned)&RBCSEL*8)+2;
volatile bit RBSEL3				@ ((unsigned)&RBCSEL*8)+3;
volatile bit CMODS				@ ((unsigned)&RBCSEL*8)+7;
// bit and bitfield definitions
volatile bit PRSDIV0				@ ((unsigned)&CTKCLK*8)+0;
volatile bit PRSDIV1				@ ((unsigned)&CTKCLK*8)+1;
volatile bit PRSDIV2				@ ((unsigned)&CTKCLK*8)+2;
volatile bit PN_EN				    @ ((unsigned)&CTKCLK*8)+3;
volatile bit CTKDS4			     	@ ((unsigned)&CTKCLK*8)+4;
volatile bit CTKDS5				    @ ((unsigned)&CTKCLK*8)+5;
// bit and bitfield definitions
volatile bit TMOD_SEL				@ ((unsigned)&TMODCON*8)+0;
volatile bit TMOD_EN			    @ ((unsigned)&TMODCON*8)+4;
// bit and bitfield definitions
volatile bit CTKST				    @ ((unsigned)&CTKCON*8)+6;
volatile bit CTKON				    @ ((unsigned)&CTKCON*8)+7;
// bit and bitfield definitions
volatile bit RD						@ ((unsigned)&EEPCON*8)+0;
volatile bit WR						@ ((unsigned)&EEPCON*8)+1;
volatile bit WREN					@ ((unsigned)&EEPCON*8)+2;
volatile bit WPEER					@ ((unsigned)&EEPCON*8)+3;
volatile bit EEPEN					@ ((unsigned)&EEPCON*8)+7;
// bit and bitfield definitions
volatile bit BORVS0					@ ((unsigned)&BORC*8)+0;
volatile bit BORVS1					@ ((unsigned)&BORC*8)+1;
volatile bit BORVS2					@ ((unsigned)&BORC*8)+2;
volatile bit BORDBCEN				@ ((unsigned)&BORC*8)+6;
volatile bit BOREN					@ ((unsigned)&BORC*8)+7;
// bit and bitfield definitions
volatile bit WDTRF					@ ((unsigned)&RSTFR*8)+4;
volatile bit BORF					@ ((unsigned)&RSTFR*8)+5;
volatile bit EXRSTF					@ ((unsigned)&RSTFR*8)+6;
volatile bit PORF					@ ((unsigned)&RSTFR*8)+7;
// bit and bitfield definitions
volatile bit SLEWC0					@ ((unsigned)&SLEWC*8)+0;
volatile bit SLEWC1					@ ((unsigned)&SLEWC*8)+1;
// bit and bitfield definitions
volatile bit TXDMAP0				@ ((unsigned)&UARTMAP*8)+0;
volatile bit TXDMAP1				@ ((unsigned)&UARTMAP*8)+1;
volatile bit TXDMAP2				@ ((unsigned)&UARTMAP*8)+2;
volatile bit RXDMAP0				@ ((unsigned)&UARTMAP*8)+4;
volatile bit RXDMAP1				@ ((unsigned)&UARTMAP*8)+5;
volatile bit RXDMAP2				@ ((unsigned)&UARTMAP*8)+6;
// bit and bitfield definitions
volatile bit SDAMAP0				@ ((unsigned)&IICMAP*8)+0;
volatile bit SDAMAP1				@ ((unsigned)&IICMAP*8)+1;
volatile bit SDAMAP2				@ ((unsigned)&IICMAP*8)+2;
volatile bit SLKMAP0				@ ((unsigned)&IICMAP*8)+4;
volatile bit SLKMAP1				@ ((unsigned)&IICMAP*8)+5;
volatile bit SLKMAP2				@ ((unsigned)&IICMAP*8)+6;
// bit and bitfield definitions
volatile bit MISOMAP0				@ ((unsigned)&SPIMAP*8)+0;
volatile bit MISOMAP1				@ ((unsigned)&SPIMAP*8)+1;
volatile bit MOSIMAP0				@ ((unsigned)&SPIMAP*8)+2;
volatile bit MOSIMAP1				@ ((unsigned)&SPIMAP*8)+3;
volatile bit SCKMAP0				@ ((unsigned)&SPIMAP*8)+4;
volatile bit SCKMAP1				@ ((unsigned)&SPIMAP*8)+5;
volatile bit SSMAP0					@ ((unsigned)&SPIMAP*8)+6;
volatile bit SSMAP1					@ ((unsigned)&SPIMAP*8)+7;
// bit and bitfield definitions
volatile bit INTMAP0				@ ((unsigned)&INTMAP*8)+0;
volatile bit INTMAP1				@ ((unsigned)&INTMAP*8)+1;
volatile bit INTMAP2				@ ((unsigned)&INTMAP*8)+2;
volatile bit PFGMAP0				@ ((unsigned)&INTMAP*8)+4;
volatile bit PFGMAP1				@ ((unsigned)&INTMAP*8)+5;
volatile bit PFGMAP2				@ ((unsigned)&INTMAP*8)+6;
// bit and bitfield definitions
volatile bit PWM0MAP0				@ ((unsigned)&PWMMAP*8)+0;
volatile bit PWM0MAP1				@ ((unsigned)&PWMMAP*8)+1;
volatile bit PWM0MAP2				@ ((unsigned)&PWMMAP*8)+2;
volatile bit PWM01MAP0				@ ((unsigned)&PWMMAP*8)+4;
volatile bit PWM01MAP1				@ ((unsigned)&PWMMAP*8)+5;
volatile bit PWM01MAP2				@ ((unsigned)&PWMMAP*8)+6;
// bit and bitfield definitions
volatile bit PWM0EN					@ ((unsigned)&PWMEN*8)+0;
volatile bit PWM01EN				@ ((unsigned)&PWMEN*8)+4;
// bit and bitfield definitions
volatile bit FLT0_MODE0				@ ((unsigned)&FLTMODE*8)+0;
volatile bit FLT0_MODE1				@ ((unsigned)&FLTMODE*8)+1;
volatile bit EFLT0					@ ((unsigned)&FLTMODE*8)+6;
// bit and bitfield definitions
volatile bit RELOAD0				@ ((unsigned)&PWMM*8)+0;
volatile bit PWM0M					@ ((unsigned)&PWMM*8)+4;
// bit and bitfield definitions
volatile bit CK0					@ ((unsigned)&PWM0C*8)+0;
volatile bit CK1					@ ((unsigned)&PWM0C*8)+1;
volatile bit PWM0S0					@ ((unsigned)&PWM0C*8)+2;
volatile bit PWM0S1					@ ((unsigned)&PWM0C*8)+3;
volatile bit FLT0C					@ ((unsigned)&PWM0C*8)+4;
volatile bit FLT0S					@ ((unsigned)&PWM0C*8)+5;
// bit and bitfield definitions
volatile bit RB8					@ ((unsigned)&SCON*8)+2;
volatile bit TB8					@ ((unsigned)&SCON*8)+3;
volatile bit REN					@ ((unsigned)&SCON*8)+4;
volatile bit TXCOL					@ ((unsigned)&SCON*8)+5;
volatile bit RXROV					@ ((unsigned)&SCON*8)+6;
volatile bit FE						@ ((unsigned)&SCON*8)+7;
// bit and bitfield definitions
volatile bit SM2					@ ((unsigned)&SCON2*8)+0;
volatile bit SM1					@ ((unsigned)&SCON2*8)+1;
volatile bit BRTR					@ ((unsigned)&SCON2*8)+5;
// bit and bitfield definitions
volatile bit SPR0					@ ((unsigned)&SPCTL*8)+0;
volatile bit SPR1					@ ((unsigned)&SPCTL*8)+1;
volatile bit CPHA					@ ((unsigned)&SPCTL*8)+2;
volatile bit CPOL					@ ((unsigned)&SPCTL*8)+3;
volatile bit MSTR					@ ((unsigned)&SPCTL*8)+4;
volatile bit DODR					@ ((unsigned)&SPCTL*8)+5;
volatile bit SPEN					@ ((unsigned)&SPCTL*8)+6;
volatile bit SSIG					@ ((unsigned)&SPCTL*8)+7;
// bit and bitfield definitions
volatile bit RXOV					@ ((unsigned)&SPSTAT*8)+5;
volatile bit WCOL					@ ((unsigned)&SPSTAT*8)+6;
// bit and bitfield definitions
volatile bit CR0					@ ((unsigned)&IICCON*8)+0;
volatile bit CR1					@ ((unsigned)&IICCON*8)+1;
volatile bit AA						@ ((unsigned)&IICCON*8)+2;
volatile bit STO					@ ((unsigned)&IICCON*8)+4;
volatile bit STA					@ ((unsigned)&IICCON*8)+5;
volatile bit IICEN					@ ((unsigned)&IICCON*8)+6;
volatile bit CR2					@ ((unsigned)&IICCON*8)+7;
// bit and bitfield definitions
volatile bit GC						@ ((unsigned)&IICADR*8)+0;
#endif





