
#ifndef	_HTC_H_
#endif

/* header file for the MICROCHIP PIC microcontroller
 *  16C54A
 */


#ifndef __PIC18P100B0_H
#define __PIC18P100B0_H


// Special function register definitions
//
//----- BANK0 Register -----------------------------------------------------
volatile   unsigned char           INDF                @ 0x000;
volatile   unsigned char           T0                  @ 0x001;
volatile   unsigned char           PCL                 @ 0x002;
volatile   unsigned char           STATUS              @ 0x003;
volatile   unsigned char           FSR                 @ 0x004;
volatile   unsigned char           PORTA               @ 0x005;
volatile   unsigned char           PORTB               @ 0x006;
volatile  unsigned char            PCLATH              @ 0x00A;
volatile  unsigned char            INTCON              @ 0x00B;
volatile  unsigned char            PIR1                @ 0x00C;
volatile  unsigned char            PIR2                @ 0x00D;
volatile  unsigned char            T1L                 @ 0x00E;
volatile  unsigned char            T1H                 @ 0x00F;
volatile  unsigned char            T1CON               @ 0x010;
volatile  unsigned char            T2                  @ 0x011;
volatile  unsigned char            T2CON               @ 0x012;
volatile  unsigned char            WPUB                @ 0x013;
volatile  unsigned char            IOCB                @ 0x014;
volatile  unsigned char            CCPR1L              @ 0x015;
volatile  unsigned char            CCPR1H              @ 0x016;
volatile  unsigned char            CCP1CON             @ 0x017;
volatile  unsigned char            PR1L                @ 0x018;
volatile  unsigned char            PR1CON              @ 0x019;
volatile  unsigned char            CCPR2L              @ 0x01B;
volatile  unsigned char            CCPR2H              @ 0x01C;
volatile  unsigned char            CCP2CON             @ 0x01D;
volatile  unsigned char            ADRESH              @ 0x01E;
volatile  unsigned char            ADCON0              @ 0x01F;
//BANK1
volatile  unsigned char           OPTION              @ 0x081;
volatile  unsigned char           TRISA               @ 0x085;
volatile  unsigned char           TRISB               @ 0x086;
volatile  unsigned char           ADCKCS              @ 0x087;
volatile  unsigned char           PIE1                @ 0x08C;
volatile  unsigned char           PIE2                @ 0x08D;
volatile  unsigned char           PCON                @ 0x08E;
volatile  unsigned char           T1GCON              @ 0x08F;

volatile  unsigned char           OSCCON              @ 0x090;
volatile  unsigned char           PR2              @ 0x092;
volatile  unsigned char           WPUA              @ 0x093;
volatile  unsigned char           PMDATL              @ 0x094;
volatile  unsigned char           PMDATH               @ 0x095;
volatile  unsigned char           PMADRL               @ 0x096;
volatile  unsigned char           PMADRH               @ 0x097;
volatile  unsigned char           PMCON              @ 0x098;

volatile  unsigned char           ANSEL                @ 0x09D;
volatile  unsigned char           ADRESL                @ 0x09E;
volatile  unsigned char           ADCON1             @ 0x09F;

//----- BANK1 Register -----------------------------------------------------
// bit and bitfield definitions
volatile bit C                   @ ((unsigned)&STATUS*8)+0;
volatile bit DC                  @ ((unsigned)&STATUS*8)+1;
volatile bit Z                   @ ((unsigned)&STATUS*8)+2;
volatile bit PD                  @ ((unsigned)&STATUS*8)+3;
volatile bit TO                  @ ((unsigned)&STATUS*8)+4;
volatile bit RP0                 @ ((unsigned)&STATUS*8)+5; 

// bit and bitfield definitions
volatile bit PORTA0               @ ((unsigned)&PORTA*8)+0;
volatile bit PORTA1               @ ((unsigned)&PORTA*8)+1;
volatile bit PORTA2               @ ((unsigned)&PORTA*8)+2;
volatile bit PORTA3               @ ((unsigned)&PORTA*8)+3;
volatile bit PORTA4               @ ((unsigned)&PORTA*8)+4;
volatile bit PORTA6               @ ((unsigned)&PORTA*8)+6;
volatile bit PORTA7               @ ((unsigned)&PORTA*8)+7;
// bit and bitfield definitions
volatile bit PORTB0                 @ ((unsigned)&PORTB*8)+0;
volatile bit PORTB1                 @ ((unsigned)&PORTB*8)+1;
volatile bit PORTB2                 @ ((unsigned)&PORTB*8)+2;
volatile bit PORTB3                 @ ((unsigned)&PORTB*8)+3;
volatile bit PORTB5                 @ ((unsigned)&PORTB*8)+5;
volatile bit PORTB6                 @ ((unsigned)&PORTB*8)+6;
volatile bit PORTB7                 @ ((unsigned)&PORTB*8)+7;

// bit and bitfield definitions
volatile bit RBIF                 @ ((unsigned)&INTCON*8)+0;
volatile bit INTF                 @ ((unsigned)&INTCON*8)+1;
volatile bit T0IF                 @ ((unsigned)&INTCON*8)+2;
volatile bit RBIE                 @ ((unsigned)&INTCON*8)+3;
volatile bit INTE                 @ ((unsigned)&INTCON*8)+4;
volatile bit T0IE                 @ ((unsigned)&INTCON*8)+5;
volatile bit PEIE                 @ ((unsigned)&INTCON*8)+6;
volatile bit GIE                  @ ((unsigned)&INTCON*8)+7;

// bit and bitfield definitions
volatile bit T1IF                 @ ((unsigned)&PIR1*8)+0;
volatile bit T2IF                 @ ((unsigned)&PIR1*8)+1;
volatile bit CCP1IF                 @ ((unsigned)&PIR1*8)+2;
volatile bit ADIF                 @ ((unsigned)&PIR1*8)+6;
volatile bit T1GIF                  @ ((unsigned)&PIR1*8)+7;

// bit and bitfield definitions
volatile bit CCP2IF                 @ ((unsigned)&PIR2*8)+0;

// bit and bitfield definitions
volatile bit T1ON                   @ ((unsigned)&T1CON*8)+0;
volatile bit T1SYNC                 @ ((unsigned)&T1CON*8)+2;
volatile bit T1OSCEN                @ ((unsigned)&T1CON*8)+3;
volatile bit T1CKPS0                @ ((unsigned)&T1CON*8)+4;
volatile bit T1CKPS1                @ ((unsigned)&T1CON*8)+5;
volatile bit T1CS0                  @ ((unsigned)&T1CON*8)+6;
volatile bit T1CS1                   @ ((unsigned)&T1CON*8)+7;

// bit and bitfield definitions
volatile bit T2ON                 @ ((unsigned)&T2CON*8)+2;
volatile bit T2CKPS0                @ ((unsigned)&T2CON*8)+3;
volatile bit T2CKPS1                @ ((unsigned)&T2CON*8)+4;
volatile bit T2CKPS2                @ ((unsigned)&T2CON*8)+5;
volatile bit T2CKPS3                  @ ((unsigned)&T2CON*8)+6;

// bit and bitfield definitions
volatile bit WPUB0                   @ ((unsigned)&WPUB*8)+0;
volatile bit WPUB1                   @ ((unsigned)&WPUB*8)+1;
volatile bit WPUB2                   @ ((unsigned)&WPUB*8)+2;
volatile bit WPUB3                   @ ((unsigned)&WPUB*8)+3;
volatile bit WPUB6                  @ ((unsigned)&WPUB*8)+6;
volatile bit WPUB7                   @ ((unsigned)&WPUB*8)+7;

/* Definitions for IOCB register */
volatile bit IOCB0                 @ ((unsigned)&IOCB*8)+0;
volatile bit IOCB1                 @ ((unsigned)&IOCB*8)+1;
volatile bit IOCB2                 @ ((unsigned)&IOCB*8)+2;
volatile bit IOCB3                 @ ((unsigned)&IOCB*8)+3;
volatile bit IOCB5                 @ ((unsigned)&IOCB*8)+5;
volatile bit IOCB6                 @ ((unsigned)&IOCB*8)+6;
volatile bit IOCB7                 @ ((unsigned)&IOCB*8)+7;

/* Definitions for IOCB register */
volatile bit CCP1M0                 @ ((unsigned)&CCP1CON*8)+0;
volatile bit CCP1M1                 @ ((unsigned)&CCP1CON*8)+1;
volatile bit CCP1M2                 @ ((unsigned)&CCP1CON*8)+2;
volatile bit CCP1M3                 @ ((unsigned)&CCP1CON*8)+3;
volatile bit DC1B0                 @ ((unsigned)&CCP1CON*8)+4;
volatile bit DC1B1                 @ ((unsigned)&CCP1CON*8)+5;

/* Definitions for IOCB register */
volatile bit PR1EN                 @ ((unsigned)&PR1CON*8)+0;
volatile bit PWMPR1                 @ ((unsigned)&PR1CON*8)+1;
volatile bit T1CKPS2                 @ ((unsigned)&PR1CON*8)+2;
volatile bit T1CKPS3                 @ ((unsigned)&PR1CON*8)+3;
volatile bit PWM2T0                 @ ((unsigned)&PR1CON*8)+4;
volatile bit PWM2T1                 @ ((unsigned)&PR1CON*8)+5;
volatile bit PWM1T0                 @ ((unsigned)&PR1CON*8)+6;
volatile bit PWM1T1                 @ ((unsigned)&PR1CON*8)+7;

/* Definitions for IOCB register */
volatile bit CCP2M0                 @ ((unsigned)&CCP2CON*8)+0;
volatile bit CCP2M1                 @ ((unsigned)&CCP2CON*8)+1;
volatile bit CCP2M2                 @ ((unsigned)&CCP2CON*8)+2;
volatile bit CCP2M3                 @ ((unsigned)&CCP2CON*8)+3;
volatile bit DC2B0                 @ ((unsigned)&CCP2CON*8)+4;
volatile bit DC2B1                 @ ((unsigned)&CCP2CON*8)+5;

// bit and bitfield definitions
volatile bit ADEN               @ ((unsigned)&ADCON0*8)+0;
volatile bit ADON               @ ((unsigned)&ADCON0*8)+1;
volatile bit CHS0               @ ((unsigned)&ADCON0*8)+2;
volatile bit CHS1               @ ((unsigned)&ADCON0*8)+3;
volatile bit CHS2               @ ((unsigned)&ADCON0*8)+4;
volatile bit VHS2               @ ((unsigned)&ADCON0*8)+5;
volatile bit VHS1               @ ((unsigned)&ADCON0*8)+6;

// bit and bitfield definitions
volatile bit PS0                 @ ((unsigned)&OPTION*8)+0;
volatile bit PS1                 @ ((unsigned)&OPTION*8)+1;
volatile bit PS2                 @ ((unsigned)&OPTION*8)+2;
volatile bit PSA                 @ ((unsigned)&OPTION*8)+3;
volatile bit T0SE                 @ ((unsigned)&OPTION*8)+4;
volatile bit T0CS                 @ ((unsigned)&OPTION*8)+5;
volatile bit INTEDG                 @ ((unsigned)&OPTION*8)+6;
volatile bit RBPUB                 @ ((unsigned)&OPTION*8)+6;

// bit and bitfield definitions
volatile bit TRISA0               @ ((unsigned)&TRISA*8)+0;
volatile bit TRISA1               @ ((unsigned)&TRISA*8)+1;
volatile bit TRISA2               @ ((unsigned)&TRISA*8)+2;
volatile bit TRISA3               @ ((unsigned)&TRISA*8)+3;
volatile bit TRISA4               @ ((unsigned)&TRISA*8)+4;
volatile bit TRISA6               @ ((unsigned)&TRISA*8)+6;
volatile bit TRISA7               @ ((unsigned)&TRISA*8)+7;

// bit and bitfield definitions
volatile bit TRISB0               @ ((unsigned)&TRISB*8)+0;
volatile bit TRISB1               @ ((unsigned)&TRISB*8)+1;
volatile bit TRISB2               @ ((unsigned)&TRISB*8)+2;
volatile bit TRISB3               @ ((unsigned)&TRISB*8)+3;
volatile bit TRISB4               @ ((unsigned)&TRISB*8)+4;
volatile bit TRISB5               @ ((unsigned)&TRISB*8)+5;
volatile bit TRISB6               @ ((unsigned)&TRISB*8)+6;
volatile bit TRISB7               @ ((unsigned)&TRISB*8)+7;

// bit and bitfield definitions
volatile bit ADCKCS0               @ ((unsigned)&ADCKCS*8)+0;
volatile bit ADCKCS1               @ ((unsigned)&ADCKCS*8)+1;
volatile bit ADCKCS2               @ ((unsigned)&ADCKCS*8)+2;

// bit and bitfield definitions
volatile bit T1IE               @ ((unsigned)&PIE1*8)+0;
volatile bit T2IE               @ ((unsigned)&PIE1*8)+1;
volatile bit CCP1IE               @ ((unsigned)&PIE1*8)+2;
volatile bit ADIE               @ ((unsigned)&PIE1*8)+6;
volatile bit T1GIE               @ ((unsigned)&PIE1*8)+7;

// bit and bitfield definitions
volatile bit CCP2IE               @ ((unsigned)&PIE2*8)+0;

// bit and bitfield definitions
volatile bit BOR                   @ ((unsigned)&PCON*8)+0;
volatile bit POR                   @ ((unsigned)&PCON*8)+1;
volatile bit LVD1F                 @ ((unsigned)&PCON*8)+2;
volatile bit LVD2F                 @ ((unsigned)&PCON*8)+3;
volatile bit WDTENS                @ ((unsigned)&PCON*8)+4;
volatile bit LVD1EN                @ ((unsigned)&PCON*8)+6;
volatile bit LVD2EN                @ ((unsigned)&PCON*8)+7;

// bit and bitfield definitions
volatile bit T1GSS0                   @ ((unsigned)&T1GCON*8)+0;
volatile bit T1GSS1                   @ ((unsigned)&T1GCON*8)+1;
volatile bit T1GVAL                 @ ((unsigned)&T1GCON*8)+2;
volatile bit T1GON                 @ ((unsigned)&T1GCON*8)+3;
volatile bit T1GSPM                @ ((unsigned)&T1GCON*8)+4;
volatile bit T1GTM                @ ((unsigned)&T1GCON*8)+5;
volatile bit T1GPOL                @ ((unsigned)&T1GCON*8)+6;
volatile bit T1GEN                @ ((unsigned)&T1GCON*8)+7;

// bit and bitfield definitions
volatile bit SCS                   @ ((unsigned)&OSCCON*8)+0;
volatile bit HXEN                   @ ((unsigned)&OSCCON*8)+1;
volatile bit T0OSCEN                   @ ((unsigned)&OSCCON*8)+7;

// bit and bitfield definitions
volatile bit WPUA0                 @ ((unsigned)&WPUA*8)+0;
volatile bit WPUA1                 @ ((unsigned)&WPUA*8)+1;
volatile bit WPUA2                 @ ((unsigned)&WPUA*8)+2;
volatile bit WPUA3                 @ ((unsigned)&WPUA*8)+3;
volatile bit WPUA4                 @ ((unsigned)&WPUA*8)+4;
volatile bit WPUA6                 @ ((unsigned)&WPUA*8)+6;
volatile bit WPUA7                 @ ((unsigned)&WPUA*8)+7;

// bit and bitfield definitions
volatile bit RDON                 @ ((unsigned)&PMCON*8)+0;

// bit and bitfield definitions
volatile bit ANSEL0                 @ ((unsigned)&ANSEL*8)+0;
volatile bit ANSEL1                 @ ((unsigned)&ANSEL*8)+1;
volatile bit ANSEL2                 @ ((unsigned)&ANSEL*8)+2;
volatile bit ANSEL3                 @ ((unsigned)&ANSEL*8)+3;
volatile bit ANSEL4                 @ ((unsigned)&ANSEL*8)+4;
volatile bit ANSEL6                 @ ((unsigned)&ANSEL*8)+6;
volatile bit ANSEL7                 @ ((unsigned)&ANSEL*8)+7;

// bit and bitfield definitions
volatile bit ADREF                 @ ((unsigned)&ADCON1*8)+0;
volatile bit ADCS0                 @ ((unsigned)&ADCON1*8)+4;
volatile bit ADCS1                 @ ((unsigned)&ADCON1*8)+5;
volatile bit ADCS2                 @ ((unsigned)&ADCON1*8)+6;
volatile bit ADCS3                 @ ((unsigned)&ADCON1*8)+7;

#endif
