//================================================================================
#ifndef __USER_H__
#define __USER_H__
//--------------------------------------------------------------------------------
//ܶPIN
#if D_DEBUG
#define		p_key_1				PORTA3
#define		p_key_2				PORTA4
#define		p_key_3				PORTA6
#define		p_pwm				PORTA7
#define		p_led				PORTB6
#else
#define		p_key_1				PORTA0
#define		p_key_2				PORTA1
#define		p_key_3				PORTA2
#define		p_led_2				PORTA3
#define		p_pwm				PORTA7
#define		p_led				PORTB5
#endif

#define		p_csn				PORTB0				//output high
#define		p_clk				PORTB1				//output low
#define		p_mosi				PORTB2				
#define		p_irq				PORTB3
//--------------------------------------------------------------------------------
typedef struct{
	u8	chn;
#if D_RF_RX
	u8	rst_int;									//жʹ
	u8	slp_int;									//жʹ
#endif
	u8	id[3];
	u8	mark;
	u8	len;
	u8	buf[D_RF_DATA_LENTH];
}RF_FRAME;
//--------------------------------------------------------------------------------
typedef struct{
	u8	fchange:1;
	u8	ftrig:1;
	u8	flong:1;
	u8	tmp;
	u8	cnt;
	u8	cur;
	u8	old;
	u8	bounce;
}KEY_FRAME;
#define		D_LONGKEY_CNT		100					//1000ms(ʱ:10MS)
#define		D_KEY_BOUNCE		3					//30ms(ʱ:10MS)
//--------------------------------------------------------------------------------
#define	led_turnon()			{p_led = D_LED_ON;}
#define	led_turnoff()			{p_led = D_LED_OFF;}
#define	led_toggle()			{p_led ^= 1;}
//================================================================================
extern KEY_FRAME key;	
extern RF_FRAME rf;

extern void delay_ms(u8 ms);
extern void delay_us(u8 us);
extern u16 adc_sampling_continuous(u8 u8_times);

#if D_RF_TX
extern void key_scan(void);
extern void key_process(void);
#endif

#if D_RF_RX
void rx_data_process(void);
#endif
//================================================================================
#endif