//================================================================================
//
//
//================================================================================
#include "bl08p122.h"
#include "main.h"
#include "hs6220.h"
#include "user.h"
//================================================================================
#if D_RF_TX
KEY_FRAME key;
#endif
RF_FRAME rf;
//================================================================================


//================================================================================
//	
//--------------------------------------------------------------------------------
void delay_ms(u8 ms)
{	//ָʱ,Fcpu = 2M
	u16 i;
	
	for(; ms>0; ms--)
    {
        for(i=180; i>0; i--);
		{
			clear_wdt();
		}
    }
}
//================================================================================
void delay_us(u8 us)
{	//ʱԼ5USı
	for( ; us>0; us--)
    {
    	#asm
		nop;
		nop;
		#endasm
    }
}
//================================================================================

//================================================================================

#if D_RF_TX
//================================================================================
//	
//--------------------------------------------------------------------------------
void key_scan(void)
{
	key.tmp = 0;
	if(!p_key_1)
	{
		key.tmp |= BIT0;
	}
	if(!p_key_2)
	{
		key.tmp |= BIT1;
	}
	if(!p_key_3)
	{
		key.tmp |= BIT2;
	}
	
	if(key.tmp == key.cur)
	{	//ֵֵͬ,ȥ
		if(0 == key.bounce)
		{
			if(key.old != key.cur)
			{
				key.old = key.cur;
				if(key.cur)
				{
					key.fchange = 1;
					key.ftrig = 1;
				}
			}
		}
		else
		{
			key.bounce--;
		}
		key.cnt++;
	}
	else
	{
		key.cur = key.tmp;
		key.bounce = D_KEY_BOUNCE;
		key.cnt = 0;
	}

	//жϴ
	if(0 == key.cur)
	{	//ͷ
		key.fchange =0;
	}
	else
	{
		//ûͷžͱûʱ
		u8_wake_time = D_WAKE_TIME;
		
		if((key.cnt >= D_LONGKEY_CNT) && key.fchange)
		{
		//	key.cnt = D_LONGKEY_CNT;
			key.flong = 1;
			key.cnt = 0;
		}
	}
}
//================================================================================
//	
//--------------------------------------------------------------------------------
void key_process(void)
{
	u8 tmp;
	
	if(key.ftrig || key.flong)
	{
		key.flong = 0;
		key.ftrig = 0;
		
		rf.mark++;

		led_turnon();
		//9
		tmp = 9;					
		while(tmp--)
		{
			rf.buf[0] = rf.mark;
			rf.buf[1] = u8_roll_adr0;
			rf.buf[2] = u8_roll_adr1;
			rf.buf[3] = u8_roll_adr2;
			rf.buf[4] = key.old;
		
			rf_tx_send_data(HS6220_W_TX_PAYLOAD_NOACK, rf.buf, D_RF_DATA_LENTH);
			
#if D_HOP_ON
			rf_hop_channal();
#endif
			delay_ms(10);
		//˵:ʱͷʹӦ鴦.
		//ն˳ʱûյRFݻʼ(RFʼһʱԼ40MS)
		//Ͷ˷ҪܿRFʼʱ,ⲻյ	
		}
		led_turnoff();
	}	
}
//================================================================================
#endif


#if D_RF_RX
//================================================================================
//	
//--------------------------------------------------------------------------------
void rx_data_process(void)
{	
	if(D_RF_DATA_LENTH == rf.len)
	{	//ݴ
		rf.len = 0;

		//
		//RX˵һյRFϢ,ID
		if((0 == rf.id[0]) && (0 == rf.id[1]) && (0 == rf.id[2]))
		{	
			rf.id[0] = rf.buf[1];
			rf.id[1] = rf.buf[2];
			rf.id[2] = rf.buf[3];
		}
		//жID	
		if((rf.id[0] == rf.buf[1]) && (rf.id[1] == rf.buf[2]) && (rf.id[2] == rf.buf[3]))
		{	//ͬID,RX
			if(rf.mark == rf.buf[0])
			{	//ͬ֡,
				return;
			}
			rf.mark = rf.buf[0];
			
			//
			if(0x01 == rf.buf[4])
			{
				led_turnon();
				delay_ms(100);
				led_turnoff();
			}
			if(0x02 == rf.buf[4])
			{
				led_turnon();
				delay_ms(100);
				led_turnoff();
				delay_ms(100);
				led_turnon();
				delay_ms(100);
				led_turnoff();
			}
		}
	}
}
//================================================================================
#endif
