//================================================================================
//Author	: Maple
//Date  	: 2024-2-17
//Project	: PMS150G(RW1602P0E8B)
//================================================================================


//================================================================================
//			  PMS150G-S8(150mil)		
//  	   VDD |1     8| GND                
//    	   PA7 |2     7| PA0           
//         PA6 |3     6| PA4            
//         PA5 |4     5| PA3

//			  RW1602P0E8B-ESOP8(150mil)		
//  	   VDD |1     8| ANT              
//    	   PA6 |2     7| XTALP         
//         PA5 |3     6| RFVDD           
//         PA4 |4     5| IRQ
//                 --
//                 GND
//================================================================================
//#pragma disable check_lvd
//.check_sum modify 0xAD213C
//.Writer     Limit   $ + 20		//¼Ϊ20
//.outfile "45KEY_IR_BLE_%X_%T.pdk"
//һ㺯ʹRAM,жϿռ4RAM
//================================================================================
#include	"main.h"
#include	"key_t.h"
#include	"hs6220.h"
//================================================================================
.ramadr 0
u16		u16_point;
u16		u16_t16_cnt;
#define	D_T16BASE			1000				//1MS
#define	D_T16WAKE			20000				//20MS

.ramadr system
u8		u8_base;
#define	D_BASECNT			10					//10MS(ʱ:1MS)
u8	 	u8_flag;
u8		u8_para;								//Ӻڲʹ
u8		u8_tmp;									//ʱ

u8		u8_data_num;
u8		u8_spi_data;
u8		u8_data_buf[D_RF_DATA_NUM];
u8		u8_rf_mark;
u8		u8_rf_ch;

#if	D_RF_RX
u8			u8_reset_int;						//жʹ
u8			u8_sleep_int;						//жʹ
#define		D_RF_RESET_CNT		40				//400MS(ʱ:10MS)
#define		D_RF_SLEEP_CNT		4				//40MS(ʱ:10MS)
#endif
//--------------------------------------------------------------------------------
u8		u8_wake_time;
u8		u8_roll_adr[3];
//================================================================================


//================================================================================
// 3ֽڹתΪ5ֽͨѶַ
// ˷ĵַͨѶЧ֤ѣ KK Ĳ,붼Ҫ
//--------------------------------------------------------------------------------
void get_roll_code(void)
{
#if	D_DEBUG
	u8_roll_adr[0] = 0xF1;
	u8_roll_adr[1] = 0x11;
	u8_roll_adr[2] = 0x12;
#else
	call    _SYS(ADR.ROLL);    
	u8_roll_adr[0] = a;
	call    _SYS(ADR.ROLL) + 1;
	u8_roll_adr[1] = a;
	call    _SYS(ADR.ROLL) + 2;
	u8_roll_adr[2] = a;
#endif
}
//--------------------------------------------------------------------------------
/*
void rollcode_to_addr(void)
{
	u8_tmp = 16;
	while(u8_tmp)
	{
		u8_para = u8_buf1;
		u8_buf1 >>= 1;
		if(u8_buf2.0)		//u8_buf2 & 0x01
		{
			u8_buf1 |= 0x80;
		}
		u8_buf2 >>= 1;
		
		if(u8_para.0)
		{
			u8_buf1 ^= 0x05;
			u8_buf2 ^= 0x88;
		}
		u8_tmp--;
	}
	
	u8_buf4 = u8_buf2 >> 4;
	u8_buf4 += 0x80;
	u8_buf3 = u8_buf2 & 0x0f;
	u8_buf3 += 0x50;
	u8_buf2 = u8_buf1 >> 4;
	u8_buf2 += 0xb0;
	u8_buf1 &= 0x0f;
	u8_buf1 += 0xc0;
}*/
//================================================================================ 


//================================================================================
//	
//--------------------------------------------------------------------------------
void delay_1ms(void)
{	//ָʱ
	while(u8_para)
	{	//SYSCLK=2M
		wdreset;
		.delay 2000;
		u8_para--;
	}
}	
//================================================================================ 


//================================================================================
//	
//--------------------------------------------------------------------------------
#if D_RF_RX
void rx_data_process(void)
{	
	if(b_rx_ok)
	{	//ݴ
		b_rx_ok = 0;

		//
		//RX˵һյRFϢ,ID
		if((0 == u8_roll_adr[0]) && (0 == u8_roll_adr[1]) && (0 == u8_roll_adr[2]))
		{	
			u8_roll_adr[0] = u8_data_buf[1];
			u8_roll_adr[1] = u8_data_buf[2];
			u8_roll_adr[2] = u8_data_buf[3];
		}
		//жID	
		if((u8_roll_adr[0] == u8_data_buf[1]) && (u8_roll_adr[1] == u8_data_buf[2]) && (u8_roll_adr[2] == u8_data_buf[3]))
		{	//ͬID,RX
			if(u8_rf_mark == u8_data_buf[0])
			{	//ͬ֡,
				return;
			}
			u8_rf_mark = u8_data_buf[0];
			
			//
			if(0x01 == u8_data_buf[4])
			{
				led_turnon();
				delay_ms(100);
				led_turnoff();
			}
			if(0x02 == u8_data_buf[4])
			{
				led_turnon();
				delay_ms(100);
				led_turnoff();
				delay_ms(100);
				led_turnon();
				delay_ms(100);
				led_turnoff();
			}
		}
	}
}
#endif
//================================================================================


//================================================================================
//	ϵͳģʽ,͹(ֻаAԻ)
//--------------------------------------------------------------------------------
void system_stop(void)
{	//ϵͳ͹ģʽ
//ϵͳ͹ģʽ(CSN[PA7],MOSI[PA3],CLK[PA0])

	//ϵͳлƵ
	$ clkmd ILRC/1,En_IHRC,En_ILRC;
	//رոƵʡ
	clkmd.En_IHRC = 0;
	wdreset;
//	while(1)
//	{
		nop;
		nop;
		nop;
		nop;
		nop;
		stopsys;
		nop;
		nop;
		nop;
		nop;
		nop;
//	}
	$ clkmd IHRC/8,En_IHRC,En_ILRC;			
	clkmd.1 = 1;					// WatchDog enable
	u8_wake_time = D_WAKE_TIME;
}
//================================================================================


//********************************************************************************
//================================================================================
void FPPA0(void)
{	//ϵͳƵ2M
	.ADJUST_IC	SYSCLK=IHRC/8, IHRC=16MHz, Body=Inc, VDD=3.3V, Init_RAM;
	clkmd.1 = 0;					// WatchDog Disable
//------------------------------------------------------------	
//	PA0	:	output low				SCK
//	PA3	:	input pull high			MOSI
//	PA4	:	input pull high			KEY
//	PA5	:	input pull high			KEY
//	PA6	:	output low				LED
//	PA7	:	output high				CSN
	pac 	= 0b_1100_0111;
	paph 	= 0b_0011_1000;
	pa 		= 0b_0000_0000;
	padier	= 0b_1011_1000;
//------------------------------------------------------------
//RAM
//	u16_point = _SYS(RAM_SIZE)-1;
//	a = 0;
//	do
//	{
//		*u16_point = a;
//	}while(--u16_point$0);
//------------------------------------------------------------
//ʱ1MS
	u16_t16_cnt = 4096 - D_T16BASE;		//1ms
	stt16 u16_t16_cnt;
	$ t16m IHRC,/16,bit12;
	intrq = 0;
	$ inten t16;	
//------------------------------------------------------------
//RF ϵҪ 20ms ʱϵ縴λ,֮ͨ SPI  RF в
	delay_ms(20);
	u8_rf_ch = D_RF_CHANNEL_L;
	rf_init();
//------------------------------------------------------------
	wdreset;
	clkmd.1 = 1;					// WatchDog enable
	engint;
//------------------------------------------------------------
#if D_RF_TX
	get_roll_code();
	rf_tx_mode();
	while(1)
	{
		wdreset;

		if(b_t16_base)
		{
			b_t16_base = 0;
			key_scan();
		}
		key_process();
		if(u8_wake_time || !p_key_1 || !p_key_2)
		{
			continue;
		}
		
		rf_ce_low();
		rf_power_down();
		system_stop();
		rf_power_on(); 
		rf_tx_mode();
	}
#endif
	
#if D_RF_RX
	u8_roll_adr[0] = 0;
	u8_roll_adr[1] = 0;
	u8_roll_adr[2] = 0;
	rf_rx_mode();
	rf_ce_high();
	while(1)
	{
		wdreset;

		if(b_t16_base)
		{
			b_t16_base = 0;

			rf_rx_receive();
			rx_data_process();
		}

/* µĸλRFRF˯߻ѵĶǱģȱ */
		if(u8_reset_int >= D_RF_RESET_CNT)
		{
			rf_init();
			rf_rx_mode();
			rf_ce_high();
			u8_reset_int = 0;
			u8_sleep_int = 0;
		}
		if(u8_sleep_int >= D_RF_SLEEP_CNT)
		{
			rf_rx_prevent_crash();
			u8_sleep_int = 0;
		}
/* ϵĸλRFRF˯߻ѵĶǱģȱ */
	}
#endif
}
//================================================================================
void Interrupt(void)
{
	pushaf;

	if(intrq.t16)
	{	
		intrq.t16 = 0;
		stt16 u16_t16_cnt;
//test		
//	led_toggle()
#if D_RF_RX
		//RX 1MSʱ
		b_t16_base = 1;
#endif		
		u8_base++;
		if(u8_base >= D_BASECNT)
		{	//10ms
			u8_base = 0;
#if D_RF_TX
			//TX 10MSʱ
			b_t16_base = 1;
#endif			
			if(u8_wake_time)
			{
				u8_wake_time--;
			}
#if D_RF_RX
			u8_reset_int++;
			u8_sleep_int++;
#endif
		}
	}
	popaf;
}
//================================================================================
//********************************************************************************