#include "include.h"

void System_Int(void)
{
	Ram_Int();  	///RAM  
	
	Gpio_Int(); 	//IOʼ		
		
	////ADC-OFFSETʽѡһ
	
	//ʽ1ʹڲGNDͨУ׼ADC-OFFSET
	Adc_Offset1();	

	//ʽ2ʹAN0ͨУ׼ADC-OFFSETAN0ͨ赽GND
//	Adc_Offset2();
	
	////Ҫڴӡȡע
	Uart_Int(); 	///UARTʼ ڷͲɼֵ

	////ҪɼOPOUTȡע
//	OP_Int();  		///  OPʹ	
}

void Gpio_Int(void)
{
	/////ģģʽ   1    0ģ
	ANSELA = 0x00;
	ANSELB = 0x00;
	ANSELC = 0x00;
	
	/////ģʽ   1    0
	TRISA = 0x00;
	TRISB = 0x00;
	TRISC = 0x00;
	
	////IOݼĴ   1ߵƽ    0͵ƽ
	PORTA = 0x00;
	PORTB = 0x00;
	PORTC = 0x00;
	
	////ƣ   1ʹ   0ر
	WPUA = 0x00;
	WPUB = 0x00;
	WPUC = 0x00;
	
	////ƣ   1ʹ   0ر
	WPDA = 0x00;
	WPDB = 0x00;
	WPDC = 0x00;
	
	////GPIOѿƣ   1ʹܻ   0رջ
	IOCA = 0x00;
	IOCB = 0x00;
	IOCC = 0x00;	
}

void Adc_Ch_Choose_Int(unsigned char Adc_Ch)
{
	switch(Adc_Ch)
	{
		case ADC_CH_AN0:
			ANSELA0 = 0;
			TRISA0 = 0;
		break;	
		case ADC_CH_AN1:
			ANSELA1 = 0;
			TRISA1 = 0;
		break;
		case ADC_CH_AN2:
			ANSELA2 = 0;
			TRISA2 = 0;
		break;
		case ADC_CH_AN3:
			ANSELA3 = 0;
			TRISA3 = 0;
		break;
		case ADC_CH_AN4:
			ANSELA4 = 0;
			TRISA4 = 0;
		break;
		case ADC_CH_AN5:
			ANSELA5 = 0;
			TRISA5 = 0;
		break;
		case ADC_CH_AN6:
			ANSELA6 = 0;
			TRISA6 = 0;
		break;
		case ADC_CH_1_4VDD:
			asm("nop");
			asm("nop");
		break;
		case ADC_CH_AN8:
			ANSELB0 = 0;
			TRISB0 = 0;
		break;
		case ADC_CH_AN9:
			ANSELB1 = 0;
			TRISB1 = 0;
		break;
		case ADC_CH_AN10:
			ANSELB2 = 0;
			TRISB2 = 0;
		break;
		case ADC_CH_AN11:
			ANSELB3 = 0;
			TRISB3 = 0;
		break;
		case ADC_CH_AN12:
			ANSELB4 = 0;
			TRISB4 = 0;
		break;
		case ADC_CH_AN13:
			ANSELB5 = 0;
			TRISB5 = 0;
		break;
		case ADC_CH_AN14:
			ANSELB6 = 0;
			TRISB6 = 0;
		break;
		case ADC_CH_AN15:
			ANSELC0 = 0;
			TRISC0 = 0;
		break;
		case ADC_CH_AN16:
			ANSELC1 = 0;
			TRISC1 = 0;
		break;
		case ADC_CH_AN17:
			ANSELC2 = 0;
			TRISC2 = 0;
		break;
		case ADC_CH_AN18:
			ANSELC3 = 0;
			TRISC3 = 0;
		break;
		case ADC_CH_AN19:
			ANSELC4 = 0;
			TRISC4 = 0;
		break;
		case ADC_CH_AN20:
			ANSELC5 = 0;
			TRISC5 = 0;
		break;
		case ADC_CH_AN21:
			ANSELC6 = 0;
			TRISC6 = 0;
		break;
		case ADC_CH_AN22:
			ANSELC7 = 0;
			TRISC7 = 0;
		break;
		case ADC_CH_OPO:
			asm("nop");
			asm("nop");
		break;
		case ADC_CH_GND:
			asm("nop");
			asm("nop");
		break;
		default:
		break;
	}	
}
void Get_ADC_Int(unsigned char Adc_Ch,unsigned char Adc_Vref,unsigned Adc_Fre)
{
	//ADCͨѡ 0 - 24
	ADCON0  = 0x00;
	ADCON0 |= Adc_Ch << 2;
	Adc_Ch_Choose_Int(Adc_Ch);
	
	ADCON1  = 0x00;
	ADCON1 |= ((Adc_Fre << 4) | (Adc_Vref << 1));
	
	ADEN    = 1;
	Delay_Us(100);
	
}
unsigned short Get_Adc_Value()
{
	unsigned char i;
	unsigned short result,Data_Max,Data_Min,Data_Sum;
	
	result   = 0;
	Data_Max = 0;
	Data_Min = 4096;
	Data_Sum = 0;
	
	ADON = 1;
	while(ADON);
	asm("nop");

	ADON = 1;
	while(ADON);
	asm("nop");
	
	for(i = 0;i <= 5;i ++)
	{
		ADON   =  1;
		while(ADON);
		result = ADRESH;
		result = result << 8;
		result = result | ADRESL;
		result = result >> 4;
		
		if(result > Data_Max)
		{
			Data_Max = result;
		}
		if(result < Data_Min)
		{
			Data_Min = result;
		}
		Data_Sum += result;
		Data_Sum = Data_Sum;
	}
	
	return((Data_Sum - Data_Max - Data_Min) >> 2);
}

void Ram_Int(void)
{
	IRP = 0;
	FSR = 0x60;
	do{
		INDF = 0;
		FSR++;
	}while(FSR != 0x80);//BANK0 60H~7FH ַ0
      
	FSR = 0xD0;
	do{
		INDF = 0;
		FSR++;
	}while(FSR != 0xF0);//BANK1 D0H~EFH ַ0
	
	IRP = 1;
	FSR = 0x10;
	do{
		INDF = 0;
		FSR++;
	}while(FSR != 0x70);//BANK2 110H~16FH ַ0
      
	FSR = 0x90;
	do{
		INDF = 0;
		FSR++;
	}while(FSR != 0xF0);//BANK3 190H~1EFH ַ0

	IRP = 0;
}

void Delay_Us(unsigned int t)
{
 	while(--t);
}

void Uart_Int(void)
{
	ANSELC0   = 1;
	TRISC0    = 1;

	UART_MAP  = 0x22;   //TX PC0  RX PB5
	
	S1CON     = 0;
	
	BRTL      = 0xE6;
	BRTH      = 0xFF;  ///9600   8M 2T  CPU 4M	
	S1CON2    = 0x20;
	
	TXIF = 0;
	UARTEN = 1;
}

void OP_Int(void)
{
	//OP+  OPOUT ˿ģʽģʽ
	ANSELC6 = 0;
	TRISC6 = 0;
	
	ANSELC4 = 0;
	TRISC4 = 0;
	
	OPASW2 = 0;		//ʹ÷Ŵ1 OPASW2 = 0  OPASW1 = 1
	OPASW1 = 1;		//ʹ÷Ŵ51020OPASW2 = 1;OPASW1 = 1;
	
	OPCMPSW = 1;	///OPģʽ
	OPOUTEN = 1;	///OPʹ  PC4
	
	OPAOFM = 0;		//OPģʽ
	OPARSP = 0;    	

	///ڲŴ  bit0-1  00  1   01  5  10  10  11 20
	///עŴԼԴѹ
	OPA0C |= 0x00;
	
	OPCMP2EN = 1;	//ʹOP
}

/*****************************ADC-OFFSET***************************************/	
////ʽ1ʹڲGNDͨУ׼ɺADC-OFFSET5ֵ10LSBÿֵ2LSB/STEP
void Adc_Offset1(void)
{
	ADC_TIM_FLAG = 1;
	ADCON0 = 0x60;			//ڲGNDͨ
	ADCON1 = 0x44;			//ڲοѹ2.0VADCʱԴ16Ƶ
	ADCJMD= 0x20;
	ADEN = 1;
	Delay_Us(200);

	Gui_AdcValue = Get_Adc_Value();		
	if(Gui_AdcValue == 0)
	{		
		ADC_NEGATIVE_FLAG = 1;	//ƫ
	}
	else
	{
		ADC_POSITIVE_FLAG = 1;	//ƫ
	}

	while(ADC_TIM_FLAG)
	{
		if(ADC_NEGATIVE_FLAG == 1)	//ƫ
		{
			ADCJMD = ADCJMD + 1;
			number++;	
			Gui_AdcValue = Get_Adc_Value();	
			if(Gui_AdcValue != 0)
			{									
				ADCJMD = ADCJMD - 1;	
				ADC_NEGATIVE_FLAG= 0;
				ADC_TIM_FLAG  = 0;				
			}
			if((ADCJMD == 0x3F)||(number == 31))
			{
				ADC_NEGATIVE_FLAG= 0;
				ADC_TIM_FLAG  = 0;
			}
		}
					
		if(ADC_POSITIVE_FLAG == 1)	//ƫ
		{
			ADCJMD = ADCJMD - 1;
			number++;	
			Gui_AdcValue = Get_Adc_Value();	
			if((Gui_AdcValue == 0)||(ADCJMD == 0x00)||(number == 32))
			{						
				ADC_POSITIVE_FLAG = 0;
				ADC_TIM_FLAG  = 0;								
			}

		}
	}
	if(ADCJMD <= 58)
	{
		ADCJMD = ADCJMD + 5;
	}
	else
	{
		ADCJMD = 0x3F;
	}
}
//
////ʽ2ʹAN0ͨУ׼ADC-OFFSET
void Adc_Offset2(void)
{
	ADC_TIM_FLAG = 1;
	ADCON0 = 0x00;			//ⲿAN0ͨ
	ADCON1 = 0x44;			//ڲοѹ2.0VADCʱԴ16Ƶ
	ADCJMD= 0x20;
	ADEN = 1;
	Delay_Us(200);

	Gui_AdcValue = Get_Adc_Value();		
	if(Gui_AdcValue == 0)
	{		
		ADC_NEGATIVE_FLAG = 1;	//ƫ
	}
	else
	{
		ADC_POSITIVE_FLAG = 1;	//ƫ
	}

	while(ADC_TIM_FLAG)
	{
		if(ADC_NEGATIVE_FLAG == 1)	//ƫ
		{
			ADCJMD = ADCJMD + 1;
			number++;	
			Gui_AdcValue = Get_Adc_Value();	
			if(Gui_AdcValue != 0)
			{									
				ADCJMD = ADCJMD - 1;	
				ADC_NEGATIVE_FLAG = 0;
				ADC_TIM_FLAG  = 0;				
			}
			if((ADCJMD == 0x3F)||(number == 31))
			{
				ADC_NEGATIVE_FLAG = 0;
				ADC_TIM_FLAG  = 0;
			}
		}
					
		if(ADC_POSITIVE_FLAG == 1)	//ƫ
		{
			ADCJMD = ADCJMD - 1;
			number++;	
			Gui_AdcValue = Get_Adc_Value();	
			if((Gui_AdcValue == 0)||(ADCJMD == 0x00)||(number == 32))
			{						
				ADC_POSITIVE_FLAG = 0;
				ADC_TIM_FLAG  = 0;								
			}
		}

	}
}