/************************************************************************************************/
/**
* @file               tim_bsp.c
* @author             MCU Ecosystem Development Team
* @brief              TIM BSPʵTIMжϷʽ
*                           
*
**************************************************************************************************
* @attention
* Copyright (c) CEC Huada Electronic Design Co.,Ltd. All rights reserved.
*
**************************************************************************************************
*/


/*------------------------------------------includes--------------------------------------------*/
#include "tim_bsp.h"
#include "main.h"
uint8_t 	u8_cnt_2_int;
/*-------------------------------------------functions------------------------------------------*/
/**
* @brief  TIM1жϷ
* @retval 
*/
void TIM1_BRK_UP_TRG_COM_IRQHandler(void)
{
    /* TIM1жϴ */
    if (std_tim_get_interrupt_enable(TIM1, TIM_INTERRUPT_UPDATE))
    {
        std_tim_clear_flag(TIM1, TIM_FLAG_UPDATE);
		
		#if	TX
			u8_cnt_2_int++;
		#else
			rf.cnt++;
			rf_sleep_cnt++;
			rf_reset_cnt++;
		#endif


		u8_cnt_2_int++;
		rf.cnt++;
		rf_sleep_cnt++;
		rf_reset_cnt++;
        /* TIM1ʱж */
    }
}

/**
* @brief  TIM1жϣ
* @retval 
*/
void bsp_tim1_start_interrupt(void)
{
    /* ʹܸж */
    std_tim_interrupt_enable(TIM1, TIM_INTERRUPT_UPDATE);
    
    /* ʱ */
    std_tim_enable(TIM1);
}

