/************************************************************************************************/
/**
* @file               ciu32f003_std_iwdg.h
* @author             MCU Ecosystem Development Team
* @brief              IWDG STDͷļ
*                     ṩIWDGصSTDԼĶ塣 
*
*
**************************************************************************************************
* @attention
* Copyright (c) CEC Huada Electronic Design Co.,Ltd. All rights reserved.
*
**************************************************************************************************
*/

/* ͷļظ */
#ifndef CIU32F003_STD_IWDG_H
#define CIU32F003_STD_IWDG_H

/************************************************************************************************/
/**
* @addtogroup CIU32F003_STD_Driver
* @{
*/

/**
* @defgroup IWDG IWDG
* @brief ŹSTD
* @{
*
*/
/************************************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif

/*------------------------------------------includes--------------------------------------------*/
#include "ciu32f003_std_common.h"

/*--------------------------------------------define--------------------------------------------*/

/************************************************************************************************/
/**
* @defgroup IWDG_Constants IWDG Constants
* @brief IWDG弰궨
* @{
*
*/
/************************************************************************************************/

/* IWDGֵ */
#define IWDG_RELOAD                      (0x0000AAAAUL)                 /**< IWDG ι             */
#define IWDG_ENABLE                      (0x0000CCCCUL)                 /**< IWDG ʹ             */
#define IWDG_WRITE_ACCESS_ENABLE         (0x00005555UL)                 /**< IWDG дȨʹ       */
#define IWDG_WRITE_ACCESS_DISABLE        (0x00000000UL)                 /**< IWDG дȨ޹ر       */

/* IWDGʱ䶨 */
#define IWDG_OVERFLOW_PERIOD_128         IWDG_CFG_OVP_128               /**< IWDGʱΪ128ms   */
#define IWDG_OVERFLOW_PERIOD_256         IWDG_CFG_OVP_256               /**< IWDGʱΪ256ms   */
#define IWDG_OVERFLOW_PERIOD_512         IWDG_CFG_OVP_512               /**< IWDGʱΪ512ms   */
#define IWDG_OVERFLOW_PERIOD_1024        IWDG_CFG_OVP_1024              /**< IWDGʱΪ1.024s  */
#define IWDG_OVERFLOW_PERIOD_2048        IWDG_CFG_OVP_2048              /**< IWDGʱΪ2.048s  */
#define IWDG_OVERFLOW_PERIOD_4096        IWDG_CFG_OVP_4096              /**< IWDGʱΪ4.096s  */
#define IWDG_OVERFLOW_PERIOD_8192        IWDG_CFG_OVP_8192              /**< IWDGʱΪ8.192s  */
#define IWDG_OVERFLOW_PERIOD_16384       IWDG_CFG_OVP_16384             /**< IWDGʱΪ16.384s */


/** 
* @} 
*/

/*-------------------------------------------functions------------------------------------------*/
/************************************************************************************************/
/**
* @defgroup IWDG_External_Functions IWDG External Functions
* @brief    IWDG⺯
* @{
*
*/
/************************************************************************************************/
/** 
* @brief  IWDG
* @note   ʹIWDG,IWDG޷ֹͣ
* @retval 
*/
__STATIC_INLINE void std_iwdg_start(void)
{
    IWDG->CR = IWDG_ENABLE;
}

/** 
* @brief  ʹIWDGüĴдȨ
* @retval 
*/
__STATIC_INLINE void std_iwdg_write_access_enable(void)
{
    IWDG->CR = IWDG_WRITE_ACCESS_ENABLE;
}

/** 
* @brief  ֹIWDGüĴдȨ
* @retval 
*/
__STATIC_INLINE void std_iwdg_write_access_disable(void)
{
    IWDG->CR = IWDG_WRITE_ACCESS_DISABLE;
}

/** 
* @brief  IWDGι
* @retval 
*/
__STATIC_INLINE void std_iwdg_refresh(void)
{
    IWDG->CR = IWDG_RELOAD;
}

/**
* @brief  ʱ
* @param  overflow_period IWDGʱ䣺
*             @arg IWDG_OVERFLOW_PERIOD_128
*             @arg IWDG_OVERFLOW_PERIOD_256
*             @arg IWDG_OVERFLOW_PERIOD_512
*             @arg IWDG_OVERFLOW_PERIOD_1024
*             @arg IWDG_OVERFLOW_PERIOD_2048
*             @arg IWDG_OVERFLOW_PERIOD_4096
*             @arg IWDG_OVERFLOW_PERIOD_8192
*             @arg IWDG_OVERFLOW_PERIOD_16384
* @retval 
*/
__STATIC_INLINE void std_iwdg_set_overflow_period(uint32_t overflow_period)
{
    IWDG->CFG = overflow_period;
}

/**
* @brief  ȡʱ
* @retval uint32_t IWDGʱ䣺
*             @arg IWDG_OVERFLOW_PERIOD_128
*             @arg IWDG_OVERFLOW_PERIOD_256
*             @arg IWDG_OVERFLOW_PERIOD_512
*             @arg IWDG_OVERFLOW_PERIOD_1024
*             @arg IWDG_OVERFLOW_PERIOD_2048
*             @arg IWDG_OVERFLOW_PERIOD_4096
*             @arg IWDG_OVERFLOW_PERIOD_8192
*             @arg IWDG_OVERFLOW_PERIOD_16384
*/
__STATIC_INLINE uint32_t std_iwdg_get_overflow_period(void)
{
    return(IWDG->CFG);
}

/**
* @brief ȡֵ
* @retval uint32_t IWDGļֵ
*/
__STATIC_INLINE uint32_t std_iwdg_get_counter(void)
{
    return(IWDG->CNT);
}


/** 
* @} 
*/

#ifdef __cplusplus
}
#endif

/**
* @} 
*/  

/** 
* @} 
*/

#endif /* CIU32F003_STD_IWDG_H */
