//------------------------------------------------------------------------------------
// HS6206.c
//------------------------------------------------------------------------------------
// Copyright 2014, HunterSun Electronics Co., Ltd.
// Yufeng. Yao
// 2014-01-16
//
// Program Description:
//
//
//
//#include ".\port\port_mcu.h"
#include "HS6220_RF.h"

//#include <intrins.h>

#define	rf_csn_pin_att(x)		att_p07(x)
#define	rf_sck_pin_att(x)		att_p20(x)	
#define	rf_mosi_pin_att(x)		att_p06(x)
#define	rf_irq_pin_att(x)		att_p23(x)
#define	rf_csn_pin_status(x)	pin_out(P0_7,x)
#define	rf_sck_pin_status(x)	pin_out(P2_0,x)
#define	rf_mosi_pin_status(x)	pin_out(P0_6,x)

/* OM6220 ģSPI(3,4)ӿڳʼ
  ѾûӲCEĿƽˣ
  IRQŸҪ
*/

void HS6220_SPI_Init(void)
{
	std_gpio_init_t GPIO_InitStruct = {0};

	std_rcc_gpio_clk_enable(RCC_PERIPH_CLK_GPIOA);
	std_rcc_gpio_clk_enable(RCC_PERIPH_CLK_GPIOB);
    
    GPIO_InitStruct.pin   = HS6220_CSN_PIN;
    GPIO_InitStruct.mode  = GPIO_MODE_OUTPUT;
	GPIO_InitStruct.output_type = GPIO_OUTPUT_PUSHPULL;
    std_gpio_init(HS6220_CSN_PORT, &GPIO_InitStruct);
	
	GPIO_InitStruct.pin   = HS6220_SCK_PIN | HS6220_SDIO_PIN;
    GPIO_InitStruct.mode  = GPIO_MODE_OUTPUT;
	GPIO_InitStruct.output_type = GPIO_OUTPUT_PUSHPULL;
    std_gpio_init(HS6220_SCK_PORT, &GPIO_InitStruct);
	
	GPIO_InitStruct.pin   = HS6220_IRQ_PIN;
    GPIO_InitStruct.mode  = GPIO_MODE_INPUT;
	GPIO_InitStruct.pull = GPIO_PULLUP;
    std_gpio_init(HS6220_IRQ_PORT, &GPIO_InitStruct);
	
	HS6220_CSN_HIGH;
	HS6220_SCK_LOW;
	HS6220_SDIO_HIGH;
	printf("CSN low: %d\n",std_gpio_get_input_pin(HS6220_CSN_PORT, HS6220_CSN_PIN));
	printf("SCK low: %d\n",std_gpio_get_input_pin(HS6220_SCK_PORT, HS6220_SCK_PIN));
	printf("MOSI high: %d\n",std_gpio_get_input_pin(HS6220_SDIO_PORT, HS6220_SDIO_PIN));
}

// 3SPIд
void SPI_3wire_sendByte(unsigned char TxData)
{
	unsigned char i;
	unsigned char data_output_bit;
	
//	RF_MOSIΪ
	HS6220_SDIO_OUT_PP;

	for(i = 0; i < 8; i ++) 
	{
		data_output_bit = TxData & 0x80 ? 1 : 0;
		HS6220_SCK_LOW;
		if(data_output_bit){
			HS6220_SDIO_HIGH;
		}
		else{
			HS6220_SDIO_LOW;
		}		
		HS6220_SCK_HIGH;

		TxData = TxData << 1;
	}

	HS6220_SDIO_LOW;
	HS6220_SCK_LOW;
}

// 3SPI
unsigned char SPI_3wire_readByte(void) 
{
	unsigned char bit_ctr;
	unsigned char byte = 0;
	unsigned char temp = 0;
	
//	RF_MOSIΪ
	HS6220_SDIO_IPU; 

	for(bit_ctr = 0; bit_ctr < 8; bit_ctr ++) // output 8-bit
	{
		byte = byte << 1;
		HS6220_SCK_HIGH; 
		temp = HS6220_SDIO_STATUS;
		byte |= temp;          
		HS6220_SCK_LOW;  	
	}

	return (byte); // return read byte
}

// װĶɵõSPIд
void SPI_SendByte(unsigned char Data)
{
#if (HS6220_SPI_NWIRE == SPI_3_WIRE)
	// 3SPIд
	SPI_3wire_sendByte(Data);
#else
	// 4SPIд
	spi_4wire_wrd(Data);
#endif
}

// װĶɵõSPI
unsigned char SPI_ReadByte(void)
{
#if (HS6220_SPI_NWIRE == SPI_3_WIRE)
	// 3SPI
	return SPI_3wire_readByte();
#else
	// 4SPI
	return spi_4wire_wrd(0);
#endif
}

// OM6220дһĴһֵ
void HS6220_write_byte(unsigned char addr,unsigned char D)
{
	HS6220_CSN_LOW;
	SPI_SendByte(HS6220_W_REGISTER | addr);
	SPI_SendByte(D);
	HS6220_CSN_HIGH;
}

// OM6220дһĴֵ
void HS6220_wr_buffer(unsigned char addr,const unsigned char* buf,unsigned char len)
{
	HS6220_CSN_LOW;
	SPI_SendByte(HS6220_W_REGISTER | addr);
	while(len--)
	{
		SPI_SendByte(*buf ++);
	}
	HS6220_CSN_HIGH;
}

// OM6220һĴһֵ
unsigned char HS6220_read_byte(unsigned char addr)
{
	unsigned char rxdata;
	
	HS6220_CSN_LOW;
	SPI_SendByte(HS6220_R_REGISTER | addr);
	rxdata = SPI_ReadByte();
	HS6220_CSN_HIGH;
	
	return(rxdata);
}

// OM6220һĴֵ
void HS6220_read_buffer(unsigned char addr, unsigned char* buf, unsigned char len)
{
	HS6220_CSN_LOW;
	SPI_SendByte(HS6220_R_REGISTER | addr);
	
	while(len --)
	{
		*buf ++ = SPI_ReadByte();
	}
	HS6220_CSN_HIGH;
}

// OM6220ֱӷ
void HS6220_Operation(unsigned char opt)
{	
	HS6220_CSN_LOW;
	SPI_SendByte(opt);
	HS6220_CSN_HIGH;
}


/* OM6220 ʼ
һģ飬ֻãʼݻе
ĵڶ֮ЩֵΪĬֵʼݾͻٺܶ
*/
void HS6220_Init(void)
{
	unsigned char temp[5];
	HS6220_SPI_Init();
	unsigned char caldone_time;

reset_rf_int:	
	
//RFλ	
	HS6220_write_byte(HS6220_BANK0_FEATURE, SOFT_RST);	 // soft_reset
//SPI3ͨѶ4ͨѶ
	HS6220_write_byte(HS6220_BANK0_DYNPD, 0x00);
//	HS6220_write_byte(HS6220_BANK0_DYNPD, 0x08);
//RFоƬϵ磬Ϊģʽ
	HS6220_CE_Low();	
	HS6220_write_byte(HS6220_BANK0_CONFIG, 0x8b); 		//ϵ	

//	HS6220_Bank_Switch(HS6220_Bank1);
//	printf("chipid : %x\n", HS6220_read_byte(HS6220_BANK1_CHIP_ID));	
//	HS6220_Bank_Switch(HS6220_Bank0);
	
	std_delayms(3); // wait 3 ms
	HS6220_write_byte(HS6220_BANK0_PMU_CTL, 0xa8);		//ģʽ
	std_delayms(2);
	
	
//迪˹˲    
	HS6220_write_byte(HS6220_BANK0_FEATURE, 0x10);

//лBANK1
	HS6220_Bank_Switch(HS6220_Bank1);
//BANK1TEST_PKDET(üĴ24λ)ĵ5λΪ1
	HS6220_write_byte(HS6220_BANK1_TEST_PKDET, 0x20);
//BANK1FAGC_CTRL_1(üĴ32λ)  
	temp[0] = 0x01;
	HS6220_wr_buffer(HS6220_BANK1_FAGC_CTRL_1, temp, 1);
/*
//ʱ HS6220_BANK1_FAGC_CTRL_1
//ҪCEлBank1ȥ
//6220Ϊ߿,  VCO, , Ҳǿ й¶, ֲ֤ù 
//һеĽ취: С תʱVCO, תʱָԭֵ
	temp[2] = 0x05;
	temp[1] = 0xa1;
	temp[0] = 0xc1;	
	HS6220_wr_buffer(HS6220_BANK1_FAGC_CTRL_1, temp, 3);
*/
//BANK1AGC_CTRL(üĴ24λ)	
	temp[1] = 0xb2;
	temp[0] = 0xcf;  
	HS6220_wr_buffer(HS6220_BANK1_AGC_CTRL, temp, 2);
	printf("HS6220_BANK1_AGC_CTRL : %x\n", HS6220_read_byte(HS6220_BANK1_AGC_CTRL));

//лBANK0
	HS6220_Bank_Switch(HS6220_Bank0);	
//CE40US壬RFУ׼
	HS6220_CE_High();
	std_delayus(100);
	HS6220_CE_Low(); //У׼ʱCEǵ͵
	
//	std_delayms(50);
	
//ȴУ׼
	caldone_time = 35;	
	while(1)   //wait cal done
	{
		caldone_time--;
		std_delayms(1);
		if((HS6220_read_byte(HS6220_BANK0_RF_SETUP) & 0x20))
		{
			printf("HS6220_BANK0_RF_SETUP : %x\n", HS6220_read_byte(HS6220_BANK0_RF_SETUP));	
			break;
		}
		if(!caldone_time)
		{
			goto reset_rf_int;
		}
	}
	
//	printf("finish cal done\n");

//رУ׼(CAL_EN0)
	HS6220_write_byte(HS6220_BANK0_RF_SETUP, 0x40);

//лBANK1
	HS6220_Bank_Switch(HS6220_Bank1);	
//BANK1CAL_CTL(üĴ32λ)
	temp[2] = 0x75;  	//bp_dac =1 bp_rc = 1
	temp[1] = 0x98;  	// bp_vco_amp = 1 bp_vco_ldo=1
	temp[0] = 0x20;
	HS6220_wr_buffer(HS6220_BANK1_CAL_CTL, temp, 3);

//лBANK0
	HS6220_Bank_Switch(HS6220_Bank0);
//RXַ
	temp[0] = 0x46;
	temp[1] = 0x0b;
	temp[2] = 0xaf;
	temp[3] = 0x43;
	temp[4] = 0x98;	
//	temp[0] = 0x65;
//	temp[1] = 0x6e;
//	temp[2] = 0x54;
//	temp[3] = 0x9c;
//	temp[4] = 0x52;	
	HS6220_wr_buffer(HS6220_BANK0_RX_ADDR_P0, temp, 5); // set address
//TXַ
	temp[0]=0x46;
	temp[1]=0x0b;
	temp[2]=0xaf;
	temp[3]=0x43;
	temp[4]=0x98;
//	temp[0] = 0x65;
//	temp[1] = 0x6e;
//	temp[2] = 0x54;
//	temp[3] = 0x9c;
//	temp[4] = 0x52;	
	HS6220_wr_buffer(HS6220_BANK0_TX_ADDR, temp, 5);   //set address
//迪˹˲,ʹ̬ܶݰ
	HS6220_write_byte(HS6220_BANK0_FEATURE, 0x10);
//ʹRXԶӦ
	HS6220_write_byte(HS6220_BANK0_EN_AA, 0x00);		//ֹRXԶӦ
//	HS6220_write_byte(HS6220_BANK0_EN_AA, 0x01);		//ʹRXԶӦ
//CONFIG(RX MODE : 0xFB;TX MODE : 0xFA) 	
	HS6220_write_byte(HS6220_BANK0_CONFIG, 0xfA);
//շݳ
	HS6220_write_byte(HS6220_BANK0_RX_PW_P0, D_RF_DATA_LENTH);
//շƵ
	HS6220_write_byte(HS6220_BANK0_RF_CH, D_RF_CHANNEL);
//ʹRX PIPE
	HS6220_write_byte(HS6220_BANK0_EN_RXADDR, 0x03);
//ʹԶش
//	HS6220_write_byte(HS6220_BANK0_SETUP_RETR, 0x43);	//1MSԶش4
//ù
	HS6220_write_byte(HS6220_BANK0_RF_SETUP, 0x47);		//(8DB)
//ʹ̬ܶݰ PIPE
	HS6220_write_byte(HS6220_BANK0_DYNPD, 0x07);
	
	printf("config : %x\n", HS6220_read_byte(HS6220_BANK0_CONFIG));	
	
	HS6220_Clear_All_Irq();
	HS6220_Flush_Tx();	
	HS6220_CE_High();	
}

/*OM6220 дĴ
 cmd = code; 
 D = data
 */
void HS6220_wr_cmd(unsigned char cmd,unsigned char D)
{
	HS6220_CSN_LOW;
	SPI_SendByte(cmd);
	SPI_SendByte(D);
	HS6220_CSN_HIGH;
}

// лOM6220 BANK
void HS6220_Bank_Switch(HS6220_Bank_TypeDef bank)
{
	unsigned char sta;
	
	sta = HS6220_read_byte(HS6220_BANK0_STATUS);
	
	if(bank != HS6220_Bank0)
	{
		if(!(sta & HS6220_Bank1))
		{
			HS6220_wr_cmd(HS6220_ACTIVATE, HS6220_ACTIVATE_DATA);
		}
	}
	else
	{
		if(sta & HS6220_Bank1)
		{
			HS6220_wr_cmd(HS6220_ACTIVATE, HS6220_ACTIVATE_DATA);
		}
	}
}

//лbank1


//лbank0



// OM6220 л
void HS6220_Change_Rate(HS6220_Rate_TypeDef rate)
{
	unsigned char tmp;
	
	tmp = HS6220_read_byte(HS6220_BANK0_RF_SETUP);

	if(rate == Rate_1M)
	{
		tmp &= 0xf7;
		HS6220_write_byte(HS6220_BANK0_RF_SETUP, tmp);
	}
	else if(rate == Rate_2M)
	{
		tmp |= 0x08;
		HS6220_write_byte(HS6220_BANK0_RF_SETUP, tmp);
	}
}

// OM6220 лŵ
void HS6220_Change_CH(unsigned char chn)
{
	if(chn < 0x80)
		HS6220_write_byte(HS6220_BANK0_RF_CH, chn);
}

// OM6220 л
void HS6220_Change_Pwr(HS6220_Pwr_TypeDef pwr)
{
	unsigned char tmp;

	tmp = HS6220_read_byte(HS6220_BANK0_RF_SETUP);
	tmp &= ~0x47;

	switch (pwr)
	{
		case Pwr_8db:
			tmp |= 0x47;
			HS6220_write_byte(HS6220_BANK0_RF_SETUP, tmp);
		break;

		case Pwr_5db:
			tmp |= 0x40;
			HS6220_write_byte(HS6220_BANK0_RF_SETUP, tmp);
		break;

		case Pwr_4db:
			tmp |= 0x07;
			HS6220_write_byte(HS6220_BANK0_RF_SETUP, tmp);
		break;

		case Pwr_0db:
			tmp |= 0x03;
			HS6220_write_byte(HS6220_BANK0_RF_SETUP, tmp);
		break;

		case Pwr_n6db:
			tmp |= 0x01;
			HS6220_write_byte(HS6220_BANK0_RF_SETUP, tmp);
		break;
	
		default: // ĬϾó0db
			tmp |= 0x03;
			HS6220_write_byte(HS6220_BANK0_RF_SETUP, tmp);
		break;
	}
}

// OM6220 лַ
void HS6220_Change_Addr(unsigned char *buf, unsigned char len)
{
	if(len <= 6)
	HS6220_wr_buffer(HS6220_BANK0_RX_ADDR_P0, buf, len); // set address
}


/*OM6220 ݰ
bufȡݴŵĵط
returnȡ֮󣬷صǶȡݰ
*/
unsigned int rf_reset_cnt = 0;
unsigned char rf_sleep_cnt = 0;

unsigned char HS6220_ReceivePack(unsigned char *buf)
{
	unsigned char sta;
	unsigned char len;

	sta = HS6220_read_byte(HS6220_BANK0_STATUS);

	if(HS6220_STATUS_RX_DR & sta)
	{
		rf_sleep_cnt = 0;
		rf_reset_cnt = 0;
		
		len = HS6220_read_byte(HS6220_R_RX_PL_WID);
		if(len == HS6220_FIFO_MAX_PACK_SIZE)
		{
			HS6220_read_buffer(HS6220_R_RX_PAYLOAD, buf, len);
		}
		else
		{
			len = 0;
		}
		
		HS6220_CE_Low();
		HS6220_Flush_Rx();
		HS6220_Clear_All_Irq();
		HS6220_CE_High();
		
		return len;
	}
	
	//µĸλRFRF˯߻ѵĶǱģȱ
	if(rf_reset_cnt>=D_RF_RESET_CNT) // 300msûյ1ݣλRF³ʼ
	{	//RESETʱ䷶Χ300~500MS
		HS6220_Init();
		HS6220_CE_Low();
		HS6220_ModeSwitch(HS6220_PRX_Mode);	
		HS6220_CE_High();
		
		rf_sleep_cnt = 0;
		rf_reset_cnt = 0;
	}

	if(rf_sleep_cnt>=D_RF_SLEEP_CNT)// 20msûյ1ݣRF˯߻һ
	{	//SLEEPʱ䷶Χ20~50MS
		HS6220_CE_Low();
		HS6220_Flush_Rx();
		HS6220_Clear_All_Irq();
		
		HS6220_write_byte(HS6220_BANK0_PMU_CTL, 0xae);		
		std_delayms(1);// 1msʱȱ٣ҲС 
		HS6220_write_byte(HS6220_BANK0_PMU_CTL, 0xac);
		std_delayms(1);// 1msʱȱ٣ҲС
		HS6220_CE_High();
		
		rf_sleep_cnt = 0;		
	}
	//ϵĸλRFRF˯߻ѵĶǱģȱ
	
	return 0;
}


/* OM6220ݰ
  buf:Ҫ͵ݰָ 
  len:ݰĳȣ132ֽ 
  cmd: ݰHS6220_W_TX_PAYLOADHS6220_W_TX_PAYLOAD_NOACK
*/
void HS6220_SendPack(unsigned char cmd, unsigned char* buf, unsigned char len)
{
	unsigned char sta,cnt;

	/*
	sta = HS6220_read_byte(HS6220_BANK0_STATUS);
	if(!(sta & HS6220_STATUS_TX_FULL))
	{
		HS6220_wr_buffer(cmd, buf, len);
	}
	*/
	HS6220_wr_buffer(cmd, buf, len);
	HS6220_CE_High();
	//жϷǷ
	cnt = 50;	//time out 5ms
	while(cnt)
	{
		std_delayms(1);
		sta = HS6220_read_byte(HS6220_BANK0_STATUS);
		if(sta & HS6220_STATUS_TX_DS)
		{	//ͽ
			
			break;
		}
		cnt--;
	}
	HS6220_CE_Low();
}

// OM6220 лRFģʽ
void HS6220_ModeSwitch(HS6220_ModeTypeDef mod)
{
	unsigned char tmp;
	
	tmp = HS6220_read_byte(HS6220_BANK0_CONFIG);
	if(mod != HS6220_PRX_Mode)
	{
		tmp &= 0xFE;
	}
	else
	{
		tmp |= 0x01;
	}
	HS6220_write_byte(HS6220_BANK0_CONFIG, tmp);

	if(mod == HS6220_Carrier_Mode)
	{
		tmp = 0Xc7;//0x80 | HS6220_read_byte(HS6220_BANK0_RF_SETUP);
		HS6220_write_byte(HS6220_BANK0_RF_SETUP, tmp);
		/* ע⣺λΪزʹλزģʽ֮CEҪߣزŻ
		   ҪлƵ㣬ʵȣͲҪȥڲRFῴزźŵ*/
		
	}
}

// OM6220 жϱ־
void HS6220_Clear_All_Irq(void)
{
	HS6220_write_byte(HS6220_BANK0_STATUS, 0x70);
}

// OM6220 TX FIFO
void HS6220_Flush_Tx(void)
{
	HS6220_Operation(HS6220_FLUSH_TX);
}

// OM6220 RX FIFO
void HS6220_Flush_Rx(void)
{
	HS6220_Operation(HS6220_FLUSH_RX);
}

// OM6220 CE
void HS6220_CE_High(void)
{
	HS6220_Operation(HS6220_CMD_CE_HIGH);;
}

// OM6220 CE
void HS6220_CE_Low(void)
{
	HS6220_Operation(HS6220_CMD_CE_LOW);
}

// ȡMO6220յݰȵĺ
unsigned char HS6220_read_payload_length(void)
{
	return HS6220_read_byte(HS6220_R_RX_PL_WID);
}
