/************************************************************************************************/
/**
* @file               ciu32f003_std_flash.c
* @author             MCU Ecosystem Development Team
* @brief              FLASH STD
*                     ʵFLASHAPI
*
*
**************************************************************************************************
* @attention
* Copyright (c) CEC Huada Electronic Design Co.,Ltd. All rights reserved.
*
**************************************************************************************************
*/

/************************************************************************************************/
/**
* @addtogroup CIU32F003_STD_Driver
* @{
*/

/**
* @addtogroup FLASH 
* @{
*
*/
/************************************************************************************************/


/*------------------------------------------includes--------------------------------------------*/
#include "ciu32f003_std.h"

#ifdef STD_FLASH_PERIPHERAL_USED

/*-------------------------------------------functions------------------------------------------*/

/************************************************************************************************/
/**
* @addtogroup FLASH_External_Functions 
* @{
*
*/
/************************************************************************************************/ 

/**
* @brief  FlashOption byte
* @param  mode ģʽ
*             @arg FLASH_MODE_PAGE_ERASE
*             @arg FLASH_MODE_MASS_ERASE
* @param  address ʵַ
* @note   user flashʱȵstd_flash_unlock()flash
* @note   Option Byteʱȵstd_flash_opt_unlock()ѡֽ
* @retval std_status_t APIִн
*/
std_status_t std_flash_erase(uint32_t mode, uint32_t address)
{
    std_status_t status = STD_OK;
    
    /* òģʽ */
    std_flash_set_operate_mode(mode);
    
    /* ִв */
    *(uint32_t *)address = 0xFFFFFFFF;
    
    /* ȴɣѯ쳣־λ */
    while (std_flash_get_flag(FLASH_FLAG_BSY));
    if ((FLASH->SR & FLASH_FLAG_WRPERR) != 0x00000000U)
    {
        status = STD_ERR;
    }
    
    /* б־ */
    std_flash_clear_flag(FLASH_FLAG_EOP | FLASH_FLAG_WRPERR);
    
    /* ˳ģʽ */
    std_flash_set_operate_mode(FLASH_MODE_IDLE);
    
    return (status);
}


/**
* @brief  User FlashOption Byteֱ
* @param  address   ̵ַ
* @param  prog_data ݣ4ֽڣ
* @note   user flashʱȵstd_flash_unlock()flash
* @note   Option Byteֱʱȵstd_flash_opt_unlock()ѡֽ
* @retval std_status_t APIִн
*/
std_status_t std_flash_word_program(uint32_t address, uint32_t prog_data)
{
    std_status_t status = STD_OK;
    
    /* ģʽ */
    std_flash_set_operate_mode(FLASH_MODE_PROGRAM);

    /* Ŀַд */
    *(uint32_t *)address = prog_data;
    
    /* ȴɣѯ쳣־λ */
    while (std_flash_get_flag(FLASH_FLAG_BSY));
    if ((FLASH->SR & FLASH_FLAG_WRPERR) != 0x00000000U)
    {
        status = STD_ERR;
    }
    
    if (status == STD_OK)
    {
        /* Ƿȷ */
        if(*((__IO uint32_t *)address) != prog_data)
        {
            status = STD_ERR;
        }
    }
    
    /* б־ */
    std_flash_clear_flag(FLASH_FLAG_EOP | FLASH_FLAG_WRPERR);
    
    /* ˳ģʽ */
    std_flash_set_operate_mode(FLASH_MODE_IDLE);
    
    return (status);
}


/** 
* @} 
*/

#endif /* STD_FLASH_PERIPHERAL_USED */

/** 
* @} 
*/

/** 
* @} 
*/
