/************************************************************************************************/
/**
* @file               ciu32f003_std_i2c.h
* @author             MCU Ecosystem Development Team
* @brief              I2C STDͷļ
*                     ṩI2CصSTDԼĶ塣                         
*                     
*
**************************************************************************************************
* @attention
* Copyright (c) CEC Huada Electronic Design Co.,Ltd. All rights reserved.
*
**************************************************************************************************
*/

/* ͷļظ */
#ifndef CIU32F003_STD_I2C_H
#define CIU32F003_STD_I2C_H

/************************************************************************************************/
/** 
* @addtogroup CIU32F003_STD_Driver
* @{
*/

/**
* @defgroup I2C I2C
* @brief I2CӿڵSTD
* @{
*/
/************************************************************************************************/


#ifdef __cplusplus
 extern "C" {
#endif

/*------------------------------------includes--------------------------------------------------*/
#include "ciu32f003_std_common.h"

/*--------------------------------------------define--------------------------------------------*/

/************************************************************************************************/
/**
* @defgroup I2C_Constants I2C Constants
* @brief    I2C弰궨
* @{
*
*/
/************************************************************************************************/
/* ˲ */
#define I2C_DIGITALFILTER_DISABLE       I2C_CR1_DNF_DISABLE         /**< ˲ֹ             */
#define I2C_DIGITALFILTER_1CLK          I2C_CR1_DNF_1CLK            /**< ˳С1I2C_KCLK  */
#define I2C_DIGITALFILTER_2CLK          I2C_CR1_DNF_2CLK            /**< ˳С2I2C_KCLK  */
#define I2C_DIGITALFILTER_3CLK          I2C_CR1_DNF_3CLK            /**< ˳С3I2C_KCLK  */
#define I2C_DIGITALFILTER_4CLK          I2C_CR1_DNF_4CLK            /**< ˳С4I2C_KCLK  */
#define I2C_DIGITALFILTER_5CLK          I2C_CR1_DNF_5CLK            /**< ˳С5I2C_KCLK  */
#define I2C_DIGITALFILTER_6CLK          I2C_CR1_DNF_6CLK            /**< ˳С6I2C_KCLK  */
#define I2C_DIGITALFILTER_7CLK          I2C_CR1_DNF_7CLK            /**< ˳С7I2C_KCLK  */
#define I2C_DIGITALFILTER_8CLK          I2C_CR1_DNF_8CLK            /**< ˳С8I2C_KCLK  */
#define I2C_DIGITALFILTER_9CLK          I2C_CR1_DNF_9CLK            /**< ˳С9I2C_KCLK  */
#define I2C_DIGITALFILTER_10CLK         I2C_CR1_DNF_10CLK           /**< ˳С10I2C_KCLK */
#define I2C_DIGITALFILTER_11CLK         I2C_CR1_DNF_11CLK           /**< ˳С11I2C_KCLK */
#define I2C_DIGITALFILTER_12CLK         I2C_CR1_DNF_12CLK           /**< ˳С12I2C_KCLK */
#define I2C_DIGITALFILTER_13CLK         I2C_CR1_DNF_13CLK           /**< ˳С13I2C_KCLK */
#define I2C_DIGITALFILTER_14CLK         I2C_CR1_DNF_14CLK           /**< ˳С14I2C_KCLK */
#define I2C_DIGITALFILTER_15CLK         I2C_CR1_DNF_15CLK           /**< ˳С15I2C_KCLK */

/* I2C жԴ */
#define I2C_INTERRUPT_ERR               I2C_CR1_ERRIE               /**< ж        */
#define I2C_INTERRUPT_BUF               I2C_CR1_BUFIE               /**< ж      */
#define I2C_INTERRUPT_EVT               I2C_CR1_EVTIE               /**< ¼ж        */

/* I2C ״̬־λ */
#define I2C_FLAG_TXE                    I2C_ISR_TXE                 /**< ݼĴΪձ־    */
#define I2C_FLAG_TXIS                   I2C_ISR_TXIS                /**< ж״̬־          */
#define I2C_FLAG_RXNE                   I2C_ISR_RXNE                /**< ݼĴǿձ־    */
#define I2C_FLAG_ADDR                   I2C_ISR_ADDR                /**< ַƥ־              */
#define I2C_FLAG_NACK                   I2C_ISR_NACKF               /**< NACK־              */
#define I2C_FLAG_STOP                   I2C_ISR_STOPF               /**< ֹͣλ־            */
#define I2C_FLAG_BERR                   I2C_ISR_BERR                /**< ߴ־              */
#define I2C_FLAG_OVR                    I2C_ISR_OVR                 /**< ־                  */
#define I2C_FLAG_BUSY                   I2C_ISR_BUSY                /**< ߱ռñ־            */
#define I2C_FLAG_DIR                    I2C_ISR_DIR                 /**< ݴ䷽־          */

/* I2C ״̬λ */
#define I2C_CLEAR_ADDR                  I2C_ICR_ADDRCF              /**< ַƥ־          */
#define I2C_CLEAR_NACK                  I2C_ICR_NACKCF              /**< NACK־              */
#define I2C_CLEAR_STOP                  I2C_ICR_STOPCF              /**< ֹͣλ־        */
#define I2C_CLEAR_BERR                  I2C_ICR_BERRCF              /**< ߴ־          */
#define I2C_CLEAR_OVR                   I2C_ICR_OVRCF               /**< ־              */

/* I2C䷽ */
#define I2C_DIR_RX                      (0x00000000U)               /**< I2C               */
#define I2C_DIR_TX                      I2C_ISR_DIR                 /**< I2C               */

/* I2C ݴ䷽ */
#define I2C_REQUEST_WRITE               (0x00000000U)               /**< д     */
#define I2C_REQUEST_READ                I2C_CR2_RD_WRN              /**<      */

/** 
* @} 
*/

/*-------------------------------------------functions------------------------------------------*/

/************************************************************************************************/
/**
* @defgroup I2C_External_Functions I2C External Functions
* @brief    I2C⺯
* @{
*
*/
/************************************************************************************************/
/** 
* @brief  ʹI2Cӿ
* @retval 
*/
__STATIC_INLINE void std_i2c_enable(void)
{
    I2C1->CR1 |= I2C_CR1_PE;
}


/** 
* @brief  ֹI2Cӿ
* @retval 
*/
__STATIC_INLINE void std_i2c_disable(void)
{
    I2C1->CR1 &= (~I2C_CR1_PE);
}


/** 
* @brief  ˲
* @param  digital_filter ˲ò
*             @arg I2C_DIGITALFILTER_DISABLE: ֹ˲
*             @arg I2C_DIGITALFILTER_1CLK:    ˲С1 * I2C_KCLK
*             @arg I2C_DIGITALFILTER_2CLK:    ˲С2 * I2C_KCLK
*             @arg ...
*             @arg I2C_DIGITALFILTER_15CLK:   ˲С15 * I2C_KCLK
* @note   ˲ֻI2Cֹ״̬Ч
* @retval 
*/
__STATIC_INLINE void std_i2c_digital_filter_config(uint32_t digital_filter)
{
    MODIFY_REG(I2C1->CR1, I2C_CR1_DNF, digital_filter);
}


/** 
* @brief  I2Cģʽʱӳܿ
* @retval 
*/
__STATIC_INLINE void std_i2c_clock_stretch_enable(void)
{
    I2C1->CR1 &= (~I2C_CR1_NOSTRETCH);
}


/** 
* @brief  I2Cģʽʱӳֹܽ
* @retval 
*/
__STATIC_INLINE void std_i2c_clock_stretch_disable(void)
{
    I2C1->CR1 |= I2C_CR1_NOSTRETCH;
}


/** 
* @brief  I2C㲥ַӦʹ
* @retval 
*/
__STATIC_INLINE void std_i2c_general_call_address_enable(void)
{
    I2C1->CR1 |= I2C_CR1_GCEN;
}


/** 
* @brief  I2C㲥ַӦֹ
* @retval 
*/
__STATIC_INLINE void std_i2c_general_call_address_disable(void)
{
    I2C1->CR1 &= (~I2C_CR1_GCEN);
}


/** 
* @brief  I2Cģʽַ1
* @param  dev_address I2C豸ַ1ñķΧ0x0~0x7F֮䣩
* @retval 
*/
__STATIC_INLINE void std_i2c_device_address1_config(uint32_t dev_address)
{
    I2C1->ADDR1 = dev_address;
}


/** 
* @brief  ʹI2Cж
* @param  interrupt ʹI2CжԴѡ
*             @arg I2C_INTERRUPT_ERR:  I2Cж
*             @arg I2C_INTERRUPT_BUF:  I2Cж
*             @arg I2C_INTERRUPT_EVT:  I2C¼ж
* @retval 
*/
__STATIC_INLINE void std_i2c_interrupt_enable(uint32_t interrupt)
{
    I2C1->CR1 |= interrupt;
}


/** 
* @brief  ֹI2Cж
* @param  interrupt I2Cжѡ
*             @arg I2C_INTERRUPT_ERR:  I2Cж
*             @arg I2C_INTERRUPT_BUF:  I2Cж
*             @arg I2C_INTERRUPT_EVT:  I2C¼ж
* @retval 
*/
__STATIC_INLINE void std_i2c_interrupt_disable(uint32_t interrupt)
{
    I2C1->CR1 &= (~interrupt);
}


/** 
* @brief  ȡI2Cжʹ״̬
* @param  interrupt I2Cжѡ
*             @arg I2C_INTERRUPT_ERR:  I2Cж
*             @arg I2C_INTERRUPT_BUF:  I2Cж
*             @arg I2C_INTERRUPT_EVT:  I2C¼ж
* @retval uint32_t ѡI2Cжʹ״̬
*             @arg 0: ʹ
*             @arg 0:   ֹ
*/
__STATIC_INLINE uint32_t std_i2c_get_interrupt_enable(uint32_t interrupt)
{
    return (I2C1->CR1 & interrupt);
}


/** 
* @brief  ȡI2C״̬־λݴ䷽
* @param  flag I2C״̬־λѡ
*             @arg I2C_FLAG_TXE:      I2CݼĴΪ
*             @arg I2C_FLAG_TXIS:     I2Cж״̬
*             @arg I2C_FLAG_RXNE:     I2CݼĴǿ
*             @arg ...
*             @arg I2C_FLAG_DIR:      I2Cݴ䷽־
* @retval uint32_t ѡI2C״̬־λ״̬
*             @arg 0: ־λλ
*             @arg 0:   ־λ
*/
__STATIC_INLINE uint32_t std_i2c_get_flag(uint32_t flag)
{
    return (I2C1->ISR & flag);
}


/** 
* @brief  I2C״̬־λ
* @param  flag I2C״̬־λѡ
*             @arg I2C_CLEAR_ADDR:     ADDR־
*             @arg I2C_CLEAR_NACK:     NACKF־
*             @arg I2C_CLEAR_STOP:     STOPF־
*             @arg I2C_CLEAR_BERR:     BERR־
*             @arg I2C_CLEAR_OVR:      OVR־
* @retval 
*/
__STATIC_INLINE void std_i2c_clear_flag(uint32_t flag)
{
    I2C1->ICR = flag;
}


/** 
* @brief  ôģʽµַƥ¸ʱNACKӦ
* @retval 
*/
__STATIC_INLINE void std_i2c_set_next_data_nack(void)
{
    I2C1->CR2 = I2C_CR2_NACK;
}


/** 
* @brief  ݼĴ
* @retval uint8_t ݼĴеֵֵΧΪ0x00~0xFF
*/
__STATIC_INLINE uint8_t std_i2c_receive_byte(void)
{
    return (uint8_t)(I2C1->RDR);
}


/** 
* @brief  дݼĴ
* @param  send_data дI2C TDRĴеֵñΧΪ0x00~0xFF
* @retval 
*/
__STATIC_INLINE void std_i2c_transmit_byte(uint8_t send_data)
{
    I2C1->TDR = send_data;
}


/** 
* @brief  ݼĴ
* @retval 
*/
__STATIC_INLINE void std_i2c_clear_tx_data(void)
{
    I2C1->ISR = I2C_ISR_TXE;
}


/* I2Cȥʼ */
void std_i2c_deinit(void);

/** 
* @} 
*/


#ifdef __cplusplus
}
#endif

/**
* @} 
*/  

/**
* @}
*/

#endif /* CIU32F003_STD_I2C_H */
