#include "BL2101_rtc.h"


/****************************************************************************************************************************************** 
* : RTC_Init()
* ˵:	RTCʼ
*     : RTC_InitTypeDef* RTC_InitStruct
*     : 
* ע: 
******************************************************************************************************************************************/
void RTC_Init(RTC_InitTypeDef* RTC_InitStruct)
{
	SYS->CLKEN |= 0x01 << SYS_CLKEN_RTC_POS;      //RTCʱ
	
	RTC_Stop();                                   //ֹͣRTC
	
	RTC->SECOND = RTC_InitStruct->Second;         //Ĵ
	RTC->ALARM  = RTC_InitStruct->Alarm;          //ӼĴ
	
	RTC->IE = 0;                                  //ж  ж  ж
	RTC->IE = (RTC_InitStruct->Second_IE << RTC_SECOND_IE_POS) |
			  (RTC_InitStruct->Alarm_IE << RTC_ALARM_IE_POS) |
	          (RTC_InitStruct->OverFlow_IE << RTC_OVF_IE_POS);
	
	if(RTC_InitStruct->Second_IE | RTC_InitStruct->Alarm_IE | RTC_InitStruct->OverFlow_IE)
	{
		NVIC_EnableIRQ(RTC_IRQn);      //ʹRTCж
	}
	else
	{
		NVIC_DisableIRQ(RTC_IRQn);     //RTCж
	}
}



/****************************************************************************************************************************************** 
* :	RTC_Start()
* ˵:	RTC
*     : 
*     : 
* ע: 
******************************************************************************************************************************************/
void RTC_Start(void)
{
	RTC->EN = 1;
}

/****************************************************************************************************************************************** 
* :	RTC_Stop()
* ˵:	ֹͣRTC
*     : 
*     : 
* ע: 
******************************************************************************************************************************************/
void RTC_Stop(void)
{
	RTC->EN = 0;
}


/****************************************************************************************************************************************** 
* :	RTC_Set_Second()
* ˵:	RTCĴ
*     : uint32_t second
*     : 
* ע: 
******************************************************************************************************************************************/
void RTC_Set_Second(uint32_t second)
{
	RTC->SECOND = second;
}


/****************************************************************************************************************************************** 
* :	RTC_Set_Alarm()
* ˵:	RTCӼĴ
*     : uint32_t alarm
*     : 
* ע: 
******************************************************************************************************************************************/
void RTC_Set_Alarm(uint32_t alarm)
{
	RTC->ALARM = alarm;
}


/****************************************************************************************************************************************** 
* :	RTC_Get_Time()
* ˵:	ȡRTCǰʱֵ
*     : 
*     : ǰʱֵ
* ע: 
******************************************************************************************************************************************/
uint32_t RTC_Get_Time(void)
{
	return RTC->TIME;
}

/****************************************************************************************************************************************** 
* :	RTC_IntSecondEn()
* ˵:	жʹ
*     : 
*     : 
* ע: 
******************************************************************************************************************************************/
void RTC_IntSecondEn(void)
{	
	RTC->IE |= (0x01 << RTC_SECOND_IE_POS);
}

/****************************************************************************************************************************************** 
* :	RTC_IntSecondDis()
* ˵:	жϽֹ
*     : 
*     : 
* ע: 
******************************************************************************************************************************************/
void RTC_IntSecondDis(void)
{	
	RTC->IE &= ~(0x01 << RTC_SECOND_IE_POS);
}

/****************************************************************************************************************************************** 
* :	RTC_IntSecondClr()
* ˵:	жϱ־
*     : 
*     : 
* ע: 
******************************************************************************************************************************************/
void RTC_IntSecondClr(void)
{	
	RTC->IF = (0x01 << RTC_SECOND_IF_POS);
}

/****************************************************************************************************************************************** 
* :	RTC_IntSecondStat()
* ˵:	ж״̬
*     : 
*     : uint8_t				1 жϷ    0 жδ
* ע: 
******************************************************************************************************************************************/
uint8_t RTC_IntSecondStat(void)
{
	return (RTC->IF & RTC_SECOND_IF_MSK) ? 1 : 0;
}

/****************************************************************************************************************************************** 
* :	RTC_IntAlarmEn()
* ˵:	жʹ
*     : 
*     : 
* ע: 
******************************************************************************************************************************************/
void RTC_IntAlarmEn(void)
{	
	RTC->IE |= (0x01 << RTC_ALARM_IE_POS);
}

/****************************************************************************************************************************************** 
* :	RTC_IntAlarmDis()
* ˵:	жϽֹ
*     : 
*     : 
* ע: 
******************************************************************************************************************************************/
void RTC_IntAlarmDis(void)
{	
	RTC->IE &= ~(0x01 << RTC_ALARM_IE_POS);
}

/****************************************************************************************************************************************** 
* :	RTC_IntAlarmClr()
* ˵:	жϱ־
*     : 
*     : 
* ע: 
******************************************************************************************************************************************/
void RTC_IntAlarmClr(void)
{	
	RTC->IF = (0x01 << RTC_ALARM_IF_POS);
}

/****************************************************************************************************************************************** 
* :	RTC_IntAlarmStat()
* ˵:	ж״̬
*     : 
*     : uint8_t				1 жϷ    0 жδ
* ע: 
******************************************************************************************************************************************/
uint8_t RTC_IntAlarmStat(void)
{
	return (RTC->IF & RTC_ALARM_IF_MSK) ? 1 : 0;
}


/****************************************************************************************************************************************** 
* :	RTC_IntOverFlowEn()
* ˵: жʹ
*     : 
*     : 
* ע: 
******************************************************************************************************************************************/
void RTC_IntOverFlowEn(void)
{	
	RTC->IE |= (0x01 << RTC_OVF_IE_POS);
}

/****************************************************************************************************************************************** 
* :	RTC_IntOverFlowDis()
* ˵:	жϽֹ
*     : 
*     : 
* ע: 
******************************************************************************************************************************************/
void RTC_IntOverFlowDis(void)
{	
	RTC->IE &= ~(0x01 << RTC_OVF_IE_POS);
}

/****************************************************************************************************************************************** 
* :	RTC_IntOverFlowClr()
* ˵:	жϱ־
*     : 
*     : 
* ע: 
******************************************************************************************************************************************/
void RTC_IntOverFlowClr(void)
{	
	RTC->IF = (0x01 << RTC_OVF_IF_POS);
}

/****************************************************************************************************************************************** 
* :	RTC_IntOverFlowStat()
* ˵:	ж״̬
*     : 
*     : uint8_t				1 жϷ    0 жδ
* ע: 
******************************************************************************************************************************************/
uint8_t RTC_IntOverFlowStat(void)
{
	return (RTC->IF & RTC_OVF_IF_MSK) ? 1 : 0;
}


