#include "BL2101_aes.h"


/****************************************************************************************************************************************** 
* : AES_Init()
* ˵:	AESʼӷʽ   ģʽ
*     : AES_InitTypeDef * AES_InitStruct   
*     : 
* ע: 
******************************************************************************************************************************************/
void AES_Init(AES_InitTypeDef * AES_InitStruct)
{
	SYS->CLKEN |= 0x01 << SYS_CLKEN_AES_POS;                //AESʱ
	
	AES128->CR &= ~(0x01 << AES128_CR_EN_POS);              //AES üĴ
	
	AES128->CR &= ~(0x03 << AES128_CR_CHMODE_POS);          //AESӷʽ
	AES128->CR |= (AES_InitStruct->AESConnectMode << AES128_CR_CHMODE_POS);
	
	AES128->CR &= ~(0x03 << AES128_CR_MODE_POS);            //AESģʽ
	AES128->CR |= (AES_InitStruct->AESMode << AES128_CR_MODE_POS);
	
	AES128->CR &= ~(0x03 << AES128_CR_DATATYPE_POS);        //AES
	AES128->CR |= (AES_InitStruct->AESDataType << AES128_CR_DATATYPE_POS); 
}

/****************************************************************************************************************************************** 
* : AES_Set_Key()
* ˵:	AESKEY
*     : uint32_t *key    128bit  KEY 
*     : 
* ע: 
******************************************************************************************************************************************/
void AES_Set_Key(uint32_t *key)
{
	AES128->CR &= ~(0x01 << AES128_CR_EN_POS);          //AES üĴ
    
	AES128->KEYR3 = key[0];                             //KEY
	AES128->KEYR2 = key[1];
	AES128->KEYR1 = key[2];
	AES128->KEYR0 = key[3];
	
	AES128->CR |= 0x01 << AES128_CR_EN_POS;             //AESʹ
}

/****************************************************************************************************************************************** 
* : AES_Set_Key_IV()
* ˵:	AESKEY IV
*     : uint32_t *key    128bit  KEY 
            uint32_t *iv     128bit  IV
*     : 
* ע: 
******************************************************************************************************************************************/
void AES_Set_Key_IV(uint32_t *key,uint32_t *iv)
{
	AES128->CR &= ~(0x01 << AES128_CR_EN_POS);          //AES üĴ
    
	AES128->KEYR3 = key[0];                             //KEY
	AES128->KEYR2 = key[1];
	AES128->KEYR1 = key[2];
	AES128->KEYR0 = key[3];
	
	AES128->IVR3  = iv[0];                              //IV
	AES128->IVR2  = iv[1];
	AES128->IVR1  = iv[2];
	AES128->IVR0  = iv[3];
	
	AES128->CR |= 0x01 << AES128_CR_EN_POS;             //AESʹ
}

/****************************************************************************************************************************************** 
* : AES_Get_KeyDerived()
* ˵:	AESԿ
*     : uint32_t *key    128bit  KEY 
            uint32_t *key_derived     128bit  Կ
*     : 
* ע: 
******************************************************************************************************************************************/
void AES_Get_KeyDerived(uint32_t *key_derived)
{
	while(!(AES128->SR & AES128_SR_CCF_MSK)){};         //ȴAES
		
	key_derived[0] = AES128->KEYR3;                     //ȡԿ
	key_derived[1] = AES128->KEYR2;
	key_derived[2] = AES128->KEYR1;
	key_derived[3] = AES128->KEYR0;	

	AES128->CR |= 0x01 << AES128_CR_CCFC_POS;           //AESɱ־
}

/****************************************************************************************************************************************** 
* : AES_Data_WriteRead()
* ˵:	AESд
*     : uint32_t *din    128bit   
            uint32_t*dout    128bit  
*     : 
* ע: 
******************************************************************************************************************************************/
void AES_Data_WriteRead(uint32_t *din,uint32_t*dout)
{
	AES128->DINR = din[0];                              //д                
	AES128->DINR = din[1]; 
	AES128->DINR = din[2]; 
	AES128->DINR = din[3]; 
	
	while(!(AES128->SR & AES128_SR_CCF_MSK)){};         //ȴAES
		
    dout[0] = AES128->DOUTR;                            //
    dout[1] = AES128->DOUTR; 
    dout[2] = AES128->DOUTR; 
    dout[3] = AES128->DOUTR; 
	  
	AES128->CR |= 0x01 << AES128_CR_CCFC_POS;           //AESɱ־
}

/****************************************************************************************************************************************** 
* : AES_Data_Write()
* ˵:	AESд
*     : uint32_t *din    128bit   
*     : 
* ע: 
******************************************************************************************************************************************/
void AES_Data_Write(uint32_t *din)
{
	AES128->DINR = din[0];                              //д    
	AES128->DINR = din[1]; 
	AES128->DINR = din[2]; 
	AES128->DINR = din[3]; 
}

/****************************************************************************************************************************************** 
* : AES_Data_Read()
* ˵:	AESݶ
*     : uint32_t*dout    128bit       
*     : 
* ע: 
******************************************************************************************************************************************/
void AES_Data_Read(uint32_t*dout)
{
    dout[0] = AES128->DOUTR;                            //
    dout[1] = AES128->DOUTR; 
    dout[2] = AES128->DOUTR; 
    dout[3] = AES128->DOUTR; 
	  
	AES128->CR |= 0x01 << AES128_CR_CCFC_POS;           //AESɱ־
}



