#ifndef __BL210x_WDT_H__
#define __BL210x_WDT_H__

#include "BL210x.h"
typedef enum
{ 
	ClkSel_32K =   0x00,     //WDTʱԴΪ32K   
	ClkSel_SYS =   0x01      //WDTʱԴΪϵͳʱ
} ClkSel_TypeDef;

typedef enum
{ 
	RstEn_DISABLE =  0x00,    // ֹλ
	RstEn_ENABLE =   0x01     // ʹܸλ
} RstEn_TypeDef;

#ifdef IC_BL2102
typedef struct
{                                               
	RstEn_TypeDef     RstEn;       //ʹܸλ
	uint32_t          Load;        //װֵ
} IWDT_InitTypeDef;
#else
typedef struct
{            
    ClkSel_TypeDef    ClkSel;      //ʱѡ                                     
	RstEn_TypeDef     RstEn;       //ʹܸλ
	uint32_t          Load;        //װֵ
} WDT_InitTypeDef;
#endif
#ifdef IC_BL2102
void IWDT_Init(IWDT_InitTypeDef * IWDT_InitStruct);    //IWDTʼ
void IWDT_Start(void);                               //IWDT
void IWDT_Stop(void);                                //ֹͣIWDT
void IWDT_FEED(void);                                //IWDTι
uint8_t IWDT_INTStat(void);                          //ѯIWDTж״̬
void IWDT_INTClr(void);                              //IWDTж״̬

#else
void WDT_Init(WDT_InitTypeDef * WDT_InitStruct);
void WDT_Start(void);                               //WDT
void WDT_Stop(void);                                //ֹͣWDT
void WDT_FEED(void);                                //WDTι
uint8_t WDT_INTStat(void);                          //ѯWDTж״̬
void WDT_INTClr(void);                              //WDTж״̬

#endif


#endif //__BL210x_WDT_H__
