#include "BL210x_port.h"


/****************************************************************************************************************************************** 
* : PORT_Init()
* ˵:	˿Źѡ
*     : PORT_InitTypeDef* PORT_InitStruct
*     : 
* ע: 
******************************************************************************************************************************************/
void PORT_Init(PORT_InitTypeDef* PORT_InitStruct)
{
	switch(PORT_InitStruct->Port)
	{
		case PORTA:
			
#ifdef IC_BL2101
  		PORT->PORTA_SEL &= ~(0x03 << ((PORT_InitStruct->Pin)*2));                           
			PORT->PORTA_SEL |= ((PORT_InitStruct->Func) << ((PORT_InitStruct->Pin)*2));          //PORTA IO˿ڹ
#endif
		
#ifdef IC_BL2102
			if(PORT_InitStruct->Pin <= GPIO_PIN7)
			{
				PORT->PORTA_SEL0 &= ~(0x0F << ((PORT_InitStruct->Pin)*4)); 
				PORT->PORTA_SEL0 |= ((PORT_InitStruct->Func) << ((PORT_InitStruct->Pin)*4));                   //PORTA0-7 IO??????
			}
			else if(PORT_InitStruct->Pin <= GPIO_PIN15)
			{
				PORT->PORTA_SEL1 &= ~(0x0F << ((PORT_InitStruct->Pin - GPIO_PIN8)*4)); 
				PORT->PORTA_SEL1 |= ((PORT_InitStruct->Func) << ((PORT_InitStruct->Pin - GPIO_PIN8)*4));       //PORTA8-15 IO??????
			}
#endif		
			
			if(PORT_InitStruct->Input_En == ENABLE)                                 
			{
				PORT->PORTA_INEN |=  (1 << (PORT_InitStruct->Pin));            //ʹܴ
			}
			else
			{
				PORT->PORTA_INEN &=  ~(1 << (PORT_InitStruct->Pin));           //ʹܹر
			}
		break;

#ifdef IC_BL2101			
		case PORTB:
			
			PORT->PORTB_SEL &= ~(0x03 << ((PORT_InitStruct->Pin)*2));
			PORT->PORTB_SEL |= ((PORT_InitStruct->Func) << ((PORT_InitStruct->Pin)*2));        //PORTB IO˿ڹ
			
			if(PORT_InitStruct->Input_En)
			{
				PORT->PORTB_INEN |=  (1 << (PORT_InitStruct->Pin));            //ʹܴ
			}
			else
			{
				PORT->PORTB_INEN &=  ~(1 << (PORT_InitStruct->Pin));           //ʹܹر
			}
		break;
#endif
			
		default:
		break;
	}
}

/****************************************************************************************************************************************** 
* : PORT_CFG_Init()
* ˵:	˿
*     : PORT_CFGTypeDef* PORT_CFGStruct
*     : 
* ע: 
******************************************************************************************************************************************/
void PORT_CFG_Init(PORT_CFGTypeDef* PORT_CFGStruct)
{

#ifdef IC_BL2101
	PORT->PORT_CFG &= ~(3 << PORT_CFG_A0_7_DS_POS);
	PORT->PORT_CFG |=  ((PORT_CFGStruct->Out_Cur_A0_7) << PORT_CFG_A0_7_DS_POS);           //PORTA0-A7
		
	PORT->PORT_CFG &= ~(3 << PORT_CFG_A8_15_DS_POS);
	PORT->PORT_CFG |=  ((PORT_CFGStruct->Out_Cur_A8_15) << PORT_CFG_A8_15_DS_POS);         //PORTA8-A15

	PORT->PORT_CFG &= ~(3 << PORT_CFG_B0_7_DS_POS);
	PORT->PORT_CFG |=  ((PORT_CFGStruct->Out_Cur_B0_7) << PORT_CFG_B0_7_DS_POS);           //PORTB0-B7
		
	PORT->PORT_CFG &= ~(3 << PORT_CFG_PUR_POS);
	PORT->PORT_CFG |=  ((PORT_CFGStruct->PullUp_Res) << PORT_CFG_PUR_POS);                 //ö˿PORTA PORTB
	
	PORT->PORT_CFG &= ~(1 << PORT_CFG_HYS_POS);
	PORT->PORT_CFG |=  ((PORT_CFGStruct->InputHys) << PORT_CFG_HYS_POS);                   //PORTA PORTB͵ȼ
	
	PORT->PORT_CFG &= ~(1 << PORT_CFG_WKRF_POS);
	PORT->PORT_CFG |=  ((PORT_CFGStruct->WakeUp_Edge) << PORT_CFG_WKRF_POS);	             //PORTA PORTBĻѹ
#endif
	
#ifdef IC_BL2102
	PORT->PORT_CFG &= ~(0x03 << PORT_CFG_DS_POS);
	PORT->PORT_CFG |=  ((PORT_CFGStruct->Out_Cur) << PORT_CFG_DS_POS);                     //PORTA
	
	PORT->PORT_CFG &= ~(0x03 << PORT_CFG_PUR_POS);
	PORT->PORT_CFG |=  ((PORT_CFGStruct->PullUp_Res) << PORT_CFG_PUR_POS);                 //ö˿PORTA
	
	PORT->PORT_CFG &= ~(0x01 << PORT_CFG_HYS_POS);
	PORT->PORT_CFG |=  ((PORT_CFGStruct->InputHys) << PORT_CFG_HYS_POS);                   //PORTA͵ȼ
	
	PORT->PORT_CFG &= ~(0x01 << PORT_CFG_WKRF_POS);
	PORT->PORT_CFG |=  ((PORT_CFGStruct->WakeUp_Edge) << PORT_CFG_WKRF_POS);	             //PORTAĻѹ

#endif
	
}



