#ifndef __UART_H
#define __UART_H

#include "BL210x.h" 

#define WDT_TEST    		0	
#define SPI_TEST    		0	
#define IIC_TEST    		0	
#define LOWPOWER_TEST   0	
#define FLASH_TEST    	1
#define ADC_TEST    		1	
#define TIMER_TEST    	1
#define UART_TEST    		1
#define PWM_BASE_TEST   0
#define PWM_PLUS_TEST   1
#define EXTI_TEST			  0

extern uint8_t Rec_Data[100];
extern uint16_t Serial_timeout_1ms;    //ڳʱֵ


extern uint16_t time_1ms;           //1ms
extern uint16_t time_10ms;          //10ms
extern uint16_t time_100ms;         //100ms

//A9 A10SWDؿڣʱòҪΪIO

/* LED1ӵGPIO˿, ûֻҪ޸Ĵ뼴ɸıƵLED1 */
#define LED1_GPIO_PORT    	GPIOA		                /* GPIO˿ */
#define LED1_GPIO_PIN		GPIO_PIN8			        /* ӵLED1GPIO */

/* LED2ӵGPIO˿, ûֻҪ޸Ĵ뼴ɸıƵLED2 */
#define LED2_GPIO_PORT    	GPIOA		                /* GPIO˿ */
#define LED2_GPIO_PIN		GPIO_PIN10			        /* ӵLED2GPIO */

/* LED3ӵGPIO˿, ûֻҪ޸Ĵ뼴ɸıƵLED3 */
#define LED3_GPIO_PORT    	GPIOA		                /* GPIO˿ */
#define LED3_GPIO_PIN		GPIO_PIN11			        /* ӵLED3GPIO */

/* LED4ӵGPIO˿, ûֻҪ޸Ĵ뼴ɸıƵLED4 */
#define LED4_GPIO_PORT    	GPIOA		                /* GPIO˿ */
#define LED4_GPIO_PIN		GPIO_PIN12			        /* ӵLED4GPIO */


/* IOĺ  ˴LEDǹģҲ͵ƽLED*/
#define LED1_TOGGLE		   GPIO_InvBit(LED1_GPIO_PORT,LED1_GPIO_PIN)
#define LED1_OFF		   GPIO_ClrBit(LED1_GPIO_PORT,LED1_GPIO_PIN)
#define LED1_ON			   GPIO_SetBit(LED1_GPIO_PORT,LED1_GPIO_PIN)

#define LED2_TOGGLE		   GPIO_InvBit(LED2_GPIO_PORT,LED2_GPIO_PIN)
#define LED2_OFF		   GPIO_ClrBit(LED2_GPIO_PORT,LED2_GPIO_PIN)
#define LED2_ON			   GPIO_SetBit(LED2_GPIO_PORT,LED2_GPIO_PIN)

#define LED3_TOGGLE		   GPIO_InvBit(LED3_GPIO_PORT,LED3_GPIO_PIN)
#define LED3_OFF		       GPIO_ClrBit(LED3_GPIO_PORT,LED3_GPIO_PIN)
#define LED3_ON		   GPIO_SetBit(LED3_GPIO_PORT,LED3_GPIO_PIN)

#define LED4_TOGGLE		   GPIO_InvBit(LED4_GPIO_PORT,LED4_GPIO_PIN)
#define LED4_OFF		       GPIO_ClrBit(LED4_GPIO_PORT,LED4_GPIO_PIN)
#define LED4_ON		   GPIO_SetBit(LED4_GPIO_PORT,LED4_GPIO_PIN)

#define PWMPLUS_IO0_GPIO_PORT  GPIOA
#define PWMPLUS_IO0_GPIO_PIN   GPIO_PIN8

#define PWMPLUS_IO1_GPIO_PORT  GPIOA
#define PWMPLUS_IO1_GPIO_PIN   GPIO_PIN9

#define PWMPLUS_IO2_GPIO_PORT  GPIOA
#define PWMPLUS_IO2_GPIO_PIN   GPIO_PIN10

#define PWMPLUS_IO0_TOGGLE		   GPIO_InvBit(PWMPLUS_IO0_GPIO_PORT,PWMPLUS_IO0_GPIO_PIN)
#define PWMPLUS_IO1_TOGGLE		   GPIO_InvBit(PWMPLUS_IO1_GPIO_PORT,PWMPLUS_IO1_GPIO_PIN)
#define PWMPLUS_IO2_TOGGLE		   GPIO_InvBit(PWMPLUS_IO2_GPIO_PORT,PWMPLUS_IO2_GPIO_PIN)

//=========iic============
#define AT24C01		127
#define AT24C02		255
#define AT24C04		511
#define AT24C08		1023
#define AT24C16		2047
#define AT24C32		4095
#define AT24C64	    8191
#define AT24C128	16383
#define AT24C256	32767

#define EEPROM_DEV_ADDR			  0xA0		      /* 24xx02豸ַ */
#define EEPROM_PAGE_SIZE		  8			      /* 24xx02ҳС */
#define EEPROM_SIZE				  256			  /* 24xx02 */

//ʹõ24c02ԶEE_TYPEΪAT24C02
#define EE_TYPE     AT24C02



#define EEPROM_I2C_WR	0		/* дbit */
#define EEPROM_I2C_RD	1		/* bit */

#define ACK      0x01           //Ӧ
#define NACK     0x00           //Ӧ
//=========iic============
//=========power============
#define MODE_STANDBY         1
#define MODE_SLEEP           2
#define MODE_STOP            4

#define WAKEUP_IO            1
//=========power============
//=========IWDT============
#define IWDT_32K_TEST          0      //32Kʱ  ܸλ  ʱι
#define IWDT_32K_INT_TEST      1      //32Kʱ  ܸλ  жϴ
#define IWDT_32K_RST_TEST      2      //32Kʱ  ʹܸλ
//=========IWDT============
//=========PWMBASE============
#define PWMBASE_IO0_GPIO_PORT  GPIOA
#define PWMBASE_IO0_GPIO_PIN   GPIO_PIN8

#define PWMBASE_IO1_GPIO_PORT  GPIOA
#define PWMBASE_IO1_GPIO_PIN   GPIO_PIN9

#define PWMBASE_IO2_GPIO_PORT  GPIOA
#define PWMBASE_IO2_GPIO_PIN   GPIO_PIN10



#define PWMBASE_IO0_TOGGLE		   GPIO_InvBit(PWMBASE_IO0_GPIO_PORT,PWMBASE_IO0_GPIO_PIN)
#define PWMBASE_IO1_TOGGLE		   GPIO_InvBit(PWMBASE_IO1_GPIO_PORT,PWMBASE_IO1_GPIO_PIN)
#define PWMBASE_IO2_TOGGLE		   GPIO_InvBit(PWMBASE_IO2_GPIO_PORT,PWMBASE_IO2_GPIO_PIN)
//=========PWMBASE============
//=========EXIT============
#define KEY1_GPIO_CLK 	    SYS_CLKEN_GPIOA_POS		    /* GPIO˿ʱ */
#define KEY1_GPIO_PORT    	GPIOA		                /* GPIO˿ */
#define KEY1_GPIO_PIN		GPIO_PIN4			        /* ӵKEY1GPIO */ 

#define KEY2_GPIO_CLK 	    SYS_CLKEN_GPIOA_POS		    /* GPIO˿ʱ */
#define KEY2_GPIO_PORT    	GPIOA		                /* GPIO˿ */
#define KEY2_GPIO_PIN		GPIO_PIN5			        /* ӵKEY2GPIO */ 

#define KEY3_GPIO_CLK 	    SYS_CLKEN_GPIOB_POS		    /* GPIO˿ʱ */
#define KEY3_GPIO_PORT    	GPIOA		                /* GPIO˿ */
#define KEY3_GPIO_PIN		GPIO_PIN6			        /* ӵKEY3GPIO */ 

#define KEY4_GPIO_CLK 	    SYS_CLKEN_GPIOA_POS		    /* GPIO˿ʱ */
#define KEY4_GPIO_PORT    	GPIOA		                /* GPIO˿ */
#define KEY4_GPIO_PIN		GPIO_PIN7			        /* ӵKEY4GPIO */


#define KEY1_IRQn           GPIOA4_IRQn
#define KEY2_IRQn           GPIOA5_IRQn
#define KEY3_IRQn           GPIOA6_IRQn
#define KEY4_IRQn           GPIOA7_IRQn

#define KEY1_Handler        GPIOA4_Handler
#define KEY2_Handler        GPIOA5_Handler
#define KEY3_Handler        GPIOA6_Handler
#define KEY4_Handler        GPIOA7_Handler

extern uint8_t Flag_Key1;
extern uint8_t Flag_Key2;
extern uint8_t Flag_Key3;
extern uint8_t Flag_Key4;
//=========EXIT============
void timer_1ms_init(void);          //1msʱ
void TIMER_H16_Init(void);          //16λʱ
void TIMER_HL32_Init(void);         //32λʱ
void uart_init(void);
void uart_test_tx_rx(uint8_t senddata);
void led_init(void);	              //LEDʼ 
void adc_test(void);

void PWMPLUS_Init(void);
void PWMPLUS_IO_Indicate(void);
void PWMPLUS0_user_handle(void);
void eflash_test(void);
void lowpower_test(void);
void i2c_test(void);
void timer_test(void);
void spi_test(void);
void iwdt_test(void);
void uart_test(void);
void pwm_base_test(void);
void pwm_plus_test(void);
void exti_test(void);
#endif /* __UART_H */

