#include "BL210x_flash.h"

/****************************************************************************************************************************************** 
* : FLASH_Init()
* ˵:	FLASHʼ
*     : uint8_t Read_Mode  ģʽ  0:߶  1: 2߶  2: 4߶	   
*			uint8_t ClkDiv     ʱӷƵ  0: 8Ƶ  1: 4Ƶ  2:  2Ƶ   3:  1Ƶ
*     : 
* ע: 
******************************************************************************************************************************************/
void FLASH_Init(uint8_t Read_Mode,uint8_t ClkDiv)
{
	FLASH->CFG &= ~(0x03 << FLASH_CFG_READMODE_POS);
	FLASH->CFG |=  (Read_Mode << FLASH_CFG_READMODE_POS);
	
	FLASH->CFG &= ~(0x03 << FLASH_CFG_CLKDIV_POS);
	FLASH->CFG |=  (ClkDiv << FLASH_CFG_CLKDIV_POS);
	
	FLASH_Quad_Enable();
}


/****************************************************************************************************************************************** 
* : FLASH_Write_Command()
* ˵:	FLASHд
*     : uint8_t cmd	   
*			
*     : 
* ע: 
******************************************************************************************************************************************/
void FLASH_Write_Command(uint8_t cmd)
{
	FLASH->CFG &= ~(0x0F << FLASH_CFG_CMD_POS);
	FLASH->CFG |=  (cmd  << FLASH_CFG_CMD_POS);
}


/****************************************************************************************************************************************** 
* : FLASH_Check_Busy()
* ˵:	FLASHæ־
*     :    
*			
*     : 1 :  ڽеǰУæ״̬   0: ڿ״̬
* ע: 
******************************************************************************************************************************************/
uint8_t FLASH_Check_Busy(void)
{
	if(FLASH->STATE & FLASH_STATE_BUSY_MSK)
	{
		return 1;
	}
	else
	{
		return 0;
	}
}

/****************************************************************************************************************************************** 
* : FLASH_Check_ProgramDataValid()
* ˵:	FLASHʱ,ݼĴЧ־ѯ
*     :    
*			
*     : 1 :  ʱ,ݼĴûз,дµ    0: ʱ,ݼĴûЧ,дµ
* ע: 
******************************************************************************************************************************************/
uint8_t FLASH_Check_ProgramDataValid(void)
{
	if(FLASH->STATE & FLASH_STATE_PROG_VALID_MSK)
	{
		return 1;
	}
	else
	{
		return 0;
	}
}

/****************************************************************************************************************************************** 
* : FLASH_Prog_Predata_End()
* ˵:	FLASHҳ̲Ԥ
*     :    
*			
*     : 
* ע: 
******************************************************************************************************************************************/
void FLASH_Prog_Predata_End(void)
{
	FLASH->START |= 0x01 << FLASH_START_PROG_END_POS;
}

/****************************************************************************************************************************************** 
* : FLASH_Command_Start()
* ˵:	FLASH
*     :    
*			
*     : 
* ע: 
******************************************************************************************************************************************/
void FLASH_Command_Start(void)
{
	FLASH->START |= 0x01 << FLASH_START_EN_POS;     //
	
	while(FLASH_Check_Busy());                      //æ־
}

/****************************************************************************************************************************************** 
* : FLASH_Write_Enable()
* ˵:	FLASHдʹ
*     :    
*			
*     : 
* ע: 
******************************************************************************************************************************************/
void FLASH_Write_Enable(void)
{
	while(FLASH_Check_Busy());                     //æ־
	
	FLASH_Write_Command(FLASH_WriteEnable);        //дʹ

	FLASH_Command_Start();                         //FLASH
}

/****************************************************************************************************************************************** 
* : FLASH_Set_DeepPowerDown()
* ˵:	FLASH͹
*     :    
*			
*     : 
* ע: 
******************************************************************************************************************************************/
void FLASH_Set_DeepPowerDown(void)
{
	while(FLASH_Check_Busy());                     //æ־
	
	FLASH_Write_Command(FLASH_DeepPowerDown);      //͹

	FLASH_Command_Start();                         //FLASH
}

/****************************************************************************************************************************************** 
* : FLASH_ReSet_DeepPowerDown()
* ˵:	FLASH˳͹
*     :    
*			
*     : 
* ע: 
******************************************************************************************************************************************/
void FLASH_ReSet_DeepPowerDown(void)
{
	while(FLASH_Check_Busy());                     //æ־
	
	FLASH_Write_Command(FLASH_RelDeepPowerDown);   //˳͹

	FLASH_Command_Start();                         //FLASH
}

/****************************************************************************************************************************************** 
* : FLASH_Wait_WIP()
* ˵:	FLASHȴ
*     :    
*			
*     : 
* ע: 
******************************************************************************************************************************************/
void FLASH_Wait_WIP(void)
{
	uint8_t Rec = 1;
	
	while(Rec)
	{
		while(FLASH_Check_Busy());                     //æ־
	
		FLASH_Write_Command(FLASH_ReadStatusRegL);     //״̬ĴͰλ

		FLASH_Command_Start();                         //FLASH 
		
		Rec = FLASH->RDATA & 0x01;                     //ȡĴ,Ϊ0ʱ,ʾ
	}
}


/****************************************************************************************************************************************** 
* : FLASH_Erase_Command()
* ˵:	FLASH
*     : uint8_t erase   FLASH PAGE ERASE    FLASH_SectorErase       
*	        uint32_t addr   ׵ַ		
*     : 
* ע: 
******************************************************************************************************************************************/
void FLASH_Erase_Command(uint8_t erase,uint32_t addr)
{
	TIMPLUS_Stop(TIMPLUS0,TIMPLUS_LOW); 
	
	FLASH_Write_Enable();                          //FLASHдʹ
	
	FLASH->ADDR = addr>>2;                         //ַתΪΪλ
	
	FLASH_Write_Command(erase);                    //FLASH PAGE ERASE  SECTOR ERASE  
	
	FLASH_Command_Start();                         //FLASH 
	
	FLASH_Wait_WIP();                              //FLASHȴ
TIMPLUS_Start(TIMPLUS0,TIMPLUS_LOW); 
}

/****************************************************************************************************************************************** 
* : FLASH_Quad_Enable()
* ˵:	FLASH ģʽʹ
*     :   
*			
*     : 
* ע: 
******************************************************************************************************************************************/
void FLASH_Quad_Enable(void)
{
	FLASH_Write_Enable();                          //FLASHдʹ
	
	FLASH->WDATA = 0x0200;                         //Quad_Enable
	
	while(FLASH_Check_Busy());                     //æ־
	
	FLASH_Write_Command(FLASH_WriteStatusReg);     //д״̬Ĵ    

	FLASH_Command_Start();                         //FLASH 
	
	FLASH_Wait_WIP();                              //FLASHȴ
}


/****************************************************************************************************************************************** 
* : FLASH_Write_Word()
* ˵:	FLASHд   
*     : uint8_t cmd        ߷ʽ
*			uint32_t addr  ַ
*           uint32_t data  
*     : 
* ע: 
******************************************************************************************************************************************/
void FLASH_Write_Word(uint8_t cmd,uint32_t addr,uint32_t data)
{
	TIMPLUS_Stop(TIMPLUS0,TIMPLUS_LOW); 
	FLASH_Write_Enable();                          //FLASHдʹ
	
	FLASH->ADDR = addr>>2;                         //ַתΪΪλ
	
	FLASH_Write_Command(cmd);                      //FLASHд   FLASH_SinglePageProgram    FLASH_DualPageProgram    FLASH_QuadPageProgram  

	FLASH->START |= 0x01 << FLASH_START_EN_POS;    //
	
	while(FLASH_Check_ProgramDataValid());         //FLASHʱ,ݼĴЧ־ѯ
	
	FLASH->WDATA = data;                           //ݷŵдݼĴ
	
	while(FLASH_Check_ProgramDataValid());         //FLASHʱ,ݼĴЧ־ѯ
	
	FLASH_Prog_Predata_End();                      //FLASHҳ̲Ԥ
	
	while(FLASH_Check_Busy());                     //æ־
	
	FLASH_Wait_WIP();                              //FLASHȴ	
	TIMPLUS_Start(TIMPLUS0,TIMPLUS_LOW); 
}

/****************************************************************************************************************************************** 
* : FLASH_Write_Words()
* ˵:	FLASHд  
*     : uint8_t cmd          ߷ʽ
*			uint32_t addr    ַ
*           uint32_t data[]  
*           uint32_t num       Ϊλ  ܳ64   Ҳ256ֽ
*     : 0  ̳ɹ   1  ʧ
* ע: 
******************************************************************************************************************************************/
uint8_t FLASH_Write_Words(uint8_t cmd,uint32_t addr,uint32_t data[],uint32_t num)
{
	uint32_t i = 0;
	
	if(num > 64 || ((((addr%256) >>2)+ num) > 64))
	{
		return 1;
	}
	
	FLASH_Write_Enable();                          //FLASHдʹ
	
	FLASH->ADDR = addr>>2;                         //ַתΪΪλ
	
	FLASH_Write_Command(cmd);                      //FLASHд   FLASH_SinglePageProgram    FLASH_DualPageProgram    FLASH_QuadPageProgram  

	FLASH->START |= 0x01 << FLASH_START_EN_POS;    //
	
	for(i = 0;i < num;i++)
	{
		while(FLASH_Check_ProgramDataValid());         //FLASHʱ,ݼĴЧ־ѯ
	
		FLASH->WDATA = data[i];                        //ݷŵдݼĴ
	}
	
	while(FLASH_Check_ProgramDataValid());         //FLASHʱ,ݼĴЧ־ѯ
	
	FLASH_Prog_Predata_End();                      //FLASHҳ̲Ԥ
	
	while(FLASH_Check_Busy());                     //æ־
	
	FLASH_Wait_WIP();                              //FLASHȴ	
	
	return 0;
}

/****************************************************************************************************************************************** 
* : FLASH_Read_Word_1()
* ˵:	FLASH  
*     : uint8_t cmd        ߷ʽ
*			uint32_t addr  ַ
*     : 
* ע: 
******************************************************************************************************************************************/
uint32_t FLASH_Read_Word_1(uint8_t cmd,uint32_t addr)
{
	FLASH->ADDR = addr>>2;                         //ַתΪΪλ
	
	FLASH->CFG &= ~(0x03 << FLASH_CFG_READMODE_POS);
	FLASH->CFG |=  (cmd << FLASH_CFG_READMODE_POS);    //߶  ˫߶  ߶ 
	
	FLASH_Write_Command(FLASH_ReadData);           //   ߶  ˫߶  ߶  ȡRD_MDĴ
	
	FLASH_Command_Start();                         //FLASH 
	
	return FLASH->RDATA;                           //ض
}


/****************************************************************************************************************************************** 
* : FLASH_Read_Word_2()
* ˵:	FLASH  
*     : uint8_t cmd        ߷ʽ
*			uint32_t addr  ַ
*     : 
* ע: 
******************************************************************************************************************************************/
uint32_t FLASH_Read_Word_2(uint32_t addr)
{
	addr = (addr>>2)<<2;               //ֶַ
	return *((volatile unsigned int *)(FLASH_DATA_ADDR + addr));    //ȡõַ
}



