#include "BL2101_pwm.h"


/****************************************************************************************************************************************** 
* :	PWM_Init()
* ˵:	PWMʼ
*     : uint32_t pwmx			ָҪõPWMЧֵPWM0PWM1PWM2PWM3PWM4
*			PWM_InitStructure * initStruct	PWM趨ֵĽṹ
*     : 
* ע: 
******************************************************************************************************************************************/
void PWM_Init(PWM_TypeDef * PWMx, PWM_InitTypeDef * PWM_InitStruct)
{
	SYS->CLKEN |= 0x01 << SYS_CLKEN_PWM_POS;                       //PWMʱ
	
	PWM_Stop(PWMx);                                                //رPWMֹͣPWM
	
	PWMG->DIV = PWM_InitStruct->clkdiv;                            //PWMƵϵ
	
	switch((uint32_t)PWMx)
	{
		case((uint32_t)PWM0):
		
			if(PWM_InitStruct->Inv)                                //źŷת
			{
				PWMG->INV |= (0x01 << PWMG_PWM0_INV_POS);
			}
			else
			{
				PWMG->INV &= ~(0x01 << PWMG_PWM0_INV_POS);
			}
			
			if(PWM_InitStruct->HEndIE)                             //ߵƽж
			{
				PWMG->IE |= (0x01 << PWMG_PWM0_HEND_IE_POS);
			}
			else
			{
				PWMG->IE &= ~(0x01 << PWMG_PWM0_HEND_IE_POS);
			}
			
			if(PWM_InitStruct->OvfIE)                              //ж
			{
				PWMG->IE |= (0x01 << PWMG_PWM0_OVF_IE_POS);
			}
			else
			{
				PWMG->IE &= ~(0x01 << PWMG_PWM0_OVF_IE_POS);
			}
		
		break;
		
		case((uint32_t)PWM1):
		
			if(PWM_InitStruct->Inv)                                //źŷת
			{
				PWMG->INV |= (0x01 << PWMG_PWM1_INV_POS);
			}
			else
			{
				PWMG->INV &= ~(0x01 << PWMG_PWM1_INV_POS);
			}
			
			if(PWM_InitStruct->HEndIE)                             //ߵƽж
			{
				PWMG->IE |= (0x01 << PWMG_PWM1_HEND_IE_POS);
			}
			else
			{
				PWMG->IE &= ~(0x01 << PWMG_PWM1_HEND_IE_POS);
			}
			
			if(PWM_InitStruct->OvfIE)                              //ж
			{
				PWMG->IE |= (0x01 << PWMG_PWM1_OVF_IE_POS);
			}
			else
			{
				PWMG->IE &= ~(0x01 << PWMG_PWM1_OVF_IE_POS);
			}
			
		break;
		
		case((uint32_t)PWM2):
		
			if(PWM_InitStruct->Inv)                                //źŷת
			{
				PWMG->INV |= (0x01 << PWMG_PWM2_INV_POS);
			}
			else
			{
				PWMG->INV &= ~(0x01 << PWMG_PWM2_INV_POS);
			}
			
			if(PWM_InitStruct->HEndIE)                             //ߵƽж
			{
				PWMG->IE |= (0x01 << PWMG_PWM2_HEND_IE_POS);
			}
			else
			{
				PWMG->IE &= ~(0x01 << PWMG_PWM2_HEND_IE_POS);
			}
			
			if(PWM_InitStruct->OvfIE)                              //ж
			{
				PWMG->IE |= (0x01 << PWMG_PWM2_OVF_IE_POS);
			}
			else
			{
				PWMG->IE &= ~(0x01 << PWMG_PWM2_OVF_IE_POS);
			}
	
		break;
		
		case((uint32_t)PWM3):
		
			if(PWM_InitStruct->Inv)                                //źŷת
			{
				PWMG->INV |= (0x01 << PWMG_PWM3_INV_POS);
			}
			else
			{
				PWMG->INV &= ~(0x01 << PWMG_PWM3_INV_POS);
			}
			
			if(PWM_InitStruct->HEndIE)                             //ߵƽж
			{
				PWMG->IE |= (0x01 << PWMG_PWM3_HEND_IE_POS);
			}
			else
			{
				PWMG->IE &= ~(0x01 << PWMG_PWM3_HEND_IE_POS);
			}
			
			if(PWM_InitStruct->OvfIE)                              //ж
			{
				PWMG->IE |= (0x01 << PWMG_PWM3_OVF_IE_POS);
			}
			else
			{
				PWMG->IE &= ~(0x01 << PWMG_PWM3_OVF_IE_POS);
			}
			
		break;
		
		case((uint32_t)PWM4):
		
			if(PWM_InitStruct->Inv)                                //źŷת
			{
				PWMG->INV |= (0x01 << PWMG_PWM4_INV_POS);
			}
			else
			{
				PWMG->INV &= ~(0x01 << PWMG_PWM4_INV_POS);
			}
			
			if(PWM_InitStruct->HEndIE)                             //ߵƽж
			{
				PWMG->IE |= (0x01 << PWMG_PWM4_HEND_IE_POS);
			}
			else
			{
				PWMG->IE &= ~(0x01 << PWMG_PWM4_HEND_IE_POS);
			}
			
			if(PWM_InitStruct->OvfIE)                              //ж
			{
				PWMG->IE |= (0x01 << PWMG_PWM4_OVF_IE_POS);
			}
			else
			{
				PWMG->IE &= ~(0x01 << PWMG_PWM4_OVF_IE_POS);
			}
	
		break;	
	}
	
	if(PWM_InitStruct->period == 0 || PWM_InitStruct->period > 0xFFF)
	{
		PWM_InitStruct->period = 0xFFF;
	}
	
	if(PWM_InitStruct->period < PWM_InitStruct->high)
	{
		PWM_InitStruct->high = 0;
	}
	
	PWMx->PERIOD = PWM_InitStruct->period;                         //PWM
	PWMx->HIGH = PWM_InitStruct->high;	                           //PWMߵƽ

	if(PWM_InitStruct->HEndIE | PWM_InitStruct->OvfIE)             //жʹ
	{
		NVIC_EnableIRQ(PWM_IRQn);
	}
}

/****************************************************************************************************************************************** 
* :	PWM_Start()
* ˵:	PWMʼPWM
*     : PWM_TypeDef * PWMx			ָҪõPWMЧֵPWM0PWM1PWM2PWM3PWM4
*     : 
* ע: 
******************************************************************************************************************************************/
void PWM_Start(PWM_TypeDef * PWMx)
{
	switch((uint32_t)PWMx)
	{
		case((uint32_t)PWM0):
		
			PWMG->EN |= 0x01 << PWMG_PWM0_EN_POS;
		
		break;
		
		case((uint32_t)PWM1):
		
			PWMG->EN |= 0x01 << PWMG_PWM1_EN_POS;
	
		break;
		
		case((uint32_t)PWM2):
		
			PWMG->EN |= 0x01 << PWMG_PWM2_EN_POS;
	
		break;
		
		case((uint32_t)PWM3):
		
			PWMG->EN |= 0x01 << PWMG_PWM3_EN_POS;
	
		break;
		
		case((uint32_t)PWM4):
		
			PWMG->EN |= 0x01 << PWMG_PWM4_EN_POS;
	
		break;	
	}
}

/****************************************************************************************************************************************** 
* :	PWM_Stop()
* ˵:	رPWMֹͣPWM
*     : PWM_TypeDef * PWMx			ָҪõPWMЧֵPWM0PWM1PWM2PWM3PWM4
*     : 
* ע: 
******************************************************************************************************************************************/
void PWM_Stop(PWM_TypeDef * PWMx)
{
	switch((uint32_t)PWMx)
	{
		case((uint32_t)PWM0):
		
			PWMG->EN &= ~(0x01 << PWMG_PWM0_EN_POS);
		
		break;
		
		case((uint32_t)PWM1):
		
			PWMG->EN &= ~(0x01 << PWMG_PWM1_EN_POS);
	
		break;
		
		case((uint32_t)PWM2):
		
			PWMG->EN &= ~(0x01 << PWMG_PWM2_EN_POS);
	
		break;
		
		case((uint32_t)PWM3):
		
			PWMG->EN &= ~(0x01 << PWMG_PWM3_EN_POS);
	
		break;
		
		case((uint32_t)PWM4):
		
			PWMG->EN &= ~(0x01 << PWMG_PWM4_EN_POS);
	
		break;
		
	}
}


/****************************************************************************************************************************************** 
* :	PWM_SetClkDiv()
* ˵:	ԤƵϵ
*     : uint8_t clk_div   
*			
*     : 
* ע: 
******************************************************************************************************************************************/
void PWM_SetClkDiv(uint8_t clk_div)
{
	PWMG->DIV = clk_div;
}


/****************************************************************************************************************************************** 
* :	PWM_SetOutInv()
* ˵:	PWMźŷת
*     : PWM_TypeDef * PWMx			ָҪõPWMЧֵPWM0PWM1PWM2PWM3PWM4
*     : 
* ע: 
******************************************************************************************************************************************/
void PWM_SetOutInv(PWM_TypeDef * PWMx)
{
	switch((uint32_t)PWMx)
	{
		case((uint32_t)PWM0):
		
			PWMG->INV |= (0x01 << PWMG_PWM0_INV_POS);
		
		break;
		
		case((uint32_t)PWM1):
		
			PWMG->INV |= (0x01 << PWMG_PWM1_INV_POS);
	
		break;
		
		case((uint32_t)PWM2):
		
			PWMG->INV |= (0x01 << PWMG_PWM2_INV_POS);
	
		break;
		
		case((uint32_t)PWM3):
		
			PWMG->INV |= (0x01 << PWMG_PWM3_INV_POS);
	
		break;
		
		case((uint32_t)PWM4):
		
			PWMG->INV |= (0x01 << PWMG_PWM4_INV_POS);
	
		break;	
	}
}


/****************************************************************************************************************************************** 
* :	PWM_ReSetOutInv()
* ˵:	PWMźŲת
*     : PWM_TypeDef * PWMx			ָҪõPWMЧֵPWM0PWM1PWM2PWM3PWM4
*     : 
* ע: 
******************************************************************************************************************************************/
void PWM_ReSetOutInv(PWM_TypeDef * PWMx)
{
	switch((uint32_t)PWMx)
	{
		case((uint32_t)PWM0):
		
			PWMG->INV &= ~(0x01 << PWMG_PWM0_INV_POS);
		
		break;
		
		case((uint32_t)PWM1):
		
			PWMG->INV &= ~(0x01 << PWMG_PWM1_INV_POS);
	
		break;
		
		case((uint32_t)PWM2):
		
			PWMG->INV &= ~(0x01 << PWMG_PWM2_INV_POS);
	
		break;
		
		case((uint32_t)PWM3):
		
			PWMG->INV &= ~(0x01 << PWMG_PWM3_INV_POS);
	
		break;
		
		case((uint32_t)PWM4):
		
			PWMG->INV &= ~(0x01 << PWMG_PWM4_INV_POS);
	
		break;	
	}
}

/****************************************************************************************************************************************** 
* :	PWM_SetPeriod()
* ˵:	
*     : PWM_TypeDef * PWMx			ָҪõPWMЧֵPWM0PWM1PWM2PWM3PWM4
*			uint32_t period			    Ҫ趨ֵ,12λ
*     : 
* ע: 
******************************************************************************************************************************************/
void PWM_SetPeriod(PWM_TypeDef * PWMx, uint32_t period)
{
	if(period == 0 || period > 0xFFF)
	{
		period = 0xFFF;
	}
	PWMx->PERIOD = period;
}


/****************************************************************************************************************************************** 
* :	PWM_GetPeriod()
* ˵:	ȡ
*     : PWM_TypeDef * PWMx			ָҪõPWMЧֵPWM0PWM1PWM2PWM3PWM4
*     : ֵ
* ע: 
******************************************************************************************************************************************/
uint32_t PWM_GetPeriod(PWM_TypeDef * PWMx)
{
	return PWMx->PERIOD;
}


/****************************************************************************************************************************************** 
* :	PWM_SetHigh()
* ˵:	øߵƽʱ
*     : PWM_TypeDef * PWMx			ָҪõPWMЧֵPWM0PWM1PWM2PWM3PWM4
*			uint32_t high			    Ҫ趨ĸߵƽʱ,12λ
*     : 
* ע: 
******************************************************************************************************************************************/
void PWM_SetHigh(PWM_TypeDef * PWMx, uint32_t high)
{
	if(high > PWM_GetPeriod(PWMx))
	{
		high = 0;
	}
	PWMx->HIGH = high;
}


/****************************************************************************************************************************************** 
* :	PWM_GetHigh()
* ˵:	ȡߵƽʱ
*     : PWM_TypeDef * PWMx			ָҪõPWMЧֵPWM0PWM1PWM2PWM3PWM4
*     : ߵƽʱ
* ע: 
******************************************************************************************************************************************/
uint32_t PWM_GetHigh(PWM_TypeDef * PWMx)
{
	return PWMx->HIGH;
}


/****************************************************************************************************************************************** 
* :	PWM_IntHEndEn()
* ˵: ߵƽжʹ
*     : PWM_TypeDef * PWMx			ָҪõPWMЧֵPWM0PWM1PWM2PWM3PWM4
*     : 
* ע: 
******************************************************************************************************************************************/
void PWM_IntHendEn(PWM_TypeDef * PWMx)
{
	switch((uint32_t)PWMx)
	{
		case((uint32_t)PWM0):
		
			PWMG->IE |= (0x01 << PWMG_PWM0_HEND_IE_POS);
		
		break;
		
		case((uint32_t)PWM1):
		
			PWMG->IE |= (0x01 << PWMG_PWM1_HEND_IE_POS);
	
		break;
		
		case((uint32_t)PWM2):
		
			PWMG->IE |= (0x01 << PWMG_PWM2_HEND_IE_POS);
	
		break;
		
		case((uint32_t)PWM3):
		
			PWMG->IE |= (0x01 << PWMG_PWM3_HEND_IE_POS);
	
		break;
		
		case((uint32_t)PWM4):
		
			PWMG->IE |= (0x01 << PWMG_PWM4_HEND_IE_POS);
	
		break;	
	}
}


/****************************************************************************************************************************************** 
* :	PWM_IntHendDis()
* ˵: ߵƽжϽ
*     : PWM_TypeDef * PWMx			ָҪõPWMЧֵPWM0PWM1PWM2PWM3PWM4
*     : 
* ע: 
******************************************************************************************************************************************/
void PWM_IntHendDis(PWM_TypeDef * PWMx)
{
	switch((uint32_t)PWMx)
	{
		case((uint32_t)PWM0):
		
			PWMG->IE &= ~(0x01 << PWMG_PWM0_HEND_IE_POS);
		
		break;
		
		case((uint32_t)PWM1):
		
			PWMG->IE &= ~(0x01 << PWMG_PWM1_HEND_IE_POS);
	
		break;
		
		case((uint32_t)PWM2):
		
			PWMG->IE &= ~(0x01 << PWMG_PWM2_HEND_IE_POS);
	
		break;
		
		case((uint32_t)PWM3):
		
			PWMG->IE &= ~(0x01 << PWMG_PWM3_HEND_IE_POS);
	
		break;
		
		case((uint32_t)PWM4):
		
			PWMG->IE &= ~(0x01 << PWMG_PWM4_HEND_IE_POS);
	
		break;
		
	}
}


/****************************************************************************************************************************************** 
* :	PWM_IntHendClr()
* ˵: ߵƽжϱ־
*     : PWM_TypeDef * PWMx			ָҪõPWMЧֵPWM0PWM1PWM2PWM3PWM4
*     : 
* ע: 
******************************************************************************************************************************************/
void PWM_IntHendClr(PWM_TypeDef * PWMx)
{
	switch((uint32_t)PWMx)
	{
		case((uint32_t)PWM0):
		
			PWMG->IF = (0x01 << PWMG_PWM0_HEND_IF_POS);
		
		break;
		
		case((uint32_t)PWM1):
		
			PWMG->IF = (0x01 << PWMG_PWM1_HEND_IF_POS);
	
		break;
		
		case((uint32_t)PWM2):
		
			PWMG->IF = (0x01 << PWMG_PWM2_HEND_IF_POS);
	
		break;
		
		case((uint32_t)PWM3):
		
			PWMG->IF = (0x01 << PWMG_PWM3_HEND_IF_POS);
	
		break;
		
		case((uint32_t)PWM4):
		
			PWMG->IF = (0x01 << PWMG_PWM4_HEND_IF_POS);
	
		break;	
	}
}

/****************************************************************************************************************************************** 
* :	PWM_IntHendStat()
* ˵: ߵƽжǷ
*     : PWM_TypeDef * PWMx			ָҪõPWMЧֵPWM0PWM1PWM2PWM3PWM4
*     : 1 ߵƽжϷ    0 ߵƽжδ
* ע: 
******************************************************************************************************************************************/
uint8_t PWM_IntHendStat(PWM_TypeDef * PWMx)
{
	uint8_t State = 0;
	
	switch((uint32_t)PWMx)
	{
		case((uint32_t)PWM0):
		
			if(PWMG->IF & PWMG_PWM0_HEND_IF_MSK)
			{
				State = 1;
			}
		
		break;
		
		case((uint32_t)PWM1):
		
			if(PWMG->IF & PWMG_PWM1_HEND_IF_MSK)
			{
				State = 1;
			}
			
		break;
		
		case((uint32_t)PWM2):
		
			if(PWMG->IF & PWMG_PWM2_HEND_IF_MSK)
			{
				State = 1;
			}
	
		break;
		
		case((uint32_t)PWM3):
		
			if(PWMG->IF & PWMG_PWM3_HEND_IF_MSK)
			{
				State = 1;
			}
			
		break;
		
		case((uint32_t)PWM4):
		
			if(PWMG->IF & PWMG_PWM4_HEND_IF_MSK)
			{
				State = 1;
			}
	
		break;	
	}
	
	return State;
}

/****************************************************************************************************************************************** 
* :	PWM_IntOvfEn()
* ˵: жʹ
*     : PWM_TypeDef * PWMx			ָҪõPWMЧֵPWM0PWM1PWM2PWM3PWM4
*     : 
* ע: 
******************************************************************************************************************************************/
void PWM_IntOvfEn(PWM_TypeDef * PWMx)
{
	switch((uint32_t)PWMx)
	{
		case((uint32_t)PWM0):
		
			PWMG->IE |= (0x01 << PWMG_PWM0_OVF_IE_POS);
		
		break;
		
		case((uint32_t)PWM1):
		
			PWMG->IE |= (0x01 << PWMG_PWM1_OVF_IE_POS);
	
		break;
		
		case((uint32_t)PWM2):
		
			PWMG->IE |= (0x01 << PWMG_PWM2_OVF_IE_POS);
	
		break;
		
		case((uint32_t)PWM3):
		
			PWMG->IE |= (0x01 << PWMG_PWM3_OVF_IE_POS);
	
		break;
		
		case((uint32_t)PWM4):
		
			PWMG->IE |= (0x01 << PWMG_PWM4_OVF_IE_POS);
	
		break;	
	}
}


/****************************************************************************************************************************************** 
* :	PWM_IntOvfDis()
* ˵: жϽ
*     : PWM_TypeDef * PWMx			ָҪõPWMЧֵPWM0PWM1PWM2PWM3PWM4
*     : 
* ע: 
******************************************************************************************************************************************/
void PWM_IntOvfDis(PWM_TypeDef * PWMx)
{
	switch((uint32_t)PWMx)
	{
		case((uint32_t)PWM0):
		
			PWMG->IE &= ~(0x01 << PWMG_PWM0_OVF_IE_POS);
		
		break;
		
		case((uint32_t)PWM1):
		
			PWMG->IE &= ~(0x01 << PWMG_PWM1_OVF_IE_POS);
	
		break;
		
		case((uint32_t)PWM2):
		
			PWMG->IE &= ~(0x01 << PWMG_PWM2_OVF_IE_POS);
	
		break;
		
		case((uint32_t)PWM3):
		
			PWMG->IE &= ~(0x01 << PWMG_PWM3_OVF_IE_POS);
	
		break;
		
		case((uint32_t)PWM4):
		
			PWMG->IE &= ~(0x01 << PWMG_PWM4_OVF_IE_POS);
	
		break;	
	}
}


/****************************************************************************************************************************************** 
* :	PWM_IntOvfClr()
* ˵: жϱ־
*     : PWM_TypeDef * PWMx			ָҪõPWMЧֵPWM0PWM1PWM2PWM3PWM4
*     : 
* ע: 
******************************************************************************************************************************************/
void PWM_IntOvfClr(PWM_TypeDef * PWMx)
{
	switch((uint32_t)PWMx)
	{
		case((uint32_t)PWM0):
		
			PWMG->IF = (0x01 << PWMG_PWM0_OVF_IF_POS);
		
		break;
		
		case((uint32_t)PWM1):
		
			PWMG->IF = (0x01 << PWMG_PWM1_OVF_IF_POS);
	
		break;
		
		case((uint32_t)PWM2):
		
			PWMG->IF = (0x01 << PWMG_PWM2_OVF_IF_POS);
	
		break;
		
		case((uint32_t)PWM3):
		
			PWMG->IF = (0x01 << PWMG_PWM3_OVF_IF_POS);
	
		break;
		
		case((uint32_t)PWM4):
		
			PWMG->IF = (0x01 << PWMG_PWM4_OVF_IF_POS);
	
		break;	
	}
}

/****************************************************************************************************************************************** 
* :	PWM_IntOvfStat()
* ˵: жǷ
*     : PWM_TypeDef * PWMx			ָҪõPWMЧֵPWM0PWM1PWM2PWM3PWM4
*     : 1 жϷ    0 жδ
* ע: 
******************************************************************************************************************************************/
uint8_t PWM_IntOvfStat(PWM_TypeDef * PWMx)
{
	uint8_t State = 0;
	
	switch((uint32_t)PWMx)
	{
		case((uint32_t)PWM0):
		
			if(PWMG->IF & PWMG_PWM0_OVF_IF_MSK)
			{
				State = 1;
			}
			
		break;
		
		case((uint32_t)PWM1):
		
			if(PWMG->IF & PWMG_PWM1_OVF_IF_MSK)
			{
				State = 1;
			}
		
		break;
		
		case((uint32_t)PWM2):
		
			if(PWMG->IF & PWMG_PWM2_OVF_IF_MSK)
			{
				State = 1;
			}
			
		break;
		
		case((uint32_t)PWM3):
		
			if(PWMG->IF & PWMG_PWM3_OVF_IF_MSK)
			{
				State = 1;
			}
			
		break;
		
		case((uint32_t)PWM4):
		
			if(PWMG->IF & PWMG_PWM4_OVF_IF_MSK)
			{
				State = 1;
			}
			
		break;	
	}
	
	return State;
}






