#ifndef __OMW_CONFIG_H__
#define __OMW_CONFIG_H__

#ifdef __cplusplus
extern "C"
{
#endif

#include <stddef.h>
#include <stdarg.h>
#include <string.h>

// ############################################################
#define OMW_INTR
#define OMW_TIMER

#ifdef OMW_TIMER
#define OMW_TIMER_PIN_PWM0_1 (OMW_GPIO_PIN0)
#define OMW_TIMER_PIN_PWM1_1 (OMW_GPIO_PIN1)
#define OMW_TIMER_PIN_PWM2_1 (OMW_GPIO_PIN2)
#define OMW_TIMER_PIN_PWM3_1 (OMW_GPIO_PIN3)
#define OMW_TIMER_PIN_PWM4_1 (OMW_GPIO_PIN4)
#define OMW_TIMER_PIN_PWM5_1 (OMW_GPIO_PIN5)
#define OMW_TIMER_PIN_PWM6_1 (OMW_GPIO_PIN6)
#define OMW_TIMER_PIN_PWM7_1 (OMW_GPIO_PIN7)
#define OMW_TIMER_PIN_PWM0_2 (OMW_GPIO_PIN8)
#define OMW_TIMER_PIN_PWM0_N (OMW_GPIO_PIN9)
#define OMW_TIMER_PIN_PWM1_2 (OMW_GPIO_PIN10)
#define OMW_TIMER_PIN_PWM1_N (OMW_GPIO_PIN11)
#define OMW_TIMER_PIN_PWM2_2 (OMW_GPIO_PIN12)
#define OMW_TIMER_PIN_PWM2_N (OMW_GPIO_PIN13)
#define OMW_TIMER_PIN_PWM3_2 (OMW_GPIO_PIN14)
#define OMW_TIMER_PIN_PWM3_N (OMW_GPIO_PIN15)
#define OMW_TIMER_PIN_PWM4_2 (OMW_GPIO_PIN16)
#define OMW_TIMER_PIN_PWM4_N (OMW_GPIO_PIN17)
#define OMW_TIMER_PIN_PWM5_2 (OMW_GPIO_PIN18)
#define OMW_TIMER_PIN_PWM5_N (OMW_GPIO_PIN19)
#define OMW_TIMER_PIN_PWM6_2 (OMW_GPIO_PIN20)
#define OMW_TIMER_PIN_PWM6_N (OMW_GPIO_PIN21)
#define OMW_TIMER_PIN_PWM7_2 (OMW_GPIO_PIN22)
#define OMW_TIMER_PIN_PWM7_N (OMW_GPIO_PIN23)
#define OMW_TIMER_FUN_CFG_PWM0 ((0x3 << 3) | 7)
#define OMW_TIMER_FUN_CFG_PWM1 ((0x3 << 3) | 7)
#define OMW_TIMER_FUN_CFG_PWM2 ((0x3 << 3) | 7)
#define OMW_TIMER_FUN_CFG_PWM3 ((0x3 << 3) | 7)
#define OMW_TIMER_FUN_CFG_PWM4 ((0x3 << 3) | 7)
#define OMW_TIMER_FUN_CFG_PWM5 ((0x3 << 3) | 7)
#define OMW_TIMER_FUN_CFG_PWM6 ((0x3 << 3) | 7)
#define OMW_TIMER_FUN_CFG_PWM7 ((0x3 << 3) | 7)
#endif
// ############################################################


#define OMW_CPU_E902
#define OMW_CHIP_T1001
//#define OMW_HAS_LOG_UART
#define OMW_BLE_CNTR_V0
#define OMW_BLE_HOST_OTHER
#define OMW_HCI_RAM
// #define OMW_HCI_H4
#define OMW_COMID_PATCH
// #define OMW_CMD_CTRL
#define OMW_DATA_BUF_SIZE 0xA00

//#define OMW_FLASE_BASE_ADDR  0x10000000
//#define OMW_FLASE_TOTAL_SIZE (256 * 1024)
//#define OMW_FLASH_TAIL_RS    (16 * 1024)
#define OMW_FLASH_HAS_PE
#define OMW_FLASH_SS_BITS 12
#define OMW_FLASH_SS (1 << OMW_FLASH_SS_BITS)
#ifdef OMW_FLASH_HAS_PE
#define OMW_FLASH_PS_BITS 8
#define OMW_FLASH_PS (1 << OMW_FLASH_PS_BITS)
#else
#define OMW_FLASH_PS OMW_FLASH_SS
#endif

#define OMW_EN_WDG
#ifdef OMW_EN_WDG
#define OMW_FEED_WDG_TIME 5 // second
#endif

#ifdef OMW_COMID_PATCH
#define OMW_BT_CTRL_COMPANY_ID (0x0B24)
#define OMW_BT_CTRL_SUBVERSION_NUMBER (0xABCD)
#else
#define OMW_BT_CTRL_COMPANY_ID (0x1234)
#define OMW_BT_CTRL_SUBVERSION_NUMBER (0x5678)
#endif

// #define OMW_BT_ADDR (uint8_t[6]){0x18, 0x15, 0xE8, 0x62, 0x73, 0x34}
#define OMW_BT_ADDR \
    (uint8_t[6]) { 0x15, 0x63, 0x92, 0xE8, 0x65, 0x18 }
#define CONFIG_BT_BUF_ACL_TX_SIZE 74
#define CONFIG_BT_BUF_ACL_TX_COUNT 2
#define CONFIG_BT_BUF_ACL_RX_SIZE 74
#define CONFIG_BT_BUF_ACL_RX_COUNT 2
#define CONFIG_BT_BUF_EVT_RX_SIZE 74
#define CONFIG_BT_BUF_EVT_RX_COUNT 2
#define CONFIG_BT_BUF_CMD_TX_SIZE 74
#define CONFIG_BT_BUF_CMD_TX_COUNT 2
#define CONFIG_BT_CTRL_RX_BUFFERS (2)
#define CONFIG_BT_CTRL_DATA_RX_BUFFERS (2)

#define CONFIG_BT_CTRL_TX_BUFFERS (2)
#define CONFIG_BT_CTRL_DATA_TX_BUFFERS (2)

#define CONFIG_BT_CONN 1
#define CONFIG_BT_MAX_CONN 2
#define CONFIG_BT_HCI_RESERVE 4

#define OMW_EN_DEEP_SLEEP

#ifdef OMW_EN_DEEP_SLEEP
#define CONFIG_OTP_PROGRAM
#define CONFIG_FLASH_PROGRAM

#ifdef CONFIG_FLASH_PROGRAM
// #define QSPI_VDD_FUNC_REG_VAL        0x18180000   //PIN 10, 11
// #define QSPI_VDD_OE_REG_VAL          0x00000C00
// #define QSPI_VDD_O_REG_VAL           0x00000C00
//
// #define QSPI_FLASH_FUNC_REG1_VAL     0x00001919   //PIN 12, 13
// #define QSPI_FLASH_FUNC_REG2_VAL     0x00001919   //PIN 16, 17
// #define QSPI_REMAP_REG_VAL           0x00015423
#define QSPI_FLASH_FUNC_REG1_VAL 0x00190000 // PIN 10
#define QSPI_FLASH_FUNC_REG2_VAL 0x19190019 // PIN 12,14,15
#endif

#define OMW_GPIO_WAKEUP_MASK 0              // 高电平触发
#define OMW_GPIO_nWAKEUP_MASK 0x0003C0      // 低电平触发
#define OMW_UNUSED_GPIO_MASK (0xC4003C)     // OMW_UNUSED_GPIO_MASK 定义为芯片未休眠的时候可以使用
#define OMW_WHEN_SLEEP_GPIO_MASK (0x33203F) // OMW_WHEN_SLEEP_GPIO_MASK 定义为芯片休眠的时候可以使用

#define OMW_SAVE_UART0_REGS
#define OMW_FLASH_VDDIO_PIN1 0xFF
#define OMW_FLASH_VDDIO_PIN2 0xFF
#endif

    ////////////////////DEBUG, LOG/////////////////////////
    ///////////////////////////////////////////////////////

#if defined(OMW_BLE_CNTR_V0) || defined(OMW_BLE_HOST_V0)
#define OMW_BLE_V0
#endif

#ifdef OMW_HAS_LOG_UART
#define OMW_LOG_UART OMW_UART0
#define OMW_LOG_UART_RX_PIN OMW_GPIO_PIN20
#define OMW_LOG_UART_TX_PIN OMW_GPIO_PIN21
#define OMW_LOG_UART_RX_FUNC OMW_GPIO20_UART0_RX
#define OMW_LOG_UART_TX_FUNC OMW_GPIO21_UART0_TX
#define OMW_LOG_UART_BAUDRATE 115200
#endif

#if defined(OMW_HCI_RAM) && defined(OMW_HCI_H4)
#error "HCI error: can not define H4 and RAM at same time!"
#endif

#if !defined(OMW_HCI_RAM) && !defined(OMW_HCI_H4)
#error "HCI error: must define one of H4 or RAM!"
#endif

#ifdef OMW_HCI_H4
#define OMW_HCI_H4_UART OMW_UART1
#define OMW_HCI_H4_UART_RX_PIN OMW_GPIO_PIN6
#define OMW_HCI_H4_UART_TX_PIN OMW_GPIO_PIN7
#define OMW_HCI_H4_UART_RX_FUNC OMW_GPIO6_UART1_RX
#define OMW_HCI_H4_UART_TX_FUNC OMW_GPIO7_UART1_TX
#define OMW_HCI_H4_UART_CTS_PIN OMW_GPIO_PIN8
#define OMW_HCI_H4_UART_RTS_PIN OMW_GPIO_PIN9
#define OMW_HCI_H4_UART_CTS_FUNC OMW_GPIO8_UART1_CTS
#define OMW_HCI_H4_UART_RTS_FUNC OMW_GPIO9_UART1_RTS
#define OMW_HCI_H4_UART_BAUDRATE 115200
#endif

#ifdef OMW_CMD_CTRL
#define OMW_CMD_CTRL_UART OMW_UART1
#define OMW_CMD_CTRL_UART_RX_PIN OMW_GPIO_PIN22
#define OMW_CMD_CTRL_UART_TX_PIN OMW_GPIO_PIN23
#define OMW_CMD_CTRL_UART_RX_FUNC OMW_GPIO22_UART1_RX
#define OMW_CMD_CTRL_UART_TX_FUNC OMW_GPIO23_UART1_TX
#define OMW_CMD_CTRL_UART_BAUDRATE 115200
#endif

#define OMW_BLE_ONLY_V0

#if (defined(OMW_BLE_CNTR_V0) && defined(OMW_BLE_CNTR_V1)) || (defined(OMW_BLE_CNTR_V0) && defined(OMW_BLE_CNTR_V2)) || \
    (defined(OMW_BLE_CNTR_V1) && defined(OMW_BLE_CNTR_V2))
#error "can not defined two controller at same time!"
#endif

#if (defined(OMW_BLE_HOST_V0) && defined(OMW_BLE_HOST_V1)) || (defined(OMW_BLE_HOST_V0) && defined(OMW_BLE_HOST_V2)) || \
    (defined(OMW_BLE_HOST_V1) && defined(OMW_BLE_HOST_V2))
#error "can not defined two host at same time!"
#endif

#ifdef OMW_CHIP_T1001
#include "t1001.h"
#endif

#ifdef OMW_HAS_SCH
#include "omw_rtos.h"
#endif

#ifdef __cplusplus
}
#endif

#endif
