#ifndef __T100X_2G4_DEF_H__
#define __T100X_2G4_DEF_H__
#include "t1001.h"

#define RF_RATE_1M      0
#define RF_RATE_2M      1
#define RF_RATE_S2      2
#define RF_RATE_S8      3
#define RF_RATE_500K    4
#define RF_RATE_250K    5
#define RF_RATE_125K    6

typedef struct
{
    uint16_t channel;                      // (bandwidth(Khz) / 100) << 11 | channel

    uint8_t phy_mode;

    uint8_t preamble_len;

    uint8_t access_code[8];
    uint8_t access_len;

    uint16_t rx_timeout;

    uint8_t white_en;
    uint8_t white_init;

    uint8_t fec_mode;

    uint8_t crc_en;
    uint8_t crc_len;

    uint32_t crc_init;
    uint32_t crc_poly;

    #ifdef OMW_2G4_EN_AUTO_LEN
    uint8_t auto_len_size;
    uint8_t auto_len_pre_size;
    uint8_t auto_header_sign;
    uint8_t auto_len_ext_size;
    uint8_t auto_len_ext;
    uint16_t auto_max_allow_rx_bits;
    #endif

    uint16_t fifo_offset;
    uint16_t fifo_len;

    #ifdef OMW_2G4_EN_AUTO_ACK
    uint8_t auto_ack_resend_en;
    uint16_t auto_rx_ack_timeout;
    uint16_t auto_resend_delay;
    uint16_t auto_tx_ack_delay;
    uint16_t auto_resend_limit;
    #endif

    // WOR/TWOR control, can work independently
    uint8_t wor_en; // wor activity window, uint ms
    uint8_t twor_en; // wor activity window, uint ms

    // WOR
    uint16_t wor_sl; // wor sleep interval, uint ms

    // TWOR
    uint16_t twor_ac; // twor activity window, uint ms
    uint16_t twor_sl; // twor sleep interval, uint ms

    #ifdef OMW_DEBUG_DESC_TIMING
    // IO Setting.
    // General io setting
    volatile uint8_t GIOS_WTR;// WTR (Wait until TX or RX finished)
    volatile uint8_t GIOS_VPOAK;// VPOAK (Valid Packet or Auto ACK OK Output)
    volatile uint8_t GIOS_TWOR;// TWOR (Timer Wake On GPIO)
    // Rx work io
    volatile uint8_t GIOS_RX;// RX (rx work)
    volatile uint8_t GIOS_SYNC;// SYNC/FSYNC (frame sync)
    volatile uint8_t GIOS_CRC;// CRC (crc error flag)

    // Tx work io
    volatile uint8_t GIOS_TX;// TX/TMEO (TX modulation enable)
    #endif

    #ifdef OMW_2G4_DMA_EN_IRQ
    // status info.
    volatile uint8_t status_WTR;// WTR (Wait until TX or RX finished)

    #ifndef OMW_2G4_VER_BEACON
    volatile uint8_t status_VPOAK;// VPOAK (Valid Packet or Auto ACK OK Output)
    #endif

    // reserve for future use.
    uint8_t res[10];
    #endif
} __PACKED omw_2g4_param_t;

extern omw_2g4_param_t rf_2g4_mgr;
extern uint8_t* rf_2g4_fifo;
extern uint8_t rf_2g4_thld[4];

#endif // __T100X_2G4_DEF_H__