#ifndef __SDMA_H
#define __SDMA_H
#include "t1001.h"
#include <stdio.h>
#include "string.h"
#include "t1001_gpio.h"

#define SDMA_TASK_SIZE     (uint8_t)0x06



#define SDMA_ACTION_LOAD   (uint8_t)0x01
#define SDMA_ACTION_ADD    (uint8_t)0x02
#define SDMA_ACTION_REMOVE (uint8_t)0x04

#define IS_SDMA_ACTION(SDMA_ACTION)  ((SDMA_ACTION == SDMA_ACTION_LOAD)  ||  (SDMA_ACTION == SDMA_ACTION_ADD)   ||  (SDMA_ACTION == SDMA_ACTION_REMOVE))


#define	SDMA0	 (uint32_t)	0x00000001
#define	SDMA1	 (uint32_t)	0x00000002
#define	SDMA2	 (uint32_t)	0x00000004
#define	SDMA3	 (uint32_t)	0x00000008
#define	SDMA4	 (uint32_t)	0x00000010
#define	SDMA5	 (uint32_t)	0x00000020
#define	SDMA6	 (uint32_t)	0x00000040
#define	SDMA7	 (uint32_t)	0x00000080
#define	SDMA8	 (uint32_t)	0x00000100
#define	SDMA9	 (uint32_t)	0x00000200
#define	SDMA10	 (uint32_t)	0x00000400
#define	SDMA11	 (uint32_t)	0x00000800
#define	SDMA12	 (uint32_t)	0x00001000
#define	SDMA13	 (uint32_t)	0x00002000
#define	SDMA14	 (uint32_t)	0x00004000
#define	SDMA15	 (uint32_t)	0x00008000
#define	SDMA16	 (uint32_t)	0x00010000
#define	SDMA17	 (uint32_t)	0x00020000
#define	SDMA18	 (uint32_t)	0x00040000
#define	SDMA19	 (uint32_t)	0x00080000
#define	SDMA20	 (uint32_t)	0x00100000
#define	SDMA21	 (uint32_t)	0x00200000
#define	SDMA22	 (uint32_t)	0x00400000
#define	SDMA23	 (uint32_t)	0x00800000
#define	SDMA24	 (uint32_t)	0x01000000
#define	SDMA25	 (uint32_t)	0x02000000
#define	SDMA26	 (uint32_t)	0x04000000
#define	SDMA27	 (uint32_t)	0x08000000
#define	SDMA28	 (uint32_t)	0x10000000
#define	SDMA29	 (uint32_t)	0x20000000
#define	SDMA30	 (uint32_t)	0x40000000
#define	SDMA31	 (uint32_t)	0x80000000
#define	SDMA_ALL (uint32_t)	0xffffffff

#define IS_SDMA_PERIPH(SDMA)(((SDMA) == SDMA0)  || ((SDMA) == SDMA1)  || ((SDMA) == SDMA2)  ||\
                           ((SDMA) == SDMA3)  || ((SDMA) == SDMA4)  || ((SDMA) == SDMA5)  ||\
													 ((SDMA) == SDMA6)  || ((SDMA) == SDMA7)  || ((SDMA) == SDMA8)  ||\
													 ((SDMA) == SDMA9)  || ((SDMA) == SDMA10) || ((SDMA) == SDMA11) ||\
													 ((SDMA) == SDMA12) || ((SDMA) == SDMA13) || ((SDMA) == SDMA14) ||\
													 ((SDMA) == SDMA15) || ((SDMA) == SDMA16) || ((SDMA) == SDMA17) ||\
													 ((SDMA) == SDMA18) || ((SDMA) == SDMA19) || ((SDMA) == SDMA20) ||\
													 ((SDMA) == SDMA21) || ((SDMA) == SDMA22) || ((SDMA) == SDMA23) ||\
													 ((SDMA) == SDMA24) || ((SDMA) == SDMA25) || ((SDMA) == SDMA26) ||\
													 ((SDMA) == SDMA27) || ((SDMA) == SDMA28) || ((SDMA) == SDMA29) ||\
													 ((SDMA) == SDMA30) || ((SDMA) == SDMA31) || ((SDMA) == SDMA_ALL) )

#define SDMA_TASK_INTR_ENABLE     (uint32_t)0x80000000
#define SDMA_TASK_INTR_DISABLE    (uint32_t)0x00000000
#define SDMA_TASK_INTR_CMD(INTR_CMD) ((SDMA_TASK_INTR_CMD == SDMA_TASK_INTR_ENABLE)  || (SDMA_TASK_INTR_CMD == SDMA_TASK_INTR_DISABLE))


#define SDMA_TASK_TRANSACTION_WORD    (uint32_t)0x40000000
#define SDMA_TASK_TRANSACTION_BYTE    (uint32_t)0x00000000
#define SDMA_TASK_TRANSACTION_MODE(TRANSACTION_MODE) ((TRANSACTION_MODE == SDMA_TASK_TRANSACTION_WORD)  || (TRANSACTION_MODE == SDMA_TASK_TRANSACTION_BYTE))


#define SDMA_TASK_MODE_NORMAL    (uint32_t)0x00000000
#define SDMA_TASK_MODE_COMMAND   (uint32_t)0x10000000
#define SDMA_TASK_MODE_FIFO      (uint32_t)0x20000000
#define SDMA_TASK_MODE(SDMA_TASK_MODE) ((SDMA_TASK_MODE == SDMA_TASK_MODE_NORMAL)  || (SDMA_TASK_MODE == SDMA_TASK_MODE_COMMAND)  || (SDMA_TASK_MODE == SDMA_TASK_MODE_FIFO))


#define SDMA_TASK_CMD_WAR_ENABLE     (uint32_t)0x04000000
#define SDMA_TASK_CMD_WAR_DISABLE    (uint32_t)0x00000000
#define SDMA_TASK_CMD_WAR_CMD(CMD_WAR_CMD) ((CMD_WAR_CMD == SDMA_TASK_CMD_WAR_ENABLE)  || (CMD_WAR_CMD == SDMA_TASK_CMD_WAR_DISABLE))

#define SDMA_TASK_CMD_PRE_ENABLE     (uint32_t)0x02000000
#define SDMA_TASK_CMD_PRE_DISABLE    (uint32_t)0x00000000
#define SDMA_TASK_CMD_PRE_CMD(CMD_PRE_CMD) ((CMD_PRE_CMD == SDMA_TASK_CMD_PRE_ENABLE)  || (CMD_PRE_CMD == SDMA_TASK_CMD_PRE_DISABLE))


#define SDMA_TASK_TRIGGER_IDX_VALUE(TRIGGER_IDX_VALUE)  (TRIGGER_IDX_VALUE<31)


#define SDMA_TASK_SRC_ADD_INCRE_ENABLE   (uint32_t)0x00080000
#define SDMA_TASK_SRC_ADD_INCRE_DISABLE  (uint32_t)0x00000000
#define SDMA_TASK_DST_ADD_INCRE_ENABLE   (uint32_t)0x00040000
#define SDMA_TASK_DST_ADD_INCRE_DISABLE  (uint32_t)0x00000000
#define SDMA_TASK_SRC_BEGIN_UDT_ENABLE   (uint32_t)0x00020000
#define SDMA_TASK_SRC_BEGIN_UDT_DISABLE  (uint32_t)0x00000000
#define SDMA_TASK_DST_BEGIN_UDT_ENABLE   (uint32_t)0x00010000
#define SDMA_TASK_DST_BEGIN_UDT_DISABLE  (uint32_t)0x00000000
#define SDMA_TASK_NUM_BYTES_VALUE (NUM_BYTES_VALUE)  (NUM_BYTES_VALUE<0X00010000)


#define SDMA_TASK_FIFO_MODE_SRC_SPACE_ENABLE (uint32_t)0x00000010
#define SDMA_TASK_FIFO_MODE_SRC_SPACE_DISABLE (uint32_t)0x00000000
#define SDMA_TASK_FIFO_MODE_DST_SPACE_ENABLE  (uint32_t)0x00000001
#define SDMA_TASK_FIFO_MODE_DST_SPACE_DISABLE  (uint32_t)0x00000000
typedef struct {
uint32_t   int_en;
uint32_t   dma_word_en;
uint32_t   task_format;
uint32_t   cmd_war;
uint32_t   cmd_pre_en;
uint32_t   trigger_index;
uint32_t   src_add_inc_en;
uint32_t   dst_add_inc_en;
uint32_t   src_begin_upd_en;	
uint32_t   dst_begin_upd_en;	
uint32_t   num_bytes;
uint32_t   src_addr;
uint32_t   dst_addr;
uint32_t   cmd_addr;
uint32_t   cmd_wdata;
uint32_t   cmd_mask;
uint32_t   fifo_size;
uint32_t   fifo_mode_src;
uint32_t   fifo_mode_dst;
}SDMA_TASK_InitTypeDef;


extern  int SDMA_TaskTable[32];
typedef struct {
    int	task0	[SDMA_TASK_SIZE];
    int	task1	[SDMA_TASK_SIZE];
	int	task2	[SDMA_TASK_SIZE];
	int	task3	[SDMA_TASK_SIZE];
	int	task4	[SDMA_TASK_SIZE];
	int	task5	[SDMA_TASK_SIZE];
	int	task6	[SDMA_TASK_SIZE];
	int	task7	[SDMA_TASK_SIZE];
	int	task8	[SDMA_TASK_SIZE];
	int	task9	[SDMA_TASK_SIZE];
	int	task10	[SDMA_TASK_SIZE];
	int	task11	[SDMA_TASK_SIZE];
	int	task12	[SDMA_TASK_SIZE];
	int	task13	[SDMA_TASK_SIZE];
	int	task14	[SDMA_TASK_SIZE];
	int	task15	[SDMA_TASK_SIZE];
	int	task16	[SDMA_TASK_SIZE];
	int	task17	[SDMA_TASK_SIZE];
	int	task18	[SDMA_TASK_SIZE];
	int	task19	[SDMA_TASK_SIZE];
	int	task20	[SDMA_TASK_SIZE];
	int	task21	[SDMA_TASK_SIZE];
	int	task22	[SDMA_TASK_SIZE];
	int	task23	[SDMA_TASK_SIZE];
	int	task24	[SDMA_TASK_SIZE];
	int	task25	[SDMA_TASK_SIZE];
	int	task26	[SDMA_TASK_SIZE];
	int	task27	[SDMA_TASK_SIZE];
	int	task28	[SDMA_TASK_SIZE];
	int	task29	[SDMA_TASK_SIZE];
	int	task30	[SDMA_TASK_SIZE];
	int	task31	[SDMA_TASK_SIZE];
}TASK_STRUCT;




void omw_sdma_init(void);
void omw_sdma_cmd(FunctionalState NewState);
void omw_sdma_action(uint8_t dma_action);	
void omw_sdma_task_init(SDMA_TASK_InitTypeDef *sdma_task_ptr ,uint32_t * Sdma_taskX);
void omw_sdma_task_struct_init(SDMA_TASK_InitTypeDef *sdma_task_ptr);
void omw_sdma_value_set(uint32_t SDMAx,FlagStatus NewStatus);
uint32_t omw_sdma_status(void);
uint8_t  omw_sdma_status_bit(uint32_t SDMAx);
uint32_t omw_sdma_get_it_status(void);
uint8_t omw_sdma_get_it_status_bit(uint32_t SDMAx);
void omw_sdma_intr_clr(uint32_t SDMAx);



#endif