/*****************************************************************************************
 * @Author: Cedric Kong <dachao.kong@omnilinktek.com>
 * @Date: 2024-03-01 17:28:57
 * @LastEditors: Cedric Kong
 * @LastEditTime: 2024-03-05 15:13:53
 * @FilePath: omw_iic.h
 * @Description: 请填写文件说明
 * @Copyright: © 2021-2024 OmniLinkTek, All Rights Reserved.
 ****************************************************************************************/
#ifndef __OMW_IIC_H__
#define __OMW_IIC_H__

#include "t1001.h"
#include "stdint.h"
#include "omw_config.h"
#include "omw_gpio.h"

typedef struct
{
    uint8_t iic_mode; 	/**< i2c work mode: master or slave mode */
	
    uint8_t iic_speed_mode;   /**< i2c_speed_mode: standrd,fast or fastplus speed*/

	uint8_t iic_target_addr_mode;
	
	uint8_t iic_slave_addr_mode;
	
	uint8_t iic_tx_threshold;
	
	uint8_t iic_rx_threshold;
	
	uint16_t iic_clk_frequency;  
	
	uint16_t iic_target_addr;  //
	
	uint16_t iic_slave_addr; 

}iic_initypedef;

#define OMW_IIC_MODE_SLAVE  (uint8_t)0x00
#define OMW_IIC_MODE_MASTER (uint8_t)0x41

#define OMW_IIC_RESTART_EN  (uint8_t)0x20
#define OMW_IIC_RESTART_DIS (uint8_t)0x00

#define OMW_IIC_SPEED_MODE_SS (uint8_t)0x02
#define OMW_IIC_SPEED_MODE_FS (uint8_t)0x04


#define OMW_IIC_TARGET_ADDR_MODE_7BIT (uint8_t)0x00
#define OMW_IIC_TARGET_ADDR_MODE_10BIT (uint8_t)0x10


#define OMW_IIC_SLAVE_ADDR_MODE_7BIT (uint8_t)0x00
#define OMW_IIC_SLAVE_ADDR_MODE_10BIT (uint8_t)0x08



#define OMW_IIC_CLK_FREQUENCY_100K (uint16_t)108
#define OMW_IIC_CLK_FREQUENCY_400K (uint16_t)21
//#define OMW_IIC_CLK_FREQUENCY_1000K (uint16_t)


#define OMW_IIC_INTR_START_DET (uint16_t)0x400 
#define OMW_IIC_INTR_STOP_DET  (uint16_t)0x200
#define OMW_IIC_INTR_ACTIVITY  (uint16_t)0x100
#define OMW_IIC_INTR_RX_DONE   (uint16_t)0x080
#define OMW_IIC_INTR_TX_ABRT   (uint16_t)0x040
#define OMW_IIC_INTR_RD_REQ    (uint16_t)0x020
#define OMW_IIC_INTR_TX_EMPTY  (uint16_t)0x010
#define OMW_IIC_INTR_TX_OVER   (uint16_t)0x008
#define OMW_IIC_INTR_RX_FULL   (uint16_t)0x004
#define OMW_IIC_INTR_RX_OVER   (uint16_t)0x002
#define OMW_IIC_INTR_RX_UNDER  (uint16_t)0x001
#define OMW_IIC_INTR_ALL       (uint16_t)0x7FFF

#define OMW_IIC_CMD_READ       (uint32_t)(1<<8)


void iic_init (iic_initypedef* IIC_Initstruct);
void iic_structinit(iic_initypedef* IIC_Initstruct);
void iic_send_byte(uint8_t data);
uint32_t iic_recv(uint8_t * buf, uint32_t len);
uint8_t iic_receive_byte(void);
void iic_cmd(FunctionalState NewState);
void iic_intr_cmd (uint16_t iic_intr,FunctionalState NewState);
ITStatus iic_get_itstatus(uint16_t iic_intr);
void iic_it_clearflag(void);
//void iic_master_send_data(uint8_t *buf,uint16_t len);
//void iic_master_receive_data(uint8_t *buf,uint16_t len);
//void iic_slave_send_data(uint8_t *buf,uint16_t len);
//void iic_slave_receive_data(uint8_t *buf,uint16_t len);
#endif

