#ifndef __SIMPLE_FIFO_H__
#define __SIMPLE_FIFO_H__

#include <stdint.h>
#include "stddef.h"
/**
 * @brief   Define a Memory FIFO thread safe, and can full use pool.
 * @details API 1 and 2.
 *   read_index and write_index is normal process.
 *   unhandle_index for spec use.
 *   Thread-A will update read_index, for get buffer from FIFO.
 *   Thread-B will update write_index, for put buffer to FIFO
 *               update unhandle_index, for use the buffer Thread-A had processed.
 */
typedef struct {
    uint8_t n;         /* Number of buffers */
    uint8_t r;               /* Read. Read index */
    uint8_t w;               /* Write. Write index */
    uint32_t* m;
} simple_fifo_t;


void simple_fifo_init(simple_fifo_t* sfifo, uint8_t n, uint32_t* m);
uint8_t simple_fifo_is_empty(simple_fifo_t* sfifo);
uint8_t simple_fifo_is_full(simple_fifo_t* sfifo);
uint8_t simple_fifo_size(simple_fifo_t* sfifo);
uint8_t simple_fifo_enqueue(simple_fifo_t* sfifo, uint32_t val);
uint32_t simple_fifo_dequeue(simple_fifo_t* sfifo);
uint32_t simple_fifo_dequeue_peek(simple_fifo_t* sfifo);
uint8_t simple_fifo_avail_count_get(simple_fifo_t* sfifo);


#endif