#ifndef __PERIPH_IIC_H__
#define __PERIPH_IIC_H__

#include "t1001.h"

#define READ_CPU_CLOCK    REG_RD_BITS(0x40000024,9,4)
#define READ_CPU_CLOCK_48M       (uint32_t)0x23


#define IIC_CLR_INTR_BASE 0x41005044

#define IIC_MODE_SLAVE  (uint8_t)0x00
#define IIC_MODE_MASTER (uint8_t)0x41

#define IIC_RESTART_EN  (uint8_t)0x20
#define IIC_RESTART_DIS (uint8_t)0x00

#define IIC_SPEED_MODE_SS (uint8_t)0x02
#define IIC_SPEED_MODE_FS (uint8_t)0x04
#define IIC_SPEED_MODE_FS_PLUS (uint8_t)0x06


#define IIC_TARGET_ADDR_MODE_7BIT (uint8_t)0x00
#define IIC_TARGET_ADDR_MODE_10BIT (uint8_t)0x10


#define IIC_SLAVE_ADDR_MODE_7BIT (uint8_t)0x00
#define IIC_SLAVE_ADDR_MODE_10BIT (uint8_t)0x08



#define IIC_CLK_FREQUENCY_100K (uint16_t)108
#define IIC_CLK_FREQUENCY_400K (uint16_t)21
#define IIC_CLK_FREQUENCY_1000K (uint16_t)16


#define IIC_FLAG_ACTIVITY            (uint16_t)0x01
#define IIC_FLAG_TX_FIFO_NOT_FULL    (uint16_t)0x02
#define IIC_FLAG_TX_FIFO_EMPTY       (uint16_t)0x04
#define IIC_FLAG_RX_FIFO_NOT_EMPTY   (uint16_t)0x08
#define IIC_FLAG_RX_FIFO_FULL	     (uint16_t)0x10
#define IIC_FLAG_MASTER_ACTIVITY 	 (uint16_t)0x20
#define IIC_FLAG_SLAVE_ACTIVITY  	 (uint16_t)0x40


#define IIC_IT_START_DET (uint16_t)0x400 
#define IIC_IT_STOP_DET  (uint16_t)0x200
#define IIC_IT_ACTIVITY  (uint16_t)0x100
#define IIC_IT_RX_DONE   (uint16_t)0x080
#define IIC_IT_TX_ABRT   (uint16_t)0x040
#define IIC_IT_RD_REQ    (uint16_t)0x020
#define IIC_IT_TX_EMPTY  (uint16_t)0x010
#define IIC_IT_TX_OVER   (uint16_t)0x008
#define IIC_IT_RX_FULL   (uint16_t)0x004
#define IIC_IT_RX_OVER   (uint16_t)0x002
#define IIC_IT_RX_UNDER  (uint16_t)0x001
#define IIC_IT_ALL       (uint16_t)0x7FF

#define IIC_CMD_READ       (uint32_t)(1<<8)

typedef struct
{
    uint8_t iic_mode; 	// i2c工作模式： master或slave

	uint8_t iic_speed_mode;  //i2c速度模式：standard(100K)、fast(400K)、fast_plus(1000K);主机模式下使用

	uint8_t iic_target_addr_mode;  // i2c主机寻址模式： 7bit寻址或10bit寻址, 主机模式下使用

	/* The default values cannot be any of the reserved address locations: that is, 0x00 to 0x07, or 0x78 to 0x7f */
	uint8_t iic_slave_addr_mode;  // i2c从机地址模式： 7bit地址或10bit地址, 从机模式下使用
	
	uint8_t iic_tx_threshold;  //  i2c发送fifo水线，取值范围：0~7；触发条件：fifo中数据个数小于等于iic_tx_threshold+1触发TX_EMPYT中断

	uint8_t iic_rx_threshold;  //  i2c接收fifo水线，取值范围：0~7；触发条件：fifo中数据个数大于等于iic_tx_threshold+1的值触发TX_EMPYT中断
	
	uint16_t iic_target_addr;  // i2c主机目标地址；主机模式下使用
	
	uint16_t iic_slave_addr;  // i2c从机自身地址；从机模式下使用

}IIC_InitTypeDef;

void IIC_DeInit(void);
void IIC_StructInit(IIC_InitTypeDef* IIC_InitStruct);
void IIC_Init(IIC_InitTypeDef* IIC_InitStruct);
void IIC_Cmd(FunctionalState NewState);
void IIC_SendByte(uint8_t data);
uint8_t IIC_MasterReceiveByte(void);
uint8_t IIC_SlaveReceiveByte(void);
uint32_t IIC_MasterRecv(uint8_t * buf, uint32_t len);
uint32_t IIC_SlaveRecv(uint8_t * buf, uint32_t len);
uint8_t IIC_TXFLR(void);
uint8_t IIC_RXFLR(void);
FlagStatus IIC_GetUsrStatus(uint16_t Flag);
void IIC_ITConfig(uint16_t IIC_IT, FunctionalState NewState);
ITStatus IIC_GetITStatus(uint16_t IIC_IT);
void IIC_ClrITStatus(uint16_t IIC_IT);


#endif