#ifndef __PERIPH_GPIO_H__
#define __PERIPH_GPIO_H__

#include "omw_config.h"

#ifdef OMW_CHIP_T1100
#include <t1001_gpio.h>
#else
#include <t1001_gpio.h>
#endif

// library
extern void delay_us(uint32_t us);
extern void delay_ms(uint32_t ms);
#ifndef DELAY_US
#define DELAY_US(d) delay_us(d)
#endif
#ifndef DELAY_MS
#define DELAY_MS(d) delay_ms(d)
#endif

// GPIO pin configuration
#define GPIO_PIN_0                  (1 << 0)
#define GPIO_PIN_1                  (1 << 1)
#define GPIO_PIN_2                  (1 << 2)
#define GPIO_PIN_3                  (1 << 3)
#define GPIO_PIN_4                  (1 << 4)
#define GPIO_PIN_5                  (1 << 5)
#define GPIO_PIN_6                  (1 << 6)
#define GPIO_PIN_7                  (1 << 7)
#define GPIO_PIN_8                  (1 << 8)
#define GPIO_PIN_9                  (1 << 9)
#define GPIO_PIN_10                 (1 << 10)
#define GPIO_PIN_11                 (1 << 11)
#define GPIO_PIN_12                 (1 << 12)
#define GPIO_PIN_13                 (1 << 13)
#define GPIO_PIN_14                 (1 << 14)
#define GPIO_PIN_15                 (1 << 15)
#define GPIO_PIN_16                 (1 << 16)
#define GPIO_PIN_17                 (1 << 17)
#define GPIO_PIN_18                 (1 << 18)
#define GPIO_PIN_19                 (1 << 19)
#define GPIO_PIN_20                 (1 << 20)
#define GPIO_PIN_21                 (1 << 21)
#define GPIO_PIN_22                 (1 << 22)
#define GPIO_PIN_23                 (1 << 23)
#define GPIO_PIN_ALL                0xFFFFFF
#define GPIO_PIN_NONE               0x000000

// GPIO mode configuration
#define GPIO_MODE_IN_FLOATING       0x00
#define GPIO_MODE_IPU               0x01
#define GPIO_MODE_IPD               0x02
#define GPIO_MODE_AIN               0x03
#define GPIO_MODE_OUT_OD            0x04
#define GPIO_MODE_HIZ               0x05
#define GPIO_MODE_OUT_PP            0x10

// GPIO drive strength configuration
#define GPIO_DRIVE_STRENGTH_0       0x00 // 3mA @3.3V VDDIO
#define GPIO_DRIVE_STRENGTH_1       0x01 // 9mA @3.3V VDDIO
#define GPIO_DRIVE_STRENGTH_2       0x02 // 15mA @3.3V VDDIO
#define GPIO_DRIVE_STRENGTH_3       0x03 // 21mA @3.3V VDDIO

#define GPIO_ATF_NONE               0x00

#define GPIO_ITMODE_NONE            0x00
#define GPIO_ITMODE_HIGH            0x01
#define GPIO_ITMODE_LOW             0x02
#define GPIO_ITMODE_RISE            0x04
#define GPIO_ITMODE_FALL            0x08
#define GPIO_ITMODE_ALL             0x0F

typedef struct
{
  uint32_t GPIO_Pin;
  uint8_t GPIO_Mode;
  uint8_t GPIO_AltFunc; // 注意：GPIO 使用AltFunc时，GPIO_Mode不得设置为OMW_GPIO_MODE_OUT_PP
  uint8_t GPIO_DriveStrength;
} GPIO_InitTypeDef;

void GPIO_DeInit(uint32_t GPIO_Pin);
void GPIO_Init(GPIO_InitTypeDef *GPIO_InitStruct);
void GPIO_StructInit(GPIO_InitTypeDef *GPIO_InitStruct);
uint8_t GPIO_ReadInputDataBit(uint32_t GPIO_Pin);
uint32_t GPIO_ReadInputData(void);
uint8_t GPIO_ReadOutputDataBit(uint32_t GPIO_Pin);
uint32_t GPIO_ReadOutputData(void);
void GPIO_OutputCMD(uint32_t GPIO_Pin, FunctionalState state);
void GPIO_SetBits(uint32_t GPIO_Pin);
void GPIO_ResetBits(uint32_t GPIO_Pin);
void GPIO_WriteBit(uint32_t GPIO_Pin, lineStatus BitVal);
void GPIO_Write(uint32_t RegVal);
void GPIO_ITConfig(uint32_t GPIO_Pin, uint8_t GPIO_ITMode, FunctionalState NewState);
void GPIO_ITCMD(uint32_t GPIO_Pin, FunctionalState NewState);
uint32_t GPIO_GetITStatus(uint32_t GPIO_Pin);
void GPIO_ClearITPendingBit(uint32_t GPIO_Pin);
void GPIO_FiltWindowConfig(uint8_t FiltWinSize);
void GPIO_FiltConfig(uint32_t GPIO_Pin, FunctionalState NewState);
uint16_t GPIO_GetIORes(uint8_t DriveStrength, uint16_t Vbat, uint8_t isToGND);

#endif
