#ifndef __PERIPH_GPADC_H__
#define __PERIPH_GPADC_H__
#include "t1001.h"
#include "system.h"
#include "omw_config.h"
#include "omw_gpio.h"
#include "t1002_otp_cfg.h"

// library
extern void delay_us(uint32_t us);
extern void delay_ms(uint32_t ms);
#ifndef DELAY_US
#define DELAY_US(d) delay_us(d)
#endif
#ifndef DELAY_MS
#define DELAY_MS(d) delay_ms(d)
#endif

// Calibration Method Selection
//#define GPADC_StartCalibration() GPADC_StartCalibrationRaw()
#define GPADC_StartCalibration() GPADC_StartCalibrationEx()

// 低压校准表
extern const int16_t gpadc_div0_offset[][16];
extern const int16_t gpadc_div2_offset[][16];
extern const int16_t gpadc_div2_offset[][16];
extern const int16_t gpadc_div3_offset[][16];

extern const int gpadc_voltoffset[][16];
extern const int16_t gpadc_batvoltoffset[];

// global
extern uint16_t g_gpadc_vbat;

#define REG_GPADC_LDO_VC            *(volatile uint32_t *)(0x40080104)
#define REG_GPADC_LDO_EN            *(volatile uint8_t *)(0x42002004)
#define REG_TEMPERATURE_SENSOR_EN   *(volatile uint8_t *)(0x420020E8)

#define GPADC_SAMP_MAX              1024
#define GPADC_DIV1_VOLT_MAX         9000
#define GPADC_CALI_ZOOM             1024
#define GPADC_CALI_ZOOM_SHIFT       10
#define GPADC_FIX_COEF              256
#define GPADC_SAMP_FILT_NUM         4     // 1/2/3/4
#define GPADC_SAMP_AVG_EXT          4     // max 4

#ifdef GPADC_HIGH_PRECISION_CALI
   #define GPADC_CALI_DIV1_DELTA_HI    0
   #define GPADC_CALI_DIV1_DELTA_LO    0
   #define GPADC_CALI_DIV2_DELTA_HI    0   
   #define GPADC_CALI_DIV2_DELTA_LO    0 
   #define GPADC_CALI_DIV3_DELTA_HI    0   
   #define GPADC_CALI_DIV3_DELTA_LO    0  
   #define GPADC_CALI_DIV4_DELTA_HI    0     
   #define GPADC_CALI_DIV4_DELTA_LO    0     
#else
   #define GPADC_CALI_DIV1_DELTA_HI    1422
   #define GPADC_CALI_DIV1_DELTA_LO    1296
   #define GPADC_CALI_DIV2_DELTA_HI    1074   
   #define GPADC_CALI_DIV2_DELTA_LO    802 
   #define GPADC_CALI_DIV3_DELTA_HI    882     //2400mV
   #define GPADC_CALI_DIV3_DELTA_LO    745     //1800mV
   #define GPADC_CALI_DIV4_DELTA_HI    722     //3200mV
   #define GPADC_CALI_DIV4_DELTA_LO    624     //2600mV
#endif
#define GPADC_CALI_VBAT_DELTA_HI    859
#define GPADC_CALI_VBAT_DELTA_LO    768

/*
#define GPADC_OTP_INTERNAL_RESISTANCE   REG_RD(0x1f803f6c)
#define GPADC_OTP_CALI_DIV1_HIGH        REG_RD(0x1f803f3c)
#define GPADC_OTP_CALI_DIV1_LOW         REG_RD(0x1f803f40)
#define GPADC_OTP_CALI_DIV2_HIGH        REG_RD(0x1f803f44)
#define GPADC_OTP_CALI_DIV2_LOW         REG_RD(0x1f803f48)
#define GPADC_OTP_CALI_DIV3_HIGH        REG_RD(0x1f803f4c)
#define GPADC_OTP_CALI_DIV3_LOW         REG_RD(0x1f803f50)
#define GPADC_OTP_CALI_DIV4_HIGH        REG_RD(0x1f803f54)
#define GPADC_OTP_CALI_DIV4_LOW         REG_RD(0x1f803f58)
#define GPADC_OTP_CALI_VBAT_HIGH        REG_RD(0x1f803f70)
#define GPADC_OTP_CALI_VBAT_LOW         REG_RD(0x1f803f74)
*/

#define GPADC_OTP_INTERNAL_RESISTANCE   (g_otp_cfg.gpadc_res.value)
#define GPADC_OTP_CALI_DIV1_HIGH        (g_otp_cfg.gpadc_high_div1.raw)
#define GPADC_OTP_CALI_DIV1_LOW         (g_otp_cfg.gpadc_low_div1.raw)
#define GPADC_OTP_CALI_DIV2_HIGH        (g_otp_cfg.gpadc_high_div2.raw)
#define GPADC_OTP_CALI_DIV2_LOW         (g_otp_cfg.gpadc_low_div2.raw)
#define GPADC_OTP_CALI_DIV3_HIGH        (g_otp_cfg.gpadc_high_div3.raw)
#define GPADC_OTP_CALI_DIV3_LOW         (g_otp_cfg.gpadc_low_div3.raw)
#define GPADC_OTP_CALI_DIV4_HIGH        (g_otp_cfg.gpadc_high_div4.raw)
#define GPADC_OTP_CALI_DIV4_LOW         (g_otp_cfg.gpadc_low_div4.raw)
#define GPADC_OTP_CALI_VBAT_HIGH        (g_otp_cfg.gpadc_vbat_high.raw)
#define GPADC_OTP_CALI_VBAT_LOW         (g_otp_cfg.gpadc_vbat_low.raw)

// voltage *10
#define GPADC_DIV1_VALID_MIN            0
#define GPADC_DIV1_VALID_MAX            7000
#define GPADC_DIV2_VALID_MIN            5500
#define GPADC_DIV2_VALID_MAX            16500
#define GPADC_DIV3_VALID_MIN            15000
#define GPADC_DIV3_VALID_MAX            25500
#define GPADC_DIV4_VALID_MIN            24500
#define GPADC_DIV4_VALID_MAX            40000

// voltage *1
#define GPADC_DIV1_VOLT_VALID_MIN       (GPADC_DIV1_VALID_MIN/10)
#define GPADC_DIV1_VOLT_VALID_MAX       (GPADC_DIV1_VALID_MAX/10)
#define GPADC_DIV2_VOLT_VALID_MIN       (GPADC_DIV2_VALID_MIN/10)
#define GPADC_DIV2_VOLT_VALID_MAX       (GPADC_DIV2_VALID_MAX/10)
#define GPADC_DIV3_VOLT_VALID_MIN       (GPADC_DIV3_VALID_MIN/10)
#define GPADC_DIV3_VOLT_VALID_MAX       (GPADC_DIV3_VALID_MAX/10)
#define GPADC_DIV4_VOLT_VALID_MIN       (GPADC_DIV4_VALID_MIN/10)
#define GPADC_DIV4_VOLT_VALID_MAX       (GPADC_DIV4_VALID_MAX/10)

#define GPADC_DIV1_SAMP_VALID_MIN       (1024*GPADC_DIV1_VOLT_VALID_MIN/1/900)
#define GPADC_DIV1_SAMP_VALID_MAX       (1024*GPADC_DIV1_VOLT_VALID_MAX/1/900)
#define GPADC_DIV2_SAMP_VALID_MIN       (1024*GPADC_DIV2_VOLT_VALID_MIN/2/900)
#define GPADC_DIV2_SAMP_VALID_MAX       (1024*GPADC_DIV2_VOLT_VALID_MAX/2/900)
#define GPADC_DIV3_SAMP_VALID_MIN       (1024*GPADC_DIV3_VOLT_VALID_MIN/3/900)
#define GPADC_DIV3_SAMP_VALID_MAX       (1024*GPADC_DIV3_VOLT_VALID_MAX/3/900)
#define GPADC_DIV4_SAMP_VALID_MIN       (1024*GPADC_DIV4_VOLT_VALID_MIN/4/900)
#define GPADC_DIV4_SAMP_VALID_MAX       (1024*GPADC_DIV4_VOLT_VALID_MAX/4/900)

#define GPADC_CLK_SRC_RC24M         0
#define GPADC_CLK_SRC_XT24M         1

#define GPADC_AVG_NUM_1             0
#define GPADC_AVG_NUM_2             1
#define GPADC_AVG_NUM_4             2
#define GPADC_AVG_NUM_8             3
#define GPADC_AVG_NUM_16            4
#define GPADC_AVG_NUM_32            5
#define GPADC_AVG_NUM_64            6
#define GPADC_AVG_NUM_128           7
#define GPADC_AVG_NUM_256           8

#define GPADC_INPUT_DIV1            0
#define GPADC_INPUT_DIV2            1
#define GPADC_INPUT_DIV3            2
#define GPADC_INPUT_DIV4            3

#define GPADC_CHANNEL_N_GPIO2       0
#define GPADC_CHANNEL_N_GPIO6       1
#define GPADC_CHANNEL_N_GPIO7       2
#define GPADC_CHANNEL_N_GPIO10      3
#define GPADC_CHANNEL_N_GPIO15      4
#define GPADC_CHANNEL_N_GPIO17      5
#define GPADC_CHANNEL_N_GPIO19      6
#define GPADC_CHANNEL_N_GPIO21      7
#define GPADC_CHANNEL_N_REF0V9      8

#define GPADC_CHANNEL_P_GPIO2       0
#define GPADC_CHANNEL_P_GPIO6       1
#define GPADC_CHANNEL_P_GPIO7       2
#define GPADC_CHANNEL_P_GPIO10      3
#define GPADC_CHANNEL_P_GPIO15      4
#define GPADC_CHANNEL_P_GPIO17      5
#define GPADC_CHANNEL_P_GPIO19      6
#define GPADC_CHANNEL_P_GPIO21      7
#define GPADC_CHANNEL_P_TEMP        8
#define GPADC_CHANNEL_P_BAT         9
#define GPADC_CHANNEL_P_CIN         10
#define GPADC_CHANNEL_P_CSUP        11

#define GPADC_CHANNEL_GPIO2         0
#define GPADC_CHANNEL_GPIO6         1
#define GPADC_CHANNEL_GPIO7         2
#define GPADC_CHANNEL_GPIO10        3
#define GPADC_CHANNEL_GPIO15        4
#define GPADC_CHANNEL_GPIO17        5
#define GPADC_CHANNEL_GPIO19        6
#define GPADC_CHANNEL_GPIO21        7
#define GPADC_CHANNEL_TEMP          8
#define GPADC_CHANNEL_BAT           9
#define GPADC_CHANNEL_CIN           10
#define GPADC_CHANNEL_CSUP          11

#define GPADC_CHANNEL_0             0
#define GPADC_CHANNEL_1             1
#define GPADC_CHANNEL_2             2
#define GPADC_CHANNEL_3             3
#define GPADC_CHANNEL_4             4
#define GPADC_CHANNEL_5             5
#define GPADC_CHANNEL_6             6
#define GPADC_CHANNEL_7             7
#define GPADC_CHANNEL_8             8
#define GPADC_CHANNEL_9             9
#define GPADC_CHANNEL_10            10
#define GPADC_CHANNEL_11            11

#define GPADC_TRIG_TIMER_0          0
#define GPADC_TRIG_TIMER_1          1
#define GPADC_TRIG_TIMER_2          2
#define GPADC_TRIG_TIMER_3          3
#define GPADC_TRIG_TIMER_4          4
#define GPADC_TRIG_TIMER_5          5
#define GPADC_TRIG_TIMER_6          6
#define GPADC_TRIG_TIMER_7          7

#define GPADC_FLAG_SAMP             0x02
#define GPADC_FLAG_DMA              0x01
#define GPADC_ITMODE_SAMP           0x02
#define GPADC_ITMODE_DMA            0x01



typedef struct 
{
   uint8_t GPADC_InputDivide;
   FunctionalState GPADC_DiffEN;
   uint8_t GPADC_NegativeInputChannel;
   uint8_t GPADC_PositiveInputChannel;  //配置为GPADC_CHANNEL_P_BAT通道时，分压系数必须使用GPADC_INPUT_DIV4
   uint8_t GPADC_AverageWindow;
   FunctionalState GPADC_TimerTrigEN;
   uint8_t GPADC_TimerSelect;
   FunctionalState GPADC_ContinueMode;
   uint8_t GPADC_ClkDivide;
   uint8_t GPADC_ClkSelect;
   FunctionalState GPADC_ClkAutoGate;
} GPADC_InitTypeDef;




typedef enum
{
   GPADC_DMASTARTADDR_0X2000_2000 = 0,
   GPADC_DMASTARTADDR_0X2000_2800 = 1,
   GPADC_DMASTARTADDR_0X2000_3000 = 2,
   GPADC_DMASTARTADDR_0X2000_3800 = 3, 
} GPADC_DMASTARTADDR;

typedef enum
{  
   GPADC_DMAENDADDR_0X2000_27FF = 0,
   GPADC_DMAENDADDR_0X2000_2FFF = 1,
   GPADC_DMAENDADDR_0X2000_37FF = 2,
   GPADC_DMAENDADDR_0X2000_3FFF = 3, 
} GPADC_DMAENDADDR;


void GPADC_Init(GPADC_InitTypeDef * GPADC_InitStruct);
void GPADC_StructInit(GPADC_InitTypeDef * GPADC_InitStruct);
void GPADC_DeInit(void);
void GPADC_Cmd(FunctionalState NewState);
void ADC_SoftwareStartConvCmd(FunctionalState NewState);
uint16_t GPADC_GetConversionValue(void);
uint16_t GPADC_GetConversionVoltage(void);
uint16_t GPADC_SampleVoltagePoll(void);
uint32_t GPADC_GetSample(void);
uint32_t GPADC_GetSampleAvgexp(int exp);
uint16_t GPADC_SampleToVoltage(uint32_t d);
void GPADC_ChangeChannel(uint8_t channel);
void GPADC_TempSensorCmd(FunctionalState NewState); 
FlagStatus GPADC_GetFlagStatus(uint8_t ADC_FLAG);
void GPADC_WaitWorkDone(void);
void GPADC_ClearFlag(uint8_t ADC_FLAG);
void GPADC_ITConfig(uint8_t ADC_ITMODE, FunctionalState NewState);
ITStatus GPADC_GetITStatus(uint8_t ADC_ITMODE);
void GPADC_ClearITPendingBit(uint8_t ADC_ITMODE);
void GPADC_StartCalibrationRaw(void); //校准必须要做初始化前进行
void GPADC_StartCalibrationEx(void); //校准必须要做初始化前进行
void GPADC_LDOInit(void); //ADC模块单独使用时需要将LDO供电使能，与2.4G/蓝牙模块共用时无需使能
uint32_t GPADC_GetRin(void); //ADC档位下并联电阻阻值
void GPADC_BATUpdate(void);
uint32_t GPADC_LionConv(uint32_t rdiv, uint32_t volt);//

#endif

     
