#ifndef __OMW_CONFIG_H__
#define __OMW_CONFIG_H__

#ifdef __cplusplus
 extern "C" {
#endif

#ifndef OMW_INCLUDE_IN_ASM
#include <stddef.h>
#include <stdarg.h>
#include <string.h>
#include <stdint.h>

extern uint8_t  ble_max_conn_nr;
#endif

#define OMW_CPU_E902
#define OMW_CHIP_T1001
#define OMW_HAS_LOG_UART
// #define OMW_ON_FPGA
// #define OMW_BLE_CNTR_V0   //V2
// #define OMW_BLE_HOST_V0   //V1, V2
#define OMW_HCI_RAM
//#define OMW_RTOS_LITE_SCH
// #define OMW_SVC_ERR_CHK
#define OMW_DATA_BUF_SIZE   0x500    //KB
#define OMW_SVC_XFR_HAS_ADV_SCAN_DATA

#define OMW_BT_CTRL_COMPANY_ID        (0x0B24)
#define OMW_BT_CTRL_SUBVERSION_NUMBER (0xABCD)

// #define OMW_BLE_EN_BEACON

// #define OMW_OTP_ROM_TEST
// #define OMW_OTP_ROM_APP
// #define OMW_OTP_ROM_USE_OTP_INIT
// #define OMW_RSTR_MORE_CR_REGS

#define OWM_RX_TX_SW_PATCH

#ifndef OMW_XTAL_STUP_TM
#define OMW_XTAL_STUP_TM   (100)  //3000us
#endif

// #define OMW_EN_WDG
#ifdef OMW_EN_WDG
#define OMW_FEED_WDG_TIME    5
#endif

#define OMW_FLASE_BASE_ADDR  0x10000000
#define OMW_FLASE_TOTAL_SIZE (256 * 1024)
#define OMW_FLASH_TAIL_RS    (16 * 1024)
#define OMW_FLASH_HAS_PE
#define OMW_FLASH_SS_BITS  12
#define OMW_FLASH_SS  (1 << OMW_FLASH_SS_BITS)
#ifdef OMW_FLASH_HAS_PE
#define OMW_FLASH_PS_BITS  8
#define OMW_FLASH_PS  (1 << OMW_FLASH_PS_BITS)
#else
#define OMW_FLASH_PS  OMW_FLASH_SS
#endif

// #define OMW_EN_OTA
#ifdef OMW_EN_OTA
#define OMW_OTA_CFG_FLASH_BASE_ADDR  (OMW_FLASE_BASE_ADDR + OMW_FLASE_TOTAL_SIZE - OMW_FLASH_TAIL_RS)
#define OMW_OTA_BTLD_ADDR            (OMW_OTA_CFG_FLASH_BASE_ADDR + OMW_FLASH_SS)
#endif

#define OMW_DATA_XFER_SVR_UUID      (0xFF00)
#define OMW_DATA_XFER_SVR_WT_UUID   (0xFF01)
#define OMW_DATA_XFER_SVR_RD_UUID   (0xFF02)

#define OMW_OTA_SVC_UUID            (0xEE00)
#define OMW_OTA_DATA_UUID           (0xEE01)
#define OMW_OTA_CTRL_UUID           (0xEE02)

#define OMW_BT_ADDR (uint8_t[6]){0x18, 0x15, 0xE8, 0x62, 0x73, 0x34}

#define CONFIG_BT_DIS_MODEL  "T1001"
#define CONFIG_BT_DIS_MANUF  "OmniWare"
#define CONFIG_BT_DEVICE_NAME "OMW Ble test"

#define CONFIG_BT_BUF_ACL_TX_COUNT  5

#define CONFIG_BT_BUF_ACL_RX_COUNT  5

#define CONFIG_BT_BUF_EVT_RX_COUNT  3

#define CONFIG_BT_BUF_CMD_TX_COUNT  3

// #define CONFIG_BT_CENTRAL
// #define CONFIG_BT_GATT_CLIENT

// NOT COMPILE ROM, NEED TO DEFINE CONFIG_BT_MAX_CONN/CONFIG_BT_MAX_CONN_NEW
#define CONFIG_BT_MAX_CONN_NEW   2
#define CONFIG_BT_MAX_CONN    ble_max_conn_nr

// #define CONFIG_BT_SMP
#define CONFIG_BT_CONN        1
#define CONFIG_BT_HCI_RESERVE 4
// #define CONFIG_TINYCRYPT_SHA256

//#define OMW_EN_DEEP_SLEEP

#ifdef OMW_EN_DEEP_SLEEP
#define CONFIG_OTP_PROGRAM
#define CONFIG_FLASH_PROGRAM

#ifdef CONFIG_FLASH_PROGRAM
#define QSPI_VDD_FUNC_REG_VAL        0x18180000   //PIN 10, 11
#define QSPI_VDD_OE_REG_VAL          0x00000C00
#define QSPI_VDD_O_REG_VAL           0x00000C00

#define QSPI_FLASH_FUNC_REG1_VAL     0x00001919   //PIN 12, 13
#define QSPI_FLASH_FUNC_REG2_VAL     0x00001919   //PIN 16, 17
#define QSPI_REMAP_REG_VAL           0x00015423
#endif

#define OMW_EN_CLK_CAL
#define OMW_GPIO_WAKEUP_MASK  0
#define OMW_GPIO_nWAKEUP_MASK 0
#define OMW_EN_UNUSED_GPIO
#ifdef OMW_EN_UNUSED_GPIO
//QFN20: 10, 11,   12,13,16,17, 20,21,14,  0,1 JTAG, HIGH
#define OMW_UNUSED_GPIO_MASK (0xCC83FC)
#define OMW_WHEN_SLEEP_GPIO_MASK (0x337000)
//COB: 10,12,14,15, 20, 21, 0,1 JTAG, HIGH
// #define OMW_UNUSED_GPIO_MASK (0xCF2BFC)
// #define OMW_WHEN_SLEEP_GPIO_MASK (0x30D400)
#else
#define OMW_FAKE_GPIO_HOLD
#define OMW_UNUSED_GPIO_MASK 0
#define OMW_WHEN_SLEEP_GPIO_MASK 0
#endif

// #define OMW_SAVE_UART0_REGS
#define OMW_SAVE_UART1_REGS
#ifdef OMW_EN_UNUSED_GPIO
#define OMW_FLASH_VDDIO_PIN1  10
#define OMW_FLASH_VDDIO_PIN2  11
#endif
#endif

#if defined(OMW_BLE_CNTR_V0) || defined(OMW_BLE_HOST_V0)
#define OMW_BLE_V0_2_0
#ifndef OMW_BLE_V0_2_0
#define OMW_BLE_V0
#endif
#endif

#ifdef OMW_HAS_LOG_UART
#define OMW_LOG_UART            OMW_UART0
#define OMW_LOG_UART_RX_PIN     OMW_GPIO_PIN20
#define OMW_LOG_UART_TX_PIN     OMW_GPIO_PIN21
#define OMW_LOG_UART_RX_FUNC    OMW_GPIO20_UART0_RX
#define OMW_LOG_UART_TX_FUNC    OMW_GPIO21_UART0_TX
#define OMW_LOG_UART_BAUDRATE   115200
#endif

#if defined(OMW_HCI_RAM) && defined(OMW_HCI_H4)
#error "HCI error: can not define H4 and RAM at same time!"
#endif

#if !defined(OMW_HCI_RAM) && !defined(OMW_HCI_H4)
#error "HCI error: must define one of H4 or RAM!"
#endif

#ifdef OMW_HCI_H4
#define OMW_HCI_H4_UART            OMW_UART1
#define OMW_HCI_H4_UART_RX_PIN     OMW_GPIO_PIN22
#define OMW_HCI_H4_UART_TX_PIN     OMW_GPIO_PIN23
#define OMW_HCI_H4_UART_RX_FUNC    OMW_GPIO22_UART1_RX
#define OMW_HCI_H4_UART_TX_FUNC    OMW_GPIO23_UART1_TX
#define OMW_HCI_H4_UART_BAUDRATE   115200
#endif

#if defined(OMW_BLE_CNTR_V0) && defined(OMW_BLE_HOST_V0)
#define OMW_BLE_ONLY_V0
#endif

#if (defined(OMW_BLE_CNTR_V0) && defined(OMW_BLE_CNTR_V1)) || (defined(OMW_BLE_CNTR_V0) && defined(OMW_BLE_CNTR_V2)) || \
    (defined(OMW_BLE_CNTR_V1) && defined(OMW_BLE_CNTR_V2))
#error "can not defined two controller at same time!"
#endif

#if (defined(OMW_BLE_HOST_V0) && defined(OMW_BLE_HOST_V1)) || (defined(OMW_BLE_HOST_V0) && defined(OMW_BLE_HOST_V2)) || \
    (defined(OMW_BLE_HOST_V1) && defined(OMW_BLE_HOST_V2))
#error "can not defined two host at same time!"
#endif

#ifndef OMW_INCLUDE_IN_ASM
#ifdef OMW_CHIP_T1001
#include "t1001.h"
#endif

#ifdef OMW_HAS_SCH
#include "omw_rtos.h"
#endif
#endif

#ifdef __cplusplus
}
#endif

#endif


