#include "omw_config.h"
#include "omw_dbg.h"
#include "omw_uart.h"
#include "periph_uart.h"
#include "periph_gpio.h"
#include "periph_spim.h"
#include "periph_gpadc.h"

//#define SPIM0_TEST
#define SPIM1_TEST

#define SPI_BYTE_NUM 5

GPIO_InitTypeDef GPIO_InitStruct;
uint8_t rbuf[SPI_BYTE_NUM], tbuf[SPI_BYTE_NUM];
int t;

#ifdef SPIM0_TEST
ATTRIBUTE_ISR void SPIM0_Handler(void)
{
	if(SPIM_GetITStatus(SPIM0,SPIM_IT_RX_FIFO_FULL))
	{
		while(SPIM_GetUsrStatus(SPIM0, SPIM_FLAG_RECEIVE_FIFO_NOT_EMPTY))
		{
			// receive data byte
			rbuf[t] = SPIM_ReceiveData(SPIM0);
			t++;
		}
	}
}


int main(void) {

    SPIM_InitTypeDef SPIM_InitStruct;
	int i=0;
	t=0;

  
    //---------------------------------------
    // init
    //---------------------------------------
    omw_dbg_init();
    printf("SPI master 4-wire full-duplex test ...\n");
    for(i=0; i<SPI_BYTE_NUM; i++){
        rbuf[i] = 0;
        tbuf[i] = 0x11 + i;
    }

    //---------------------------------------
    // SPIM0 GPIO configuration, GPIO[16]: NCS, GPIO[17]: SCK, GPIO[18]: MOSI, GPIO[19]: MISO
    //---------------------------------------
    GPIO_StructInit(&GPIO_InitStruct);
    GPIO_InitStruct.GPIO_DriveStrength = GPIO_DRIVE_STRENGTH_3;
    GPIO_InitStruct.GPIO_Pin = GPIO_PIN_16;
    GPIO_InitStruct.GPIO_Mode = GPIO_MODE_IN_FLOATING;
    GPIO_InitStruct.GPIO_AltFunc = OMW_GPIO16_GPIO;
    GPIO_Init(&GPIO_InitStruct);
    GPIO_OutputCMD(GPIO_PIN_16, ENABLE);
    GPIO_WriteBit(GPIO_PIN_16, HIGH); // NCS high
	
    GPIO_InitStruct.GPIO_Pin = GPIO_PIN_17;
    GPIO_InitStruct.GPIO_Mode = GPIO_MODE_IN_FLOATING;
    GPIO_InitStruct.GPIO_AltFunc = OMW_GPIO17_SPIM0_SCK;
    GPIO_Init(&GPIO_InitStruct);
	
    GPIO_InitStruct.GPIO_Pin = GPIO_PIN_18;
    GPIO_InitStruct.GPIO_Mode = GPIO_MODE_IN_FLOATING;
    GPIO_InitStruct.GPIO_AltFunc = OMW_GPIO18_SPIM0_MOSI;
    GPIO_Init(&GPIO_InitStruct);
	
    GPIO_InitStruct.GPIO_Pin = GPIO_PIN_19;
    GPIO_InitStruct.GPIO_Mode = GPIO_MODE_IPD;
    GPIO_InitStruct.GPIO_AltFunc = OMW_GPIO19_SPIM0_MISO;
    GPIO_Init(&GPIO_InitStruct);
    
    //KEY
    GPIO_StructInit(&GPIO_InitStruct);
    GPIO_InitStruct.GPIO_Pin = GPIO_PIN_3;
    GPIO_InitStruct.GPIO_Mode = GPIO_MODE_IPU;
    GPIO_InitStruct.GPIO_AltFunc = OMW_GPIO3_GPIO;
    GPIO_Init(&GPIO_InitStruct);

    //---------------------------------------
    // SPIM0 configuration
    //---------------------------------------
    // de-init
	SPIM_Cmd(SPIM0, DISABLE);
    SPIM_DeInit(SPIM0);
    // init
    SPIM_StructInit(&SPIM_InitStruct);
    SPIM_InitStruct.SPIM_Direction = SPIM_DIRECTION_TX_AND_RX;
    SPIM_InitStruct.SPIM_SCPOL = SPIM_SCPOL_LOW;
    SPIM_InitStruct.SPIM_SCPH = SPIM_SCPH_MIDDLE;
    SPIM_InitStruct.SPIM_BaudRatePrescaler = 0x08;
    SPIM_InitStruct.SPIM_RxFIFOThreshold = 0x03;
    SPIM_InitStruct.SPIM_TxFIFOThreshold = 0x08;
    SPIM_InitStruct.SPIM_Wires = SPIM_WIRES_4;
    SPIM_Init(SPIM0, &SPIM_InitStruct);
	//
    SPIM_ITConfig(SPIM0, SPIM_IT_RX_FIFO_FULL, ENABLE);

    SPIM_Cmd(SPIM0, ENABLE);
	
	omw_set_irq_prio(SPIM0_IRQn,3);
	omw_enable_irq(SPIM0_IRQn);

//    //---------------------------------------
//    // SPI master send and receive N bytes
//    //---------------------------------------
    //wait key
    while(GPIO_ReadInputDataBit(GPIO_PIN_3)==SET);
    // ncs=0
    GPIO_WriteBit(GPIO_PIN_16, LOW);
    // loop
    for(i=0; i<SPI_BYTE_NUM; i++) {
        // wait fifo
        while((SPIM_GetUsrStatus(SPIM0, SPIM_FLAG_TRANSMIT_FIFO_NOT_FULL)) == RESET); // if tx fifo full, wait here
        // send data byte
        SPIM_SendData(SPIM0, tbuf[i]);
    }
	while(SPIM_GetUsrStatus(SPIM0, SPIM_FLAG_BUSY));
    // ncs=1
    GPIO_WriteBit(GPIO_PIN_16, HIGH);


//	//check the fifo for residual data
//	while(SPIM_GetUsrStatus(SPIM0, SPIM_FLAG_RECEIVE_FIFO_NOT_EMPTY))
//	{
//		// receive data byte
//		rbuf[t] = SPIM_ReceiveData(SPIM0);
//		t++;
//	}
	

    //---------------------------------------
    // DELAY
    //---------------------------------------
    DELAY_US(2000);
	
	while(SPIM_GetUsrStatus(SPIM0, SPIM_FLAG_RECEIVE_FIFO_NOT_EMPTY));
    //---------------------------------------
    // Display
    //---------------------------------------
    // send data bytes
    printf("    Send Data: ");
    for(i=0; i<SPI_BYTE_NUM; i++) printf("0x%02x ", tbuf[i]);
    printf("\n");
    // recv data bytes
    printf("    Recv Data: ");
    for(i=0; i<SPI_BYTE_NUM; i++) printf("0x%02x ", rbuf[i]);
    printf("\n");
    // end of test
    while(1);
    return 0;
}
#endif


#ifdef SPIM1_TEST
ATTRIBUTE_ISR void SPIM1_Handler(void)
{
	if(SPIM_GetITStatus(SPIM1,SPIM_IT_RX_FIFO_FULL))
	{
		while(SPIM_GetUsrStatus(SPIM1, SPIM_FLAG_RECEIVE_FIFO_NOT_EMPTY))
		{
			// receive data byte
			rbuf[t] = SPIM_ReceiveData(SPIM1);
			t++;
		}
	}
}


int main(void) {

    SPIM_InitTypeDef SPIM_InitStruct;
	int i=0;
	t=0;

  
    //---------------------------------------
    // init
    //---------------------------------------
    omw_dbg_init();
    printf("SPI master 4-wire full-duplex test ...\n");
    for(i=0; i<SPI_BYTE_NUM; i++){
        rbuf[i] = 0;
        tbuf[i] = 0x11 + i;
    }

    //---------------------------------------
    // SPIM1 GPIO configuration, GPIO[5]: NCS, GPIO[4]: SCK, GPIO[6]: MOSI, GPIO[7]: MISO
    //---------------------------------------
    GPIO_StructInit(&GPIO_InitStruct);
    GPIO_InitStruct.GPIO_DriveStrength = GPIO_DRIVE_STRENGTH_3;
    GPIO_InitStruct.GPIO_Pin = GPIO_PIN_5;
    GPIO_InitStruct.GPIO_Mode = GPIO_MODE_IN_FLOATING;
    GPIO_InitStruct.GPIO_AltFunc = OMW_GPIO5_GPIO;
    GPIO_Init(&GPIO_InitStruct);
    GPIO_OutputCMD(GPIO_PIN_5, ENABLE);
    GPIO_WriteBit(GPIO_PIN_5, HIGH); // NCS high
	
    GPIO_InitStruct.GPIO_Pin = GPIO_PIN_4;
    GPIO_InitStruct.GPIO_Mode = GPIO_MODE_IN_FLOATING;
    GPIO_InitStruct.GPIO_AltFunc = OMW_GPIO4_SPIM1_SCK;
    GPIO_Init(&GPIO_InitStruct);
	
    GPIO_InitStruct.GPIO_Pin = GPIO_PIN_6;
    GPIO_InitStruct.GPIO_Mode = GPIO_MODE_IN_FLOATING;
    GPIO_InitStruct.GPIO_AltFunc = OMW_GPIO6_SPIM1_MOSI;
    GPIO_Init(&GPIO_InitStruct);
	
    GPIO_InitStruct.GPIO_Pin = GPIO_PIN_7;
    GPIO_InitStruct.GPIO_Mode = GPIO_MODE_IPD;
    GPIO_InitStruct.GPIO_AltFunc = OMW_GPIO7_SPIM1_MISO;
    GPIO_Init(&GPIO_InitStruct);
    
    //KEY
    GPIO_StructInit(&GPIO_InitStruct);
    GPIO_InitStruct.GPIO_Pin = GPIO_PIN_3;
    GPIO_InitStruct.GPIO_Mode = GPIO_MODE_IPU;
    GPIO_InitStruct.GPIO_AltFunc = OMW_GPIO3_GPIO;
    GPIO_Init(&GPIO_InitStruct);

    //---------------------------------------
    // SPIM1 configuration
    //---------------------------------------
    // de-init
	SPIM_Cmd(SPIM1, DISABLE);
    SPIM_DeInit(SPIM1);
    // init
    SPIM_StructInit(&SPIM_InitStruct);
    SPIM_InitStruct.SPIM_Direction = SPIM_DIRECTION_TX_AND_RX;
    SPIM_InitStruct.SPIM_SCPOL = SPIM_SCPOL_LOW;
    SPIM_InitStruct.SPIM_SCPH = SPIM_SCPH_MIDDLE;
    SPIM_InitStruct.SPIM_BaudRatePrescaler = 0x08;
    SPIM_InitStruct.SPIM_RxFIFOThreshold = 0x03;
    SPIM_InitStruct.SPIM_TxFIFOThreshold = 0x08;
    SPIM_InitStruct.SPIM_Wires = SPIM_WIRES_4;
    SPIM_Init(SPIM1, &SPIM_InitStruct);
	//
    SPIM_ITConfig(SPIM1, SPIM_IT_RX_FIFO_FULL, ENABLE);
	
    SPIM_Cmd(SPIM1, ENABLE);
	omw_set_irq_prio(SPIM1_IRQn,3);
	omw_enable_irq(SPIM1_IRQn);

//    //---------------------------------------
//    // SPI master send and receive N bytes
//    //---------------------------------------
    //wait key
    while(GPIO_ReadInputDataBit(GPIO_PIN_3)==SET);
    // ncs=0
    GPIO_WriteBit(GPIO_PIN_5, LOW);
    // loop
    for(i=0; i<SPI_BYTE_NUM; i++) {
        // wait fifo
        while((SPIM_GetUsrStatus(SPIM1, SPIM_FLAG_TRANSMIT_FIFO_NOT_FULL)) == RESET); // if tx fifo full, wait here
        // send data byte
        SPIM_SendData(SPIM1, tbuf[i]);
    }
	while(SPIM_GetUsrStatus(SPIM1, SPIM_FLAG_BUSY));
    // ncs=1
    GPIO_WriteBit(GPIO_PIN_5, HIGH);


//	//check the fifo for residual data
//	while(SPIM_GetUsrStatus(SPIM1, SPIM_FLAG_RECEIVE_FIFO_NOT_EMPTY))
//	{
//		// receive data byte
//		rbuf[t] = SPIM_ReceiveData(SPIM1);
//		t++;
//	}
	

    //---------------------------------------
    // DELAY
    //---------------------------------------
    DELAY_US(2000);
	
	while(SPIM_GetUsrStatus(SPIM1, SPIM_FLAG_RECEIVE_FIFO_NOT_EMPTY));
    //---------------------------------------
    // Display
    //---------------------------------------
    // send data bytes
    printf("    Send Data: ");
    for(i=0; i<SPI_BYTE_NUM; i++) printf("0x%02x ", tbuf[i]);
    printf("\n");
    // recv data bytes
    printf("    Recv Data: ");
    for(i=0; i<SPI_BYTE_NUM; i++) printf("0x%02x ", rbuf[i]);
    printf("\n");
    // end of test
    while(1);
    return 0;
}
#endif
