
#ifndef __OMW_TIMER_H__
#define __OMW_TIMER_H__

#ifdef OMW_CHIP_T1001
#include "t1001.h"
#include "sys_timeout.h"
#include "t1001_vtimer.h"
#include "omw_gpio.h"
#include "hc_config.h"

typedef enum 
	{
	OMW_TIMER0_GPIO0 = 0x00,
	OMW_TIMER1_GPIO1,
	OMW_TIMER2_GPIO2,
	OMW_TIMER3_GPIO3,
	OMW_TIMER4_GPIO4,
	OMW_TIMER5_GPIO5,
	OMW_TIMER6_GPIO6,
	OMW_TIMER7_GPIO7,
    OMW_TIMER0_GPIO8,
	OMW_TIMER1_GPIO10,
	OMW_TIMER2_GPIO12,
	OMW_TIMER3_GPIO14,
	OMW_TIMER4_GPIO16,
	OMW_TIMER5_GPIO18,
	OMW_TIMER6_GPIO20,
	OMW_TIMER7_GPIO22,
	OMW_TIMER0_N_GPIO9,
	OMW_TIMER1_N_GPIO11,
	OMW_TIMER2_N_GPIO13,
	OMW_TIMER3_N_GPIO15,
	OMW_TIMER4_N_GPIO17,
	OMW_TIMER5_N_GPIO19,
	OMW_TIMER6_N_GPIO21,
	OMW_TIMER7_N_GPIO23,

}OMW_ENUM_TIMER_GPIO;

typedef enum 
{
	TIMER0  = 0x00,
	TIMER1 ,
	TIMER2 ,
	TIMER3 ,
	TIMER4 ,
	TIMER5 ,
	TIMER6 ,
	TIMER7 ,
}OMW_ENUM_TIMER;

#define OMW_TIMER_PWM0N100_ENABLE (0X10)
#define OMW_TIMER_PWM0N100_DISABLE (0X00)
		
#define OMW_TIMER_MODE_USER_DEFINED  (0x02)
#define OMW_TIMER_MODE_FREE_RUNNING  (0x00)



#define OMW_TIMER_PWM_ENABLE   (0x08)
#define OMW_TIMER_PWM_DISABLE  (0x00) 



#define OMW_TIMER_INTR_ENABLE  (0x00)
#define OMW_TIMER_INTR_DISABLE (0x04)

typedef enum 
{
OMW_TIMER_CLK_SEL_XTAL24M = 0X00,
OMW_TIMER_CLK_SEL_RC24M ,
OMW_TIMER_CLK_SEL_PLL48M ,
}OMW_ENUM_TIMER_CLK;

typedef enum 
{
OMW_TIMER_CLK_DIVIDE_2 = 0X00,
OMW_TIMER_CLK_DIVIDE_4 ,
OMW_TIMER_CLK_DIVIDE_8 ,
OMW_TIMER_CLK_DIVIDE_16 ,
OMW_TIMER_CLK_DIVIDE_32 ,
OMW_TIMER_CLK_DIVIDE_64 ,
OMW_TIMER_CLK_DIVIDE_128 ,
OMW_TIMER_CLK_DIVIDE_256 ,
OMW_TIMER_CLK_DIVIDE_512 ,
OMW_TIMER_CLK_DIVIDE_1024 ,
OMW_TIMER_CLK_DIVIDE_2048 ,
OMW_TIMER_CLK_NO_DIVIDE ,
}OMW_ENUM_TIMER_CLK_DIVIDE;

typedef struct
{
    uint8_t timer_pwm_en; 	
	
	uint8_t timer_pwm0n100_en;
	
	uint8_t timer_mode;
	
	uint16_t timer_loadcount;
	
	uint16_t timer_loadcount2;
	
	uint16_t timer_clk;
	
	uint32_t timer_clk_divide;
}TIMER_InitTypeDef;


void omw_timer_init(OMW_ENUM_TIMER TIMERx,TIMER_InitTypeDef *timer_struct);
void omw_timer_struct_init(TIMER_InitTypeDef *timer_struct);
void omw_timer_gpio_init(OMW_ENUM_TIMER_GPIO TIMER_GPIOx);
uint16_t omw_timer_count_value(OMW_ENUM_TIMER TIMERx);
void omw_timer_en(OMW_ENUM_TIMER TIMERx,FunctionalState STATE);
void omw_timer_it_en(OMW_ENUM_TIMER TIMERx,FunctionalState NEWSTATE);
void omw_timer_it_clr (void);
ITStatus omw_timer_get_it_status(OMW_ENUM_TIMER TIMERx);
#endif

#endif
