#ifndef __OMW_SYS_H__
#define __OMW_SYS_H__
// include
#include "t1001.h"

#define SYS_CLK_RC24M           0
#define SYS_CLK_XTAL24M         1
#define SYS_CLK_PLL48M          2
#define SYS_CLK_PLL24M          3
#define SYS_CLK_PLL12M          4
#define SYS_CLK_PLL6M           5

#define RESET_FLAG_LVD          (1<<9)
#define RESET_FLAG_LOCKUP       (1<<8)
#define RESET_FLAG_SWRST        (1<<7)
#define RESET_FLAG_DBGRST       (1<<5)
#define RESET_FLAG_WDT          (1<<3)
#define RESET_FLAG_DEEPSLEEP    (1<<1)
#define RESET_FLAG_POR          (1<<0)


// func
void omw_set_sys_clk(uint32_t sel);
uint32_t omw_get_sys_clk(void);
uint32_t omw_get_sys_clk_freq(void);
uint32_t omw_get_reset_flag(void);
void omw_clear_reset_flag(uint32_t d);
void omw_soft_reset(void);
void omw_rtc_delay_ms(uint32_t d);

#endif
