/*****************************************************************************************
 * @Author: Cedric Kong <dachao.kong@omnilinktek.com>
 * @Date: 2024-03-01 17:28:57
 * @LastEditors: Cedric Kong
 * @LastEditTime: 2024-03-05 15:13:53
 * @FilePath: omw_iic.h
 * @Description: 请填写文件说明
 * @Copyright: © 2021-2024 OmniLinkTek, All Rights Reserved.
 ****************************************************************************************/
#ifndef __OMW_IIC_H__
#define __OMW_IIC_H__

#include <stdint.h>
#include "hc_config.h"
#include "omw_gpio.h"


#define OMW_IIC_BASE        ((uint32_t*)IIC_BASE )  //0x41005000
enum {
    IIC_SPEED_STANDARD = 0x2,
    IIC_SPEED_FAST = 0x4
};

enum {
    IIC_MODE_SLAVE,
    IIC_MODE_MASTER
};

enum {
    IIC_CLK_400K = 0x34,
    IIC_CLK_200K = 0x70,
    IIC_CLK_100K = 0xe8,
    IIC_CLK_50K = 0x1d8
};

enum {
	IIC_ADDR_METHOD_7BIT,
    IIC_ADDR_METHOD_10BIT
};


void omw_iic_init( uint32_t * iic_ctrl, uint16_t iic_mode, uint16_t addr_method, uint16_t addr, uint16_t clk);
void omw_iic_master_send( uint32_t * iic_ctrl, uint8_t *buf, uint16_t len);
void omw_iic_master_recv( uint32_t * iic_ctrl, uint8_t *buf, uint32_t len);
void omw_iic_slave_send(uint32_t * iic_ctrl, uint8_t *buf, uint16_t len);
void omw_iic_slave_recv(uint32_t * iic_ctrl, uint8_t *buf, uint32_t len);
#endif //_MODULE_IIC_H

