#ifndef __OMW_CMD_H__
#define __OMW_CMD_H__

//#include "hc_config.h"
#include "omw_gpio.h"
#include "omw_uart.h"

#define CMD_UART_FIFO_BUF_SIZE  128   //need power of 2


#define NVIC_EnableIRQ(IRQn) csi_vic_enable_irq(IRQn)
#define NVIC_SetPriority(IRQn, priority) csi_vic_set_prio(IRQn, priority)



extern uint8_t  cmd_uart_buf[CMD_UART_FIFO_BUF_SIZE];
extern uint16_t  omw_cmd_uart_fifo_sz;
extern uint8_t * omw_cmd_uart_fifo_buf;

//ok: return len, or return 0
//int omw_cmd_uart_it_rx(uint8_t * rx_buf, uint16_t len);
void omw_cmd_uart_enable(uint8_t it_mode);
void app_cmd_uart_rx_init(uint8_t *data, uint16_t size);

void rcv_uart_data(void);					//zhq  note: 

static inline void
omw_cmd_uart_send(void * pdata, uint32_t len){
    omw_uart_send(OMW_LOG_UART, pdata, len);
}

static inline uint32_t
omw_cmd_uart_rx(void * pdata, uint32_t len){
    return omw_uart_rcv(OMW_LOG_UART, pdata, len);
}

static inline void
omw_cmd_uart_set_rx_fifo(uint8_t * fifo_buf, uint16_t fifo_sz){
    omw_uart_set_rx_fifo(OMW_LOG_UART, fifo_buf, fifo_sz);
    omw_cmd_uart_fifo_sz = fifo_sz;
    omw_cmd_uart_fifo_buf = fifo_buf;
}

static inline uint16_t
omw_cmd_uart_get_rx_fifo_wt(void){
    return omw_uart_get_rx_fifo_wt(OMW_LOG_UART);
}

static inline void
omw_cmd_uart_set_rx_fifo_rd(uint16_t n_rd){
    omw_uart_set_rx_fifo_rd(OMW_LOG_UART, n_rd);
}
#endif
