#include "hc_config.h"

#include "pdu.h"
#include "system.h"
#include "ll_conn.h"
#include "hci_driver.h"

#ifdef OMW_COMID_PATCH
void ll_conn_tx_enqueue_patch(struct ll_conn_set *conn, struct node_tx_pdu *node_tx)
{
    struct pdu_data *pdu_tx = (struct pdu_data *)node_tx->pdu;
    if (pdu_tx->ll_id == PDU_DATA_LLID_CTRL && pdu_tx->llctrl.opcode == PDU_DATA_LLCTRL_TYPE_VERSION_IND){
        pdu_tx->llctrl.version_ind.company_id = OMW_BT_CTRL_COMPANY_ID;
        pdu_tx->llctrl.version_ind.sub_version_number = OMW_BT_CTRL_SUBVERSION_NUMBER;
    }

    rom_hook_register(ROM_HOOK_INDEX_DECLAR(ll_conn_tx_enqueue), NULL);
    ll_conn_tx_enqueue(conn, node_tx);
    rom_hook_register(ROM_HOOK_INDEX_DECLAR(ll_conn_tx_enqueue), ll_conn_tx_enqueue_patch);
}
#endif

__RAM_CODE_SECTION
uint32_t ll_conn_is_connected()
{
    struct ll_conn_set *conn = ll_conn_set_get(0);

    return conn->status.active;
}

#ifdef OMW_EN_DEEP_SLEEP
static uint8_t  ll_conn_status;
void ll_conn_process_before_sleep()
{
    struct ll_conn_set *conn = ll_conn_set_get(0);
    ll_conn_status = conn->status.active;
}

__RAM_CODE_SECTION
uint32_t ll_conn_is_connected_before_sleep()
{
    return ll_conn_status;
}

SleepModes Bt_SleepMode_Check(void);

__RAM_CODE_SECTION
uint32_t ll_conn_process_wake_up()
{
    struct ll_conn_set *conn = ll_conn_set_get(0);
    if (ll_conn_status != conn->status.active) return 1;

    uint32_t slpm = Bt_SleepMode_Check();

    return (SLEEPMODE_RUNNING == slpm);
}
#endif