#ifndef __OMW_CLKCAL_H__
#define __OMW_CLKCAL_H__

// inc
#include "t1001.h"
#include <stdint.h>

// macro
#define CLKCAL_CLK_CORNER       4       // 200K
#define CLKCAL_CLK_XT24M        3       // 24M
#define CLKCAL_CLK_XT32K        2       // 32K
#define CLKCAL_CLK_RC24M        1       // 24M
#define CLKCAL_CLK_RC32K        0       // 32K

// func
void omw_clkcal_delayus(int d);
void omw_clkcal_delayms(int d);
void omw_clkcal_reset(void);
void omw_clkcal_deinit(void);
void omw_clkcal_init(int refclk, int calclk, int cyc, int ie);
void omw_clkcal_enable(int d);
int omw_clkcal_calpol(int refclk, int calclk, int cyc);
void omw_clkcal_calint(int refclk, int calclk, int cyc);
void omw_clkcal_rc24m_calibration(void);
void omw_clkcal_rc32k_calibration(void);
    
#endif

