#include "at_commands.h"
#include "user_config.h"
#include "t1001.h"
#include "hc_ctrlr.h"
#include "hc_host.h"
#include "omw_timer.h"
#include "omw_gpio.h"
#include "omw_dbg.h"
#include "omw_cmd.h"
#ifdef OMW_HAS_SCH
#include "omw_rtos.h"
#endif
#ifdef OMW_HAS_LOG_UART
#include "omw_dbg.h"
#endif

#ifdef OMW_EN_DEEP_SLEEP
#ifdef OMW_CHIP_T1001
#include "t1001_sleep.h"
#endif
#else
#include "sys_timeout.h"
#endif

uint32_t sys_timeout_tick_get_hook(void);
void sys_timeout_init(SYS_TIMEOUT_TICK_GET_HOOK tick_hook);


__WEAK void hc_app_init()
{
}

__WEAK void omw_app_init()
{
}

__WEAK void omw_app_init_after_ble_init()
{

}

__WEAK void hc_app_main()
{
}


#ifdef OMW_EN_DEEP_SLEEP
__WEAK void omw_app_main_after_wake_up()
{

}
#endif

__WEAK uint8_t omw_app_can_sleep()
{
    return 1;
}

void * hci_send2host_cb = NULL;

#ifdef OMW_HCI_RAM
void omw_reg_hci_send2host_cb(void * cb)
{
    hci_send2host_cb = cb;
}
#endif

#ifdef OMW_HAS_SCH
void omw_main_app_task(void)
{
    while(1) {
        hc_app_main();

        omw_hw_chk_and_en_irq();
    }
}
#endif

#ifdef OMW_EN_DEEP_SLEEP
void omw_sleep_check()
{
    #ifdef OMW_CHIP_T1001
    (void)T1001_Sleep(SLEEPMODE_NOTIMER, OMW_GPIO_WAKEUP_MASK, OMW_GPIO_nWAKEUP_MASK);
    #endif
}
#endif

int main(void)
{
    #ifdef OMW_HAS_LOG_UART
    omw_dbg_init();
    #endif
	omw_dbg_init(cmd_uart_buf, CMD_UART_FIFO_BUF_SIZE);							//zhq  note: 
	
	user_config();
    //cali need
    VTIMER_Init(); //must init before app init, because app will init timer in omw_app_init

    //app init must before ble init, because app may set addr, adv data...
	hc_app_init();

    //ble init start
    omw_base_init();

    #if defined(OMW_BLE_HOST_V0) || defined(OMW_BLE_HOST_V1) || defined(OMW_BLE_HOST_V2) || defined(OMW_BLE_HOST_OTHER)
    sys_timeout_init(sys_timeout_tick_get_hook);
    #endif

    #if defined(OMW_BLE_CNTR_V0) || defined(OMW_BLE_CNTR_V1) || defined(OMW_BLE_CNTR_V2)
    omw_ctrlr_init(hci_send2host_cb);
    #endif

    #if defined(OMW_BLE_HOST_V0) || defined(OMW_BLE_HOST_V1) || defined(OMW_BLE_HOST_V2) || defined(OMW_BLE_HOST_OTHER)
    omw_host_init();
    #endif

    //omw_app_init_after_ble_init();

    #ifndef OMW_HAS_SCH
    while(1)
    {
        #if defined(OMW_BLE_CNTR_V0) || defined(OMW_BLE_CNTR_V1) || defined(OMW_BLE_CNTR_V2)
        #ifdef OMW_HCI_H4
        omw_ctrlr_h4_rx_polling();
        #endif
        #endif

        #if defined(OMW_BLE_HOST_V0) || defined(OMW_BLE_HOST_V1) || defined(OMW_BLE_HOST_V2) || defined(OMW_BLE_HOST_OTHER)
        omw_host_work_polling();
        #endif

        hc_app_main();

        #ifdef OMW_EN_WDG
        FEED_WTD(OMW_FEED_WDG_TIME);
        #endif

        #ifdef OMW_EN_DEEP_SLEEP
        omw_sleep_check();

        //omw_app_main_after_wake_up();
        #endif

        // uint32_t otp_val_chk_val = *(uint32_t *)0x1f802b94;
        // while(otp_val_chk_val != 0x08432200);
    }
    #else
    omw_rtos_add_task(omw_main_app_task, OMW_RTOS_PRO_LOW, OMW_APP_TASK_SP_SS, NULL);
    omw_rtos_start_sch();
    #endif
}
