#include "bt_buf.h"

#include "utils/simple_buf.h"

#define LOG_MODULE_NAME buf
////#include "bt_log.h"

#define H4_CMD 0x01
#define H4_ACL 0x02
#define H4_SCO 0x03
#define H4_EVT 0x04
#define H4_ISO 0x05

uint8_t bt_get_h4_type_by_buffer(enum bt_buf_type type)
{

    switch (type)
    {
    case BT_BUF_EVT:
        return H4_EVT;
    case BT_BUF_ACL_IN:
    case BT_BUF_ACL_OUT:
        return H4_ACL;
    case BT_BUF_CMD:
        return H4_CMD;
    default:
        break;
    }
    //LOG_ERR("Invalid type: %u", type);
    return 0;
}

simple_buf_t *bt_buf_get_rx(enum bt_buf_type type)
{
    return bt_buf_get(type);
}

uint8_t bt_buf_reserve_size_host_tx_acl(void)
{
    return bt_buf_reserve_size(BT_BUF_ACL_OUT);
}
