#include "hc_config.h"
#include "omw_dbg.h"
#include "omw_svc.h"
#include "omw_rtos.h"
#include "data_xfer.h"
#include "utils/sys_timer.h"
#include "gap_def.h"
#include <string.h>
#include <stdlib.h>
#include "at_commands.h"
#include "omw_cmd.h"
#include "omw_uart.h"

char at_command_buffer[64] = "\0";
char *at_command_type;
char *at_command_data;
uint8_t at_commands_checked = 0;

extern struct bt_le_conn_param ble_conn_param ;
extern struct bt_hci_cp_le_set_adv_param  g_adv_param ;
extern uint32_t deft_conn ;
extern uint8_t g_sleep_timer_flag ;
extern uint8_t * omw_cmd_uart_fifo_buf;

char  Cmd_AT_Begin[5]= {"AT"};													//zhq  note: 检测AT指令模式
char  Cmd_AT_Name[15]= {"AT+BLENAME"};							//zhq  note: 检测AT指令-查询更改设备名称
//char  Cmd_AT_Uart[15]= {"AT+BLEUART"};								//zhq  note: 检测AT指令-查询更改波特率
//char  Cmd_AT_Addr[15]= {"AT+BLEADDR"};							//zhq  note: 检测AT指令-查询更改设备地址

char  Cmd_AT_Advintv[15]= {"AT+BLEADVINTV"};					//zhq  note: 检测AT指令-查询更改广播间隔
char  Cmd_AT_Conn_min[15]= {"AT+BLECONMIN"};				//zhq  note: 检测AT指令-查询更改连接最小间隔
char  Cmd_AT_Conn_max[15]= {"AT+BLECONMAX"};				//zhq  note: 检测AT指令-查询更改连接最大间隔
char  Cmd_AT_Conn_lat[15]= {"AT+BLECONLAT"};					//zhq  note: 检测AT指令-查询更改连接延迟周期
char  Cmd_AT_Conn_to[15]= {"AT+BLECONTO"};						//zhq  note: 检测AT指令-查询更改连接超时时间

//char  Cmd_AT_Wakeup[15]= {"AT+BLEWAKEUP"};					//zhq  note: 检测AT指令-唤醒程序
//char  Cmd_AT_Sleep[15]= {"AT+BLESLEEP"};								//zhq  note: 检测AT指令-程序进入睡眠模式


int hc_string_to_number(char  *temp_string)				//zhq  note: 字符(十进制)转换成数字
{
	uint16_t number = 0;
	for (uint8_t j=0; j < strlen(temp_string); j++)
	{
		number = number*10 + temp_string[j] - '0';
	}	
	
	return  number;	
}

char *hc_number_to_string(uint16_t  number,char *str)				//zhq  note: 数字(十进制)转换成字符
{

	uint16_t temp_number = number;
	int i=0;

	do {
		str[i++] = temp_number%10 + '0';
		
		temp_number/= 10;
	}while (temp_number);
	str[i] = '\0';	
	
	for (int j=0; j<i/2 ;j++) {
		str[j] = str[j] + str[i-1-j];
		str[i-1-j] = str[j] - str[i-1-j];
		str[j] = str[j] - str[i-1-j];
	}
	
	return  str;	
}







void hc_at_commands_app(char *command, char *params )					//zhq  note: 处理AT指令
{
	uint8_t params_len = strlen(params);
//	if (*params ==  '\0') {
//		params_len = 0;
//	}
	char str[10] = {0};
		
	if (0 == strcmp(command, Cmd_AT_Begin)) 
	{
		outputs("\r\nOK\r\n");
		return;		
	}
	
	if (0 == strcmp(command, Cmd_AT_Name)) 											//zhq  note: 设置设备名称
	{
		if (params_len) 
		{		
			memset(config_bt_name, 0,sizeof(config_bt_name)) ;
			memcpy(config_bt_name, params, strlen(params));
			
			omw_svc_stop_adv();					
			user_config();					
			omw_svc_start_adv();
		}	
		//outputs("\r\n+BLENAME=%s\r\nOK\r\n",config_bt_name);
		outputs("\r\n+BLENAME=");
		outputs(config_bt_name);
		outputs("\r\nOK\r\n");
		
		return;		
	}
	
	if (0 == strcmp(command, Cmd_AT_Advintv)) 									//zhq  note: 调整广播包广播间隔	
	{
		outputs("\r\n+BLEADVINTV=");		
		if (!params_len) 
		{
			char *temp_str = hc_number_to_string(g_adv_param.min_interval , str);	
			outputs(temp_str);			
			//printf("\r\n+BLEADVINTV=%d\r\nOK\r\n",BT_GAP_ADV_SLOW_INT_MIN);
			//outputs(BT_GAP_ADV_SLOW_INT_MIN);
		}
		else 
		{	
			uint16_t temp_data = hc_string_to_number(params)	;			
			hc_adv_interval_updata(temp_data,temp_data);	
			
			//printf("\r\n+BLEADVINTV=%s\r\nOK\r\n",params);				
			outputs(params);	
		}	
		outputs("\r\nOK\r\n");
		return;		
	
	}	
	
	if (0 == strcmp(command, Cmd_AT_Conn_min))  							//zhq  note: 配置连接间隔参数-最小间隔
	{
		outputs("\r\n+BLECONMIN=");		
		if (!params_len) 
		{
			char *temp_str = hc_number_to_string(ble_conn_param.interval_min , str);	
			outputs(temp_str);
		}				
		else 
		{		
			uint16_t temp_data = hc_string_to_number(params)	;			
			hc_connected_interval_updata(1,temp_data);
			
			//printf("\r\n+BLECONMIN=%d\r\nOK\r\n",ble_conn_param.interval_min);			
			outputs(params);				
		}	
		outputs("\r\nOK\r\n");	
		return;		
	}	
	
	if (0 == strcmp(command, Cmd_AT_Conn_max))  							//zhq  note: 配置连接间隔参数-最大间隔
	{
		outputs("\r\n+BLECONMAX=");
		if (!params_len) 
		{
			char *temp_str = hc_number_to_string(ble_conn_param.interval_max , str);	
			outputs(temp_str);
		}			
		else
		{		
			uint16_t temp_data = hc_string_to_number(params)	;			
			hc_connected_interval_updata(2,temp_data);
			
			//printf("\r\n+BLECONMAX=%d\r\nOK\r\n",ble_conn_param.interval_max);			
			outputs(params);			
		}	
		outputs("\r\nOK\r\n");		
		return;		
	}	

	if (0 == strcmp(command, Cmd_AT_Conn_lat))  							//zhq  note: 配置连接间隔参数-延迟周期
	{
		outputs("\r\n+BLECONLAT=");
		if (!params_len) 
		{
			char *temp_str = hc_number_to_string(ble_conn_param.latency , str);	
			outputs(temp_str);
		}			
		else
		{		
			uint16_t temp_data = hc_string_to_number(params)	;
			hc_connected_interval_updata(3,temp_data);
			
			//printf("\r\n+BLECONLAT=%d\r\nOK\r\n",ble_conn_param.latency);			
			outputs(params);
		}	
		outputs("\r\nOK\r\n");		
		return;		
	}		
	
	if (0 == strcmp(command, Cmd_AT_Conn_to)) 							//zhq  note: 配置连接间隔参数-超时时间
	{
		outputs("\r\n+BLECONTO=");
		if (!params_len) 
		{
			char *temp_str = hc_number_to_string(ble_conn_param.timeout , str);	
			outputs(temp_str);
		}			
		else
		{		
			uint16_t temp_data = hc_string_to_number(params)	;			
			hc_connected_interval_updata(4,temp_data);
			
			//printf("\r\n+BLECONTO=%d\r\nOK\r\n",ble_conn_param.timeout);				
			outputs(params);			
		}
		outputs("\r\nOK\r\n");		
		return;		
	}		
	
//		if (0 == strcmp(command, Cmd_AT_Sleep)) 							//zhq  note: 配置程序进入睡眠模式
//	{
//		outputs("\r\n+BLESLEEP");
//		if (params_len) 
//		{
//			g_sleep_timer_flag = 1;
//		}			
//
//		outputs("\r\nOK\r\n");		
//		return;		
//	}	
	
}






void hc_adv_interval_updata(uint16_t adv_interval_min,uint16_t adv_interval_max)				//zhq  note: 调整广播包广播间隔	
{

	omw_svc_stop_adv();					
	omw_svc_set_adv_intvl(adv_interval_min, adv_interval_max);							
	omw_svc_start_adv();

}






void hc_connected_interval_updata(uint8_t sel, uint16_t inv_data)		//zhq  note: 调整连接间隔参数
{
	switch (sel) 
	{
		case 1:
				ble_conn_param.interval_min =   inv_data;
				break;
				
		case 2:
				ble_conn_param.interval_max =  inv_data;	
				break;	
			
		case 3:
				ble_conn_param.latency =   inv_data;
				break;	
			
		case 4:
				ble_conn_param.timeout =  inv_data ;
				break;				
				
		default:
				break;
	}
	
	if (deft_conn )
	{		
		omw_svc_updata_cnnt_param(deft_conn, ble_conn_param.interval_min, ble_conn_param.interval_max, ble_conn_param.latency, ble_conn_param.timeout);
	}

}




// 处理命令并提取参数
void hc_at_command_handle(void) {
	char *equalsign = NULL;
	char *question_mark = NULL;

	int buffer_len = strlen(at_command_buffer);
	if (buffer_len >=2 ) {
		at_command_buffer[buffer_len-2] = '\0';
		
		for (int i = 0;i<buffer_len -2;i++)
		{
			if(at_command_buffer[i] == '=') {
				equalsign = &at_command_buffer[i];
				*equalsign = '\0';
				at_command_data = equalsign + 1;
				at_commands_checked = 1;  
				break;
			}else if(at_command_buffer[i] == '?') {
				question_mark = &at_command_buffer[i];
				*question_mark = '\0';
				*at_command_data = '\0';
				at_commands_checked = 1;  
				break;
			}else if((at_command_buffer[i] == 'A') &&(at_command_buffer[i+1] == 'T')){
				if (!at_commands_checked) {
					at_command_type = &at_command_buffer[i]; 
					at_commands_checked = 1;  
				}
			}
			
		}
	}
	if(at_commands_checked ) {
		at_commands_checked = 0;

		hc_at_commands_app(at_command_type,at_command_data);
		
	}
	

}





void hc_at_cmd_check(void)
{
	
	hc_at_command_handle();					//zhq  note: 处理AT指令字符串
	
}

