#include "t1001.h"
#include "stdint.h"
#include "omw_wdt.h"
//#include "math.h"

void omw_wdt_feed(uint16_t ms)
{
	uint16_t time = (32000 - ms)/125;
//	uint16_t time = 256-ceil(ms/125);
	SYS_CTRL->WDT_SET = time;
}


void omw_wdt_en(FunctionalState NEWSTATE)
{
//	assert_param(IS_FUNCTIONAL_STATE(NEWSTATE));
	if(NEWSTATE != DISABLE)
		SYS_CTRL->WDT_CFG |= ENABLE;
	else
		SYS_CTRL->WDT_CFG &= ~ENABLE;
}


uint16_t omw_wdt_value(void)
{
	return (SYS_CTRL->WDT_STATUS & 0x1ff);
}

uint16_t omw_wdt_time_value(void)
{
	return((256 - omw_wdt_value())*125);
}

void omw_wdt_it_en(void)
{
	SYS_CTRL->WDT_CFG |= (ENABLE << 1);
}

void omw_wdt_reset(void)
{
	SYS_CTRL->WDT_CFG &= ~(ENABLE << 1);
}

uint8_t omw_wdt_get_status(void)
{
	FlagStatus flag;
	if((AON_CTRL->CPU_RST_RCD & 0x08) != RESET)
		flag = SET;
	else
		flag = RESET;
	return flag;
}


void omw_wdt_clr_status(void)
{
	AON_CTRL-> CPU_RST_CLR |= 0x08;
}
