#ifndef __OMW_CONFIG_H__
#define __OMW_CONFIG_H__

#ifdef __cplusplus
 extern "C" {
#endif

#ifndef OMW_INCLUDE_IN_ASM
#include <stddef.h>
#include <stdarg.h>
#include <string.h>
#endif

#define OMW_CHIP_T1001
#define OMW_HAS_LOG_UART
#define OMW_BLE_CNTR_V0   //V2
#define OMW_BLE_HOST_V0   //V1, V2

#define OMW_TIMER

#define OMW_EN_DEEP_SLEEP
#ifdef OMW_EN_DEEP_SLEEP

#define CONFIG_OTP_PROGRAM   0
#define CONFIG_FLASH_PROGRAM 1

#if (CONFIG_FLASH_PROGRAM)
//#define QSPI_VDD_FUNC_REG_VAL        0x18180000   //PIN 10, 11
//#define QSPI_VDD_OE_REG_VAL          0x00000C00
//#define QSPI_VDD_O_REG_VAL           0x00000C00

#define QSPI_FLASH_FUNC_REG1_VAL     0x00190000  //PIN 10
#define QSPI_FLASH_FUNC_REG2_VAL     0x19190019  //PIN 12,14,15
//#define QSPI_REMAP_REG_VAL           0x00543210
#endif

#define OMW_GPIO_WAKEUP_MASK  0
#define OMW_GPIO_nWAKEUP_MASK 0x380004 //(1 << OMW_LOG_UART_RX_PIN)
#define OMW_UNUSED_GPIO_MASK     (0xC72BF8)
#define OMW_WHEN_SLEEP_GPIO_MASK (0xC72BF8)

#define OMW_SAVE_UART0_REGS
#define OMW_FLASH_VDDIO_PIN1  0xff
#define OMW_FLASH_VDDIO_PIN2  0xff
#endif

#define OMW_USE_STATIC_IRQ_TBL

#define OMW_2G4_DMA_EN_IRQ
#define OMW_2G4_RX_ON_SLEEP
//#define OMW_2G4_ROLE_SLAVE_NO_SLP
//#define OMW_2G4_ROLE_SLAVE_ON_SLP
//#define OMW_2G4_ROLE_BOTH

#if defined(OMW_BLE_CNTR_V0) || defined(OMW_BLE_HOST_V0)
#define OMW_BLE_V0
#endif

#ifdef OMW_HAS_LOG_UART
#define OMW_LOG_UART            OMW_UART0
#define OMW_LOG_UART_RX_PIN     OMW_GPIO_PIN20
#define OMW_LOG_UART_TX_PIN     OMW_GPIO_PIN21
#define OMW_LOG_UART_RX_FUNC    OMW_GPIO20_UART0_RX
#define OMW_LOG_UART_TX_FUNC    OMW_GPIO21_UART0_TX
#define OMW_LOG_UART_BAUDRATE   115200
#endif

#if defined(OMW_BLE_CNTR_V0) && defined(OMW_BLE_HOST_V0)
#define OMW_BLE_ONLY_V0
#endif

#ifndef OMW_INCLUDE_IN_ASM
#ifdef OMW_CHIP_T1001
#include "t1001.h"
#endif
#endif

#ifdef OMW_HAS_SCH
#include "omw_rtos.h"
#endif

#ifdef __cplusplus
}
#endif

#endif


#ifdef OMW_TIMER
#define OMW_TIMER_PIN_PWM0_1        (OMW_GPIO_PIN0)
#define OMW_TIMER_PIN_PWM1_1        (OMW_GPIO_PIN1)
#define OMW_TIMER_PIN_PWM2_1        (OMW_GPIO_PIN2)
#define OMW_TIMER_PIN_PWM3_1        (OMW_GPIO_PIN3)
#define OMW_TIMER_PIN_PWM4_1        (OMW_GPIO_PIN4)
#define OMW_TIMER_PIN_PWM5_1        (OMW_GPIO_PIN5)
#define OMW_TIMER_PIN_PWM6_1        (OMW_GPIO_PIN6)
#define OMW_TIMER_PIN_PWM7_1        (OMW_GPIO_PIN7)
#define OMW_TIMER_PIN_PWM0_2        (OMW_GPIO_PIN8)
#define OMW_TIMER_PIN_PWM0_N        (OMW_GPIO_PIN9)
#define OMW_TIMER_PIN_PWM1_2        (OMW_GPIO_PIN10)
#define OMW_TIMER_PIN_PWM1_N        (OMW_GPIO_PIN11)
#define OMW_TIMER_PIN_PWM2_2        (OMW_GPIO_PIN12)
#define OMW_TIMER_PIN_PWM2_N        (OMW_GPIO_PIN13)
#define OMW_TIMER_PIN_PWM3_2        (OMW_GPIO_PIN14)
#define OMW_TIMER_PIN_PWM3_N        (OMW_GPIO_PIN15)
#define OMW_TIMER_PIN_PWM4_2        (OMW_GPIO_PIN16)
#define OMW_TIMER_PIN_PWM4_N        (OMW_GPIO_PIN17)
#define OMW_TIMER_PIN_PWM5_2        (OMW_GPIO_PIN18)
#define OMW_TIMER_PIN_PWM5_N        (OMW_GPIO_PIN19)
#define OMW_TIMER_PIN_PWM6_2        (OMW_GPIO_PIN20)
#define OMW_TIMER_PIN_PWM6_N        (OMW_GPIO_PIN21)
#define OMW_TIMER_PIN_PWM7_2        (OMW_GPIO_PIN22)
#define OMW_TIMER_PIN_PWM7_N        (OMW_GPIO_PIN23)
#define OMW_TIMER_FUN_CFG_PWM0    ((0x3 << 3) | 7)
#define OMW_TIMER_FUN_CFG_PWM1    ((0x3 << 3) | 7)
#define OMW_TIMER_FUN_CFG_PWM2    ((0x3 << 3) | 7)
#define OMW_TIMER_FUN_CFG_PWM3    ((0x3 << 3) | 7)
#define OMW_TIMER_FUN_CFG_PWM4    ((0x3 << 3) | 7)
#define OMW_TIMER_FUN_CFG_PWM5    ((0x3 << 3) | 7)
#define OMW_TIMER_FUN_CFG_PWM6    ((0x3 << 3) | 7)
#define OMW_TIMER_FUN_CFG_PWM7    ((0x3 << 3) | 7)
#endif
