#ifndef __OMW_CONFIG_H__
#define __OMW_CONFIG_H__

#ifdef __cplusplus
 extern "C" {
#endif

#ifndef OMW_INCLUDE_IN_ASM
#include <stddef.h>
#include <stdarg.h>
#include <string.h>
#endif

#define OMW_CHIP_T1001
#define OMW_HAS_LOG_UART
#define OMW_BLE_CNTR_V0   //V2
#define OMW_BLE_HOST_V0   //V1, V2

#define OMW_TIMER
#define SOP16_1820FPG	//1820FPG的SOP16封装debug打开该宏

#define OMW_EN_DEEP_SLEEP
#ifdef OMW_EN_DEEP_SLEEP	//*sleep_en*******************//

#define CONFIG_OTP_PROGRAM   1	//OTP编译环境：只需要CONFIG_OTP_PROGRAM为1，CONFIG_FLASH_PROGRAM为0,且LD文件的ROM_base需要修改
#define CONFIG_FLASH_PROGRAM 1	//flash编译环境：CONFIG_OTP_PROGRAM与CONFIG_OTP_PROGRAM都为1

#if (CONFIG_FLASH_PROGRAM)	//*CONFIG_FLASH_PROGRAM*//
#ifndef SOP16_1820FPG
#define QSPI_FLASH_FUNC_REG1_VAL    0x00190000  //PIN 10
#define QSPI_FLASH_FUNC_REG2_VAL    0x19190019  //PIN 12，14，15
#define QSPI_REMAP_REG_VAL          0x00543210
#else
#define QSPI_FLASH_FUNC_REG1_VAL    0x00190019  //PIN 4,6
#define QSPI_FLASH_FUNC_REG2_VAL    0x00001919  //PIN 8,9
#define QSPI_REMAP_REG_VAL          0x00543210
#endif
#endif	//*CONFIG_FLASH_PROGRAM*//

#ifndef SOP16_1820FPG		//*sleep_gpio_fun*****//
#define OMW_GPIO_WAKEUP_MASK  0					//高电平唤醒使能，bit位置1对应GPIO使能，休眠时该GPIO口状态为下拉
#define OMW_GPIO_nWAKEUP_MASK 0x000004 			//低电平唤醒使能，bit位置1对应GPIO使能，休眠时该GPIO口状态为上拉
#define OMW_UNUSED_GPIO_MASK     (0xC72BF8)		//工作状态时，未使用的GPIO配置宏。置0使能，使能后，如未进行单独的GPIO配置，则该GPIO状态为上电默认状态。相反置1，则保持高阻态。flash通讯脚位必须置0
#define OMW_WHEN_SLEEP_GPIO_MASK (0xFFFFFB)		//休眠状态时，使用GPIO配置宏。置0使能，使能后，该GPIO口保持休眠前状态，与唤醒宏配合使用注意。置1，休眠时保持高阻态
#else
#define OMW_GPIO_WAKEUP_MASK  0
#define OMW_GPIO_nWAKEUP_MASK 0x000004 
#define OMW_UNUSED_GPIO_MASK     (0xC720A8)
#define OMW_WHEN_SLEEP_GPIO_MASK (0xFFFFFB)
#endif		//*sleep_gpio_fun*****//

#define OMW_SAVE_UART0_REGS
#define OMW_FLASH_VDDIO_PIN1  0xff
#define OMW_FLASH_VDDIO_PIN2  0xff	
#endif	//*sleep_en*******************//

#define OMW_FLASE_BASE_ADDR  0x10000000
#define OMW_FLASE_TOTAL_SIZE (256 * 1024)
#define OMW_FLASH_TAIL_RS    (16 * 1024)
#define OMW_FLASH_HAS_PE
#define OMW_FLASH_SS_BITS  12
#define OMW_FLASH_SS  (1 << OMW_FLASH_SS_BITS)
#ifdef OMW_FLASH_HAS_PE
#define OMW_FLASH_PS_BITS  8
#define OMW_FLASH_PS  (1 << OMW_FLASH_PS_BITS)
#else
#define OMW_FLASH_PS  OMW_FLASH_SS
#endif

#define OMW_USE_STATIC_IRQ_TBL

#define OMW_2G4_DMA_EN_IRQ

#if defined(OMW_BLE_CNTR_V0) || defined(OMW_BLE_HOST_V0)
#define OMW_BLE_V0
#endif

#ifdef OMW_HAS_LOG_UART
#define OMW_LOG_UART            OMW_UART0
#define OMW_LOG_UART_RX_PIN     OMW_GPIO_PIN20
#define OMW_LOG_UART_TX_PIN     OMW_GPIO_PIN21
#define OMW_LOG_UART_RX_FUNC    OMW_GPIO20_UART0_RX
#define OMW_LOG_UART_TX_FUNC    OMW_GPIO21_UART0_TX
#define OMW_LOG_UART_BAUDRATE   115200
#endif

#if defined(OMW_BLE_CNTR_V0) && defined(OMW_BLE_HOST_V0)
#define OMW_BLE_ONLY_V0
#endif

#ifndef OMW_INCLUDE_IN_ASM
#ifdef OMW_CHIP_T1001
#include "t1001.h"
#endif
#endif

#ifdef OMW_HAS_SCH
#include "omw_rtos.h"
#endif

#ifdef __cplusplus
}
#endif

#endif

#ifdef OMW_TIMER
#define OMW_TIMER_PIN_PWM0_1        (OMW_GPIO_PIN0)
#define OMW_TIMER_PIN_PWM1_1        (OMW_GPIO_PIN1)
#define OMW_TIMER_PIN_PWM2_1        (OMW_GPIO_PIN2)
#define OMW_TIMER_PIN_PWM3_1        (OMW_GPIO_PIN3)
#define OMW_TIMER_PIN_PWM4_1        (OMW_GPIO_PIN4)
#define OMW_TIMER_PIN_PWM5_1        (OMW_GPIO_PIN5)
#define OMW_TIMER_PIN_PWM6_1        (OMW_GPIO_PIN6)
#define OMW_TIMER_PIN_PWM7_1        (OMW_GPIO_PIN7)
#define OMW_TIMER_PIN_PWM0_2        (OMW_GPIO_PIN8)
#define OMW_TIMER_PIN_PWM0_N        (OMW_GPIO_PIN9)
#define OMW_TIMER_PIN_PWM1_2        (OMW_GPIO_PIN10)
#define OMW_TIMER_PIN_PWM1_N        (OMW_GPIO_PIN11)
#define OMW_TIMER_PIN_PWM2_2        (OMW_GPIO_PIN12)
#define OMW_TIMER_PIN_PWM2_N        (OMW_GPIO_PIN13)
#define OMW_TIMER_PIN_PWM3_2        (OMW_GPIO_PIN14)
#define OMW_TIMER_PIN_PWM3_N        (OMW_GPIO_PIN15)
#define OMW_TIMER_PIN_PWM4_2        (OMW_GPIO_PIN16)
#define OMW_TIMER_PIN_PWM4_N        (OMW_GPIO_PIN17)
#define OMW_TIMER_PIN_PWM5_2        (OMW_GPIO_PIN18)
#define OMW_TIMER_PIN_PWM5_N        (OMW_GPIO_PIN19)
#define OMW_TIMER_PIN_PWM6_2        (OMW_GPIO_PIN20)
#define OMW_TIMER_PIN_PWM6_N        (OMW_GPIO_PIN21)
#define OMW_TIMER_PIN_PWM7_2        (OMW_GPIO_PIN22)
#define OMW_TIMER_PIN_PWM7_N        (OMW_GPIO_PIN23)
#define OMW_TIMER_FUN_CFG_PWM0    ((0x3 << 3) | 7)
#define OMW_TIMER_FUN_CFG_PWM1    ((0x3 << 3) | 7)
#define OMW_TIMER_FUN_CFG_PWM2    ((0x3 << 3) | 7)
#define OMW_TIMER_FUN_CFG_PWM3    ((0x3 << 3) | 7)
#define OMW_TIMER_FUN_CFG_PWM4    ((0x3 << 3) | 7)
#define OMW_TIMER_FUN_CFG_PWM5    ((0x3 << 3) | 7)
#define OMW_TIMER_FUN_CFG_PWM6    ((0x3 << 3) | 7)
#define OMW_TIMER_FUN_CFG_PWM7    ((0x3 << 3) | 7)
#endif
