
#include "t1001.h"

#include "omw_dbg.h"
#include "omw_gpio.h"
#include "Inital.h"

#include <stdio.h>
#include "string.h"

#include "t100x_hal_2g4.h"

//only for demo
#define SLEEP_ELAPSE 0xFFFFFFFF   //ms

void RF_2G4_PrepareStart(void);
void RF_2G4_UpdateDesc_TxPkt(void);
void RF_2G4_UpdateDesc_RxPkt(void);

extern omw_2g4_param_t rf_2g4_mgr;

uint8_t num_timer1,num_timer2;
uint32_t Key_1,Key_2,Key_3,Key_4;
uint8_t TX_FLG;
uint8_t Key_success_FLG;
uint8_t Key_status,Sleep_flg;
uint8_t R_LED_TIME;

//only for demo
uint8_t tx_ble_adv_data_buf[] = {
    //BLE ADV HDR
    0x42, 0x10,   //ADV TYPE, RFU, TX/RX ADDR, LEN = 6(DEVICE ADDR) + PAYLOAD LEN
    0x20, 0x15, 0xEB, 0x82, 0x93, 0x34,  //DEVICE ADDR

    //PAYLOAD
    0x02, 0x01, 0x06, 0x06, 0xAA, 0x78, 0x9F, 0x04, 0x43, 0x08,
};

//only for demo
#define RX_DATA_LEN  (sizeof(tx_ble_adv_data_buf))
#define MAX_RX_DATA_BUF_LEN  8
uint32_t rx_ble_adv_data_buf[MAX_RX_DATA_BUF_LEN];

int  sync_cnts, crc_ok_cnts;
//if need to call when not wakeup fully, MUST put omw_svc_rx_end into RAM， and DO NOT CALL functions at FLASH SECTION
//otherwise, can put into FLASH(del __RAM_CODE_SECTION)
//when sync ok, this callback will be called
//OP: will call one time per-rxok
__RAM_CODE_SECTION
void omw_svc_24g_sync_end()
{
    sync_cnts++;
}

//if need to call when not wakeup fully, MUST put omw_svc_rx_end into RAM， and DO NOT CALL functions at FLASH SECTION
//otherwise, can put into FLASH(del __RAM_CODE_SECTION)
__RAM_CODE_SECTION
void omw_svc_24g_rx_end(uint8_t is_crc_err)
{
    //TODO: your code start
    if (!is_crc_err)
    {//data is rcved into rx_ble_adv_data_buf
        //only for demo, if call omw_svc_24g_rx_end when not wakeup fully, should not call printf(@flash)
        crc_ok_cnts++;
    }
    //TODO: your code end
}

__RAM_CODE_SECTION
void omw_svc_24g_tx_end()
{
    //TODO: Custom code after TX, should NOT place huge codes here
}

//wkup_type: 0 timeout,  != 0 GPIO trigger, mask
//reture: 0 goto sleep again, 1 fully wake-up
//DO NOT CALL omw_sleep_goto_sleep in omw_sleep_wkup_worker
//DO NOT CALL omw_sleep_goto_sleep in omw_sleep_wkup_worker
//DO NOT CALL omw_sleep_goto_sleep in omw_sleep_wkup_worker
__RAM_CODE_SECTION
uint8_t omw_sleep_wkup_worker(uint32_t wkup_type)
{
    if (wkup_type)  return 1;  //wakeup fully

    return 0; //not wakeup fully
}

int main(void)
{
    omw_dbg_init();
	
	omw_rf_init();

    omw_2g4_param_t tmp_rf_cfg = {
        .channel = 38,
        .phy_mode = RF_RATE_1M,  //2M: RF_RATE_2M
        .preamble_len = 1, //2M: 2
        .access_code = { 0xD6, 0xBE, 0x89, 0x8E },
        .access_len = 4,

        .white_en = 0,
        .white_init = 37,

        .crc_en = 1,
        .crc_len = 3,
        .crc_init = 0x555555,
        .crc_poly = 0x100065b,

       //only for demo
        .rx_timeout = 0x5000,
        .fifo_len   = RX_DATA_LEN,
		
    };
	/**BLE广播信道为37，38，39
	 *对应的channel为38，62，116
	  以tx_data为例：omw_svc_2g4_tx_data()**/
    omw_svc_2g4_init(&tmp_rf_cfg);

    omw_rf_set_tx_power(10);   // 0 dbm, int: -25 ~ 12

    RF_2G4_PrepareStart();
    RF_2G4_UpdateDesc_TxPkt();
    RF_2G4_UpdateDesc_RxPkt();

    //RETENTION RAM CFG: 0x7A=16KB,  0x3A=8KB,  0x1A=4KB
    AON_CTRL->AON_CTRL0 = 0x7A;

    omw_svc_2g4_en_whiten_tx(1);
    omw_svc_2g4_en_whiten_rx(1);

	hc_gpio_init();
	hc_Timer_init();
    //set sleep len and goto sleep
    omw_sleep_set_sleep_len(SLEEP_ELAPSE);
	omw_svc_2g4_set_idle();	//2.4G进入idle模式

    while(1)
    {
        //TODO: do your bussiness		
		KEY_statusswitch();
		
		if(TX_FLG)
		{
			TX_FLG = 0;
			omw_gpio_set_output(OMW_GPIO_PIN19,LOW);//LED亮
			omw_svc_2g4_tx_data((uint8_t*)tx_ble_adv_data_buf, sizeof(tx_ble_adv_data_buf), 38, 37);
			while(rf_2g4_mgr.status_WTR == 1){
				__WFI();
			}
			
			omw_svc_2g4_tx_data((uint8_t*)tx_ble_adv_data_buf, sizeof(tx_ble_adv_data_buf), 62, 38);
			while(rf_2g4_mgr.status_WTR == 1){
				__WFI();
			}
			
			omw_svc_2g4_tx_data((uint8_t*)tx_ble_adv_data_buf, sizeof(tx_ble_adv_data_buf), 116, 39);
			while(rf_2g4_mgr.status_WTR == 1){
				__WFI();
			}
			omw_gpio_set_output(OMW_GPIO_PIN19,LOW);//LED灭
			
			//以上为三个广播信道一起发送的示例，跳频操作需要修改tx_data第三个参数与第四参数
			//第三参数->"t100x_hal_2g4.h"。第四参数0-39对应BLE的40个信道，40-63供2.4G私有协议使用，收发需要一致
			
			Sleep_flg = 0;
			num_timer2 = 0;
		}
		
        omw_svc_2g4_rx_data((uint8_t*)rx_ble_adv_data_buf, RX_DATA_LEN, 38, 37);
		while(rf_2g4_mgr.status_WTR == 1) {
            __WFI();
        }
		if(rx_ble_adv_data_buf[3] == 0x049F78AA)
		{
			R_LED_TIME = 0;
			omw_gpio_set_output(OMW_GPIO_PIN19,LOW);//led标志
		}
		else
		{
			R_LED_TIME++;
			if(R_LED_TIME>20)
			{
				R_LED_TIME = 0;
				omw_gpio_set_output(OMW_GPIO_PIN19,HIGH);//led标志
			}
		}
		
		if(Sleep_flg == 1)
		{
			Sleep_flg = 0;
			KEY_off_status();
			if(Key_success_FLG==1)
			{
				omw_sleep_goto_sleep();
				omw_svc_2g4_set_idle();	//2.4G进入idle模式
			}
		}
		
    }
}
