#include "simple_fifo.h"
#include "simple_ram_pool.h"

void simple_fifo_init(simple_fifo_t* sfifo, uint8_t n, uint32_t* m)
{
    sfifo->n = n;
    sfifo->w = 0;
    sfifo->r = 0;
    sfifo->m = m;
}

void simple_ram_pool_init(simple_ram_pool_t* pool, uint8_t* base_addr, uint16_t total_len)
{
    pool->base_addr = base_addr;
    pool->total_len = total_len;
    pool->offset = 0;
}

uint8_t* simple_ram_pool_malloc(simple_ram_pool_t* pool, uint16_t size)
{
    uint16_t offset = pool->offset;
    pool->offset += size;
    if(pool->offset > pool->total_len)
    {
        return NULL;
    }

    return pool->base_addr + offset;
}