/* ----------------------------------------------------------------------------
 * Copyright (c) 2020-2030 Boling Limited. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *   1. Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright notice,
 *      this list of conditions and the following disclaimer in the documentation
 *      and/or other materials provided with the distribution.
 *   3. Neither the name of Boling nor the names of its contributors
 *      may be used to endorse or promote products derived from this software
 *      without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * -------------------------------------------------------------------------- */

/**
 * @file     omsh_app.c
 * @brief    omesh app source file
 * @date     01. OCT. 2023
 * @author   Boling SW Team
 *
 * @version
 * Version 1.0
 *  - Initial release
 *
 * @{
 */


/*******************************************************************************
 * INCLUDES
 */
#include "omsh_app.h"


/*******************************************************************************
 * EXPORTED FUNCTIONS DEFINITION
 */
void omesh_app_init(void)
{
    #if APP_MESH_LOG
    omesh_log_init(0xFFFF, LOG_LEVEL_DBG2);
    #endif

    omesh_sec_init();

    OM_LOG(OM_LOG_INFO, "\r\n");

    #if APP_MESH_PTS
    __LOG(LOG_SRC_APP, LOG_LEVEL_INFO, "SIG Mesh Present.\n");
    omesh_app_sig_init();
    #elif APP_MESH_TMALL
    __LOG(LOG_SRC_APP, LOG_LEVEL_INFO, "Tmall Mesh Present.\n");
    omesh_app_tmall_init();
    #elif APP_MESH_FIRMS
    __LOG(LOG_SRC_APP, LOG_LEVEL_INFO, "Firms Mesh Present.\n");
    omesh_app_firms_init();
    #endif
}

void omesh_app_start(uint8_t prov_state)
{
    #if APP_MESH_PTS
    omesh_app_sig_start(prov_state);
    #elif APP_MESH_TMALL
    omesh_app_tmall_start(prov_state);
    #elif APP_MESH_FIRMS
    omesh_app_firms_start(prov_state);
    #endif
}


/** @} */