#include "bsp.h"


void  bsp_lptim_free_running_init(lp_tim_underflow_out_action_t  action)
{
	pin_config_t pin_cfg_cnt [] = 
	{
		{PAD_LP_TIM_OUT0,  {PINMUX_LP_TIMER_OUT0_CFG},  PMU_PIN_MODE_PP, PMU_PIN_DRIVER_CURRENT_NORMAL},
		
		{PAD_LP_TIM_OUT1,  {PINMUX_LP_TIMER_OUT1_CFG},  PMU_PIN_MODE_PP, PMU_PIN_DRIVER_CURRENT_NORMAL},
	};
	
	lp_tim_free_running_config_t    mode_cfg;
	
    lp_tim_out_config_t             out_cfg;
	
	
	drv_pin_init(pin_cfg_cnt, sizeof(pin_cfg_cnt) / sizeof(pin_cfg_cnt[0]));
	
	
	mode_cfg.presclar       = 0;
    mode_cfg.top_en         = 1;
    mode_cfg.top_val        = 1000;
    mode_cfg.compare_val0   = 300;
    mode_cfg.compare_val1   = 500;
	
    drv_lp_tim_free_running_init(OM_LP_TIM, &mode_cfg);
	
	
	out_cfg.pol         = LP_TIM_POL_IDLE_LOW;
    out_cfg.action      = action;
	
    drv_lp_tim_outx_config(OM_LP_TIM, LP_TIM_CHAN_OUT0, &out_cfg);
	
	drv_lp_tim_outx_config(OM_LP_TIM, LP_TIM_CHAN_OUT1, &out_cfg);
	
	drv_lp_tim_control(OM_LP_TIM, LP_TIM_CONTROL_START, NULL);
}



void  bsp_lptim_oneshot_init(lp_tim_underflow_out_action_t  action)
{
	pin_config_t pin_cfg_cnt [] = 
	{
		{PAD_LP_TIM_OUT0,  {PINMUX_LP_TIMER_OUT0_CFG},  PMU_PIN_MODE_PP, PMU_PIN_DRIVER_CURRENT_NORMAL},
		
		{PAD_LP_TIM_OUT1,  {PINMUX_LP_TIMER_OUT1_CFG},  PMU_PIN_MODE_PP, PMU_PIN_DRIVER_CURRENT_NORMAL},
	};

	lp_tim_one_shot_config_t  mode_cfg;
	
    lp_tim_out_config_t       out_cfg;
	
	
	drv_pin_init(pin_cfg_cnt, sizeof(pin_cfg_cnt) / sizeof(pin_cfg_cnt[0]));
	
	mode_cfg.presclar       = 0;
    mode_cfg.rep0_val       = 10;
    mode_cfg.top_en         = 1;
    mode_cfg.top_val        = 500;
    mode_cfg.compare_val0   = 100;
    mode_cfg.compare_val1   = 200;
	
    drv_lp_tim_one_shot_init(OM_LP_TIM, &mode_cfg);
	
	out_cfg.pol      = LP_TIM_POL_IDLE_LOW;
    out_cfg.action   = action;
	
    drv_lp_tim_outx_config(OM_LP_TIM, LP_TIM_CHAN_OUT0, &out_cfg);
	
	drv_lp_tim_outx_config(OM_LP_TIM, LP_TIM_CHAN_OUT1, &out_cfg);
	
	drv_lp_tim_control(OM_LP_TIM, LP_TIM_CONTROL_START, NULL);
}




void  bsp_lptim_buffered_init(lp_tim_underflow_out_action_t  action)
{
	pin_config_t pin_cfg_cnt [] = 
	{
		{PAD_LP_TIM_OUT0,  {PINMUX_LP_TIMER_OUT0_CFG},  PMU_PIN_MODE_PP, PMU_PIN_DRIVER_CURRENT_NORMAL},
		
		{PAD_LP_TIM_OUT1,  {PINMUX_LP_TIMER_OUT1_CFG},  PMU_PIN_MODE_PP, PMU_PIN_DRIVER_CURRENT_NORMAL},
	};

	lp_tim_buffered_config_t  mode_cfg;
	
    lp_tim_out_config_t       out_cfg;
	
	
	drv_pin_init(pin_cfg_cnt, sizeof(pin_cfg_cnt) / sizeof(pin_cfg_cnt[0]));
	
	mode_cfg.presclar       = 0;
    mode_cfg.rep0_val       = 3;
    mode_cfg.rep1_val       = 6;
    mode_cfg.top_en         = 1;
    mode_cfg.top_val        = 500;
    mode_cfg.buftop_en      = 1;
    mode_cfg.buftop_val     = 1000;
    mode_cfg.compare_val0   = 200;
    mode_cfg.compare_val1   = 300;
	
    drv_lp_tim_buffered_init(OM_LP_TIM, &mode_cfg);
	
	out_cfg.pol      = LP_TIM_POL_IDLE_LOW;
    out_cfg.action   = action;
	
    drv_lp_tim_outx_config(OM_LP_TIM, LP_TIM_CHAN_OUT0, &out_cfg);
	
	drv_lp_tim_outx_config(OM_LP_TIM, LP_TIM_CHAN_OUT1, &out_cfg);
	
	drv_lp_tim_control(OM_LP_TIM, LP_TIM_CONTROL_START, NULL);
}



void  bsp_lptim_double_init(lp_tim_underflow_out_action_t  action)
{
	pin_config_t pin_cfg_cnt [] = 
	{
		{PAD_LP_TIM_OUT0,  {PINMUX_LP_TIMER_OUT0_CFG},  PMU_PIN_MODE_PP, PMU_PIN_DRIVER_CURRENT_NORMAL},
		
		{PAD_LP_TIM_OUT1,  {PINMUX_LP_TIMER_OUT1_CFG},  PMU_PIN_MODE_PP, PMU_PIN_DRIVER_CURRENT_NORMAL},
	};

	lp_tim_double_config_t  mode_cfg;
	
    lp_tim_out_config_t     out_cfg;
	
	
	drv_pin_init(pin_cfg_cnt, sizeof(pin_cfg_cnt) / sizeof(pin_cfg_cnt[0]));
	
	mode_cfg.presclar       = 0;
    mode_cfg.rep0_val       = 3;
    mode_cfg.rep1_val       = 5;
    mode_cfg.top_en         = 1;
    mode_cfg.top_val        = 500;
    mode_cfg.compare_val0   = 200;
    mode_cfg.compare_val1   = 300;
	
    drv_lp_tim_double_init(OM_LP_TIM, &mode_cfg);
	
	out_cfg.pol      = LP_TIM_POL_IDLE_LOW;
    out_cfg.action   = action;
	
    drv_lp_tim_outx_config(OM_LP_TIM, LP_TIM_CHAN_OUT0, &out_cfg);
	
	drv_lp_tim_outx_config(OM_LP_TIM, LP_TIM_CHAN_OUT1, &out_cfg);
	
	drv_lp_tim_control(OM_LP_TIM, LP_TIM_CONTROL_START, NULL);
}













