#ifndef	__BSP_H__
#define	__BSP_H__

#include "shell_port.h"
#include "shell_cmd.h"
#include "om_printf.h"

#include "bsp_led.h"
#include "bsp_key.h"
#include "bsp_timer.h"
#include "bsp_lptimer.h"
#include "bsp_pmu_timer.h"
#include "bsp_wdt.h"
#include "bsp_uart.h"
#include "bsp_uart_ex.h"
#include "bsp_i2c_eeprom.h"
#include "bsp_spi.h"
#include "bsp_adc.h"
#include "bsp_rng.h"
#include "bsp_sflash.h"
#include "bsp_aes.h"
#include "bsp_rtc.h"



typedef enum 
{
	BSP_LED = 1,
	
	
	BSP_KEY_CHECK,
	
	BSP_KEY_INT,
	
	
	BSP_TIM_COUNT,
	
	BSP_TIM_PWM_IN,
	
	BSP_TIM_PWM_OUT,
	
	BSP_TIM_CAPTURE,
	
	BSP_TIM_PWM_OUT_COMP,
	
	BSP_TIM_COUNT_32BIT,
	

	BSP_LPTIM_FREE_RUNNING_TOGGLE,
	
	BSP_LPTIM_ONESHOT_TOGGLE,
	
	BSP_LPTIM_BUFFERED_TOGGLE,
	
	BSP_LPTIM_DOUBLE_TOGGLE,
	
	
	BSP_LPTIM_FREE_RUNNING_PULSE,
	
	BSP_LPTIM_ONESHOT_PULSE,
	
	BSP_LPTIM_BUFFERED_PULSE,
	
	BSP_LPTIM_DOUBLE_PULSE,
	
	
	BSP_LPTIM_FREE_RUNNING_PWM,
	
	BSP_LPTIM_ONESHOT_PWM,
	
	BSP_LPTIM_BUFFERED_PWM,
	
	BSP_LPTIM_DOUBLE_PWM,
	
	
	BSP_PMU_TIMER,
	
	
	BSP_WDT_INTDIS_FEED,
	
	BSP_WDT_INTDIS_RST,
	
	BSP_WDT_INTEN_FEED,
	
	BSP_WDT_INTEN_RST,
	
	
	BSP_RTC,
	
	
	BSP_UART_BLOCK,
	
	BSP_UART_INT,
	
	BSP_UART_DMA,
	
	BSP_UART_FLOW,
	
	
	BSP_UART_EX_INT,
	

	BSP_I2C_EEPROM,  


	BSP_SPI_W25QXX,        

	
	BSP_ADC_CHECK,           

	BSP_ADC_INT,             

	BSP_ADC_DMA,             

	BSP_ADC_TEMP,            

	BSP_ADC_BAT,            

	

	BSP_RNG,             

	BSP_SFLASH,              

	BSP_AES128,              

	BSP_AES256,              
	
} test_demo_typedef;



extern test_demo_typedef bsp_index;

extern void bsp_init(void);

extern void bsp_demo(void);

#endif
