/**
 * @file board.c
 * @brief
 * @date Tue 31 Jan 2023 09:35:21 AM CST
 * @author BoLing
 *
 * @addtogroup
 * @ingroup
 * @details
 *
 * @{
 */

/*******************************************************************************
 * INCLUDES
 */

#include "RTE_bl182x.h"
#include "om_driver.h"
#include "board_bl1826_evb.h"

/*******************************************************************************
 * MACROS
 */
#define BOARD_32K_SELECT            PMU_32K_SEL_RC
#define BOARD_PIN_DRIVER_CURRENT    PMU_PIN_DRIVER_CURRENT_NORMAL

/*******************************************************************************
 * TYPEDEFS
 */


/*******************************************************************************
 * CONSTANTS
 */
static const pin_config_t pin_config[] = {
    #if (1 && RTE_USART0)
    {PAD_UART0_TXD, {PINMUX_PAD5_UART0_TX_CFG}, PMU_PIN_MODE_PP, BOARD_PIN_DRIVER_CURRENT},
    {PAD_UART0_RXD, {PINMUX_PAD6_UART0_RX_CFG}, PMU_PIN_MODE_PU, BOARD_PIN_DRIVER_CURRENT},
    #endif

    #if (1 && RTE_USART1)
    {PAD_UART1_TXD, {PINMUX_PAD4_UART1_TX_CFG}, PMU_PIN_MODE_PP, BOARD_PIN_DRIVER_CURRENT},
    {PAD_UART1_RXD, {PINMUX_PAD3_UART1_RX_CFG}, PMU_PIN_MODE_PU, BOARD_PIN_DRIVER_CURRENT},
    #endif

    #if (defined(PAD_RF_TXEN) && defined(PAD_RF_RXEN))
    {PAD_RF_RXEN, {PINMUX_PAD3_RX_EXT_PD_CFG}, PMU_PIN_MODE_PP, BOARD_PIN_DRIVER_CURRENT},
    {PAD_RF_TXEN, {PINMUX_PAD4_TX_EXT_PD_CFG}, PMU_PIN_MODE_PP, BOARD_PIN_DRIVER_CURRENT},
    #endif

    {PAD_LED_0, {PINMUX_GPIO_MODE_CFG}, PMU_PIN_MODE_PP, BOARD_PIN_DRIVER_CURRENT},
    {PAD_LED_1, {PINMUX_GPIO_MODE_CFG}, PMU_PIN_MODE_PP, BOARD_PIN_DRIVER_CURRENT},
    {PAD_LED_2, {PINMUX_GPIO_MODE_CFG}, PMU_PIN_MODE_PP, BOARD_PIN_DRIVER_CURRENT},
    {PAD_LED_3, {PINMUX_GPIO_MODE_CFG}, PMU_PIN_MODE_PP, BOARD_PIN_DRIVER_CURRENT},
    {PAD_LED_4, {PINMUX_GPIO_MODE_CFG}, PMU_PIN_MODE_PP, BOARD_PIN_DRIVER_CURRENT},
    {PAD_LED_5, {PINMUX_GPIO_MODE_CFG}, PMU_PIN_MODE_PP, BOARD_PIN_DRIVER_CURRENT},

    {PAD_BUTTON_0, {PINMUX_GPIO_MODE_CFG}, PMU_PIN_MODE_PU, BOARD_PIN_DRIVER_CURRENT},
    {PAD_BUTTON_1, {PINMUX_GPIO_MODE_CFG}, PMU_PIN_MODE_PU, BOARD_PIN_DRIVER_CURRENT},
};

static const gpio_config_t gpio_config[] = {
    {OM_GPIO0, PAD_LED_0,    GPIO_DIR_OUTPUT, LED_OFF_LEVEL, GPIO_TRIG_NONE},
    {OM_GPIO0, PAD_LED_1,    GPIO_DIR_OUTPUT, LED_OFF_LEVEL, GPIO_TRIG_NONE},
    {OM_GPIO0, PAD_LED_2,    GPIO_DIR_OUTPUT, LED_OFF_LEVEL, GPIO_TRIG_NONE},
    {OM_GPIO0, PAD_LED_3,    GPIO_DIR_OUTPUT, LED_OFF_LEVEL, GPIO_TRIG_NONE},
    {OM_GPIO0, PAD_LED_4,    GPIO_DIR_OUTPUT, LED_OFF_LEVEL, GPIO_TRIG_NONE},
    {OM_GPIO0, PAD_LED_5,    GPIO_DIR_OUTPUT, LED_OFF_LEVEL, GPIO_TRIG_NONE},
    {OM_GPIO0, PAD_BUTTON_0, GPIO_DIR_INPUT,  LED_OFF_LEVEL, GPIO_TRIG_RISING_FAILING_EDGE},
    {OM_GPIO0, PAD_BUTTON_1, GPIO_DIR_INPUT,  LED_OFF_LEVEL, GPIO_TRIG_RISING_FAILING_EDGE},
};


/*******************************************************************************
 * LOCAL VARIABLES
 */


/*******************************************************************************
 * GLOBAL VARIABLES
 */


/*******************************************************************************
 * LOCAL FUNCTIONS
 */


/*******************************************************************************
 * PUBLIC FUNCTIONS
 */

/**
 * @brief  board init
 **/
void board_init(void)
{
    // Use DCDC (Default is LDO mode)
//    drv_pmu_dcdc_enable(false);
    // Use RC32K
    drv_pmu_select_32k(BOARD_32K_SELECT);
    // All pin is pull up (Default all IOs are floating input, except for IO4 which is pulled up input)
    drv_pmu_pin_mode_set(PMU_PIN_ALL_MASK & ((BOARD_32K_SELECT==PMU_32K_SEL_32768HZ_XTAL) ? ~(BITMASK(24)|BITMASK(25)) : ~0U), PMU_PIN_MODE_PU);
    // All pin is normal driven (Default is normal)
    drv_pmu_pin_driven_current_set(PMU_PIN_ALL_MASK, BOARD_PIN_DRIVER_CURRENT);
    // Init PIN
    drv_pin_init(pin_config, sizeof(pin_config) / sizeof(pin_config[0]));
    // Init GPIO
    drv_gpio_init(gpio_config, sizeof(gpio_config) / sizeof(gpio_config[0]));
}


/** @} */

