#include "headfiles.h"

#include "lcm_config.h"

#if ST7789JD

void lcm_config_init(void)
{
    uint8_t reg;
    uint8_t buf[64];
    uint8_t *const start = buf;
    uint8_t *p = buf;
    //OSC DIV
    reg = 0xC5;
    p = start;
    *p++ = 0x0B; /*FPS 60HZ(0x03)-->30HZ(0x0B),42HZ(0x0E),47HZ(0x0F)*/
    lcd_write_reg(lcd_sf_x, 0, reg, start, p - start);
    //PASSWORD
    reg = 0xDF;
    p = start;
    *p++ = 0x58;
    *p++ = 0x58;
    *p++ = 0xB0;
    lcd_write_reg(lcd_sf_x, 0, reg, start, p - start);

    //---------------- PAGE0 --------------
    reg = 0xDE;
    p = start;
    *p++ = 0x00;
    lcd_write_reg(lcd_sf_x, 0, reg, start, p - start);

    //VCOM_SET
    reg = 0xB2;
    p = start;
    *p++ = 0x01;
    *p++ = 0x10;
    lcd_write_reg(lcd_sf_x, 0, reg, start, p - start);

    //Gamma_Set
    reg = 0xB7;
    p = start;
    *p++ = 0x10;
    *p++ = 0x4A;
    *p++ = 0x00;
    *p++ = 0x10;
    *p++ = 0x4A;
    *p++ = 0x00;
    lcd_write_reg(lcd_sf_x, 0, reg, start, p - start);

    //DCDC_SEL
    reg = 0xBB;
    p = start;
    *p++ = 0x01;
    *p++ = 0x1D;
    *p++ = 0x43;
    *p++ = 0x43;
    *p++ = 0x21;
    *p++ = 0x21;
    lcd_write_reg(lcd_sf_x, 0, reg, start, p - start);

    //GATE_POWER
    reg = 0xCF;
    p = start;
    *p++ = 0x20;
    *p++ = 0x50;
    lcd_write_reg(lcd_sf_x, 0, reg, start, p - start);

    //SET_R_GAMMA
    reg = 0xC8;
    p = start;
    *p++ = 0x7F;
    *p++ = 0x52;
    *p++ = 0x3B;
    *p++ = 0x2A;
    *p++ = 0x22;
    *p++ = 0x12;
    *p++ = 0x17;
    *p++ = 0x04;
    *p++ = 0x21;
    *p++ = 0x26;
    *p++ = 0x29;
    *p++ = 0x4B;
    *p++ = 0x3A;
    *p++ = 0x45;
    *p++ = 0x3A;
    *p++ = 0x35;
    *p++ = 0x2C;
    *p++ = 0x1E;
    *p++ = 0x01;
    *p++ = 0x7F;
    *p++ = 0x52;
    *p++ = 0x3B;
    *p++ = 0x2A;
    *p++ = 0x22;
    *p++ = 0x12;
    *p++ = 0x17;
    *p++ = 0x04;
    *p++ = 0x21;
    *p++ = 0x26;
    *p++ = 0x29;
    *p++ = 0x4B;
    *p++ = 0x3A;
    *p++ = 0x45;
    *p++ = 0x3A;
    *p++ = 0x35;
    *p++ = 0x2C;
    *p++ = 0x1E;
    *p++ = 0x01;
    lcd_write_reg(lcd_sf_x, 0, reg, start, p - start);

    //-----------------------------
    // SET page4 TCON & GIP
    //------------------------------
    reg = 0xDE;
    p = start;
    *p++ = 0x04;
    lcd_write_reg(lcd_sf_x, 0, reg, start, p - start);

    //SETSTBA
    reg = 0xB2;
    p = start;
    *p++ = 0x14;
    *p++ = 0x14;
    lcd_write_reg(lcd_sf_x, 0, reg, start, p - start);

    //SETRGBCYC1
    reg = 0xB8;
    p = start;
    *p++ = 0x74;
    *p++ = 0x44;
    *p++ = 0x00;
    *p++ = 0x01;
    *p++ = 0x01;
    *p++ = 0x00;
    *p++ = 0x01;
    *p++ = 0x01;
    *p++ = 0x00;
    *p++ = 0x09;
    *p++ = 0x82;
    *p++ = 0x10;
    *p++ = 0x8A;
    *p++ = 0x03;
    *p++ = 0x11;
    *p++ = 0x0B;
    *p++ = 0x84;
    *p++ = 0x21;
    *p++ = 0x8C;
    *p++ = 0x05;
    *p++ = 0x22;
    *p++ = 0x0D;
    *p++ = 0x86;
    *p++ = 0x32;
    *p++ = 0x8E;
    *p++ = 0x07;
    *p++ = 0x00;
    *p++ = 0x00;
    *p++ = 0x00;
    lcd_write_reg(lcd_sf_x, 0, reg, start, p - start);

    //SETRGBCYC2
    reg = 0xB9;
    p = start;
    *p++ = 0x40;
    *p++ = 0x22;
    *p++ = 0x08;
    *p++ = 0x3A;
    *p++ = 0x22;
    *p++ = 0x4B;
    *p++ = 0x7D;
    *p++ = 0x22;
    *p++ = 0x8D;
    *p++ = 0xBF;
    *p++ = 0x32;
    *p++ = 0xD0;
    *p++ = 0x02;
    *p++ = 0x33;
    *p++ = 0x12;
    *p++ = 0x44;
    *p++ = 0x00;
    *p++ = 0x0A;
    *p++ = 0x00;
    *p++ = 0x0A;
    *p++ = 0x0A;
    *p++ = 0x00;
    *p++ = 0x0A;
    *p++ = 0x0A;
    *p++ = 0x00;
    *p++ = 0x0A;
    *p++ = 0x0A;
    lcd_write_reg(lcd_sf_x, 0, reg, start, p - start);

    //SETRGBCYC3
    reg = 0xBA;
    p = start;
    *p++ = 0x00;
    *p++ = 0x00;
    *p++ = 0x07;
    *p++ = 0x07;
    *p++ = 0x00;
    *p++ = 0x07;
    *p++ = 0x07;
    *p++ = 0x00;
    *p++ = 0x07;
    *p++ = 0x07;
    *p++ = 0x00;
    *p++ = 0x01;
    *p++ = 0x01;
    *p++ = 0x00;
    *p++ = 0x0A;
    *p++ = 0x01;
    *p++ = 0x00;
    *p++ = 0x01;
    *p++ = 0x30;
    *p++ = 0x0A;
    *p++ = 0x40;
    *p++ = 0x30;
    *p++ = 0x01;
    *p++ = 0x3E;
    *p++ = 0x00;
    *p++ = 0x00;
    *p++ = 0x00;
    *p++ = 0x00;
    lcd_write_reg(lcd_sf_x, 0, reg, start, p - start);

    //SET_TCON
    reg = 0xBC;
    p = start;
    *p++ = 0x1A;
    *p++ = 0x00;
    *p++ = 0xB4;
    *p++ = 0x03;
    *p++ = 0x00;
    *p++ = 0xD0;
    *p++ = 0x08;
    *p++ = 0x00;
    *p++ = 0x07;
    *p++ = 0x2C;
    *p++ = 0x00;
    *p++ = 0xD0;
    *p++ = 0x08;
    *p++ = 0x00;
    *p++ = 0x07;
    *p++ = 0x2C;
    *p++ = 0x82;
    *p++ = 0x00;
    *p++ = 0x03;
    *p++ = 0x00;
    *p++ = 0xD0;
    *p++ = 0x08;
    *p++ = 0x00;
    *p++ = 0x07;
    *p++ = 0x2C;
    lcd_write_reg(lcd_sf_x, 0, reg, start, p - start);

    //-------------------GIP----------------------
    //SET_GIP_EQ
    reg = 0xC4;
    p = start;
    *p++ = 0x00;
    *p++ = 0x00;
    *p++ = 0x00;
    *p++ = 0x02;
    *p++ = 0x00;
    *p++ = 0x00;
    *p++ = 0x00;
    *p++ = 0x00;
    *p++ = 0x02;
    *p++ = 0x00;
    *p++ = 0x00;
    *p++ = 0x00;
    *p++ = 0x02;
    *p++ = 0x00;
    *p++ = 0x00;
    *p++ = 0x00;
    *p++ = 0x00;
    *p++ = 0x00;
    *p++ = 0x00;
    lcd_write_reg(lcd_sf_x, 0, reg, start, p - start);

    //SET_GIP_L
    reg = 0xC5;
    p = start;
    *p++ = 0x00;
    *p++ = 0x1F;
    *p++ = 0x1F;
    *p++ = 0x1F;
    *p++ = 0x1E;
    *p++ = 0xDF;
    *p++ = 0x1F;
    *p++ = 0xC7;
    *p++ = 0xC5;
    *p++ = 0x1F;
    *p++ = 0x1F;
    *p++ = 0x1F;
    *p++ = 0x1F;
    *p++ = 0x1F;
    *p++ = 0x1F;
    *p++ = 0x1F;
    *p++ = 0x1F;
    *p++ = 0x1F;
    *p++ = 0x1F;
    *p++ = 0x1F;
    *p++ = 0x1F;
    *p++ = 0x1F;
    *p++ = 0x1F;
    *p++ = 0x1F;
    *p++ = 0x1F;
    *p++ = 0x1F;
    *p++ = 0x1F;
    lcd_write_reg(lcd_sf_x, 0, reg, start, p - start);

    //SET_GIP_R
    reg = 0xC6;
    p = start;
    *p++ = 0x00;
    *p++ = 0x1F;
    *p++ = 0x1F;
    *p++ = 0x1F;
    *p++ = 0x1F;
    *p++ = 0x1F;
    *p++ = 0x1F;
    *p++ = 0x1F;
    *p++ = 0x1F;
    *p++ = 0x1F;
    *p++ = 0x1F;
    *p++ = 0x00;
    *p++ = 0xC4;
    *p++ = 0xC6;
    *p++ = 0xE0;
    *p++ = 0xE1;
    *p++ = 0xE2;
    *p++ = 0xE3;
    *p++ = 0xE4;
    *p++ = 0xE5;
    *p++ = 0x1F;
    *p++ = 0x1F;
    *p++ = 0x1F;
    *p++ = 0x1F;
    *p++ = 0x1F;
    *p++ = 0x1F;
    *p++ = 0x1F;
    lcd_write_reg(lcd_sf_x, 0, reg, start, p - start);

    //SET_GIP_L_GS
    reg = 0xC7;
    p = start;
    *p++ = 0x00;
    *p++ = 0x1F;
    *p++ = 0x1F;
    *p++ = 0x1F;
    *p++ = 0xDE;
    *p++ = 0x1F;
    *p++ = 0x00;
    *p++ = 0xC4;
    *p++ = 0xC6;
    *p++ = 0x1F;
    *p++ = 0x1F;
    *p++ = 0x1F;
    *p++ = 0x1F;
    *p++ = 0x1F;
    *p++ = 0x1F;
    *p++ = 0x1F;
    *p++ = 0x1F;
    *p++ = 0x1F;
    *p++ = 0x1F;
    *p++ = 0x1F;
    *p++ = 0x1F;
    *p++ = 0x1F;
    *p++ = 0x1F;
    *p++ = 0x1F;
    *p++ = 0x1F;
    *p++ = 0x1F;
    *p++ = 0x1F;
    lcd_write_reg(lcd_sf_x, 0, reg, start, p - start);

    //SET_GIP_R_GS
    reg = 0xC8;
    p = start;
    *p++ = 0x00;
    *p++ = 0x1F;
    *p++ = 0x1F;
    *p++ = 0x1F;
    *p++ = 0x1F;
    *p++ = 0x1F;
    *p++ = 0x1F;
    *p++ = 0x1F;
    *p++ = 0x1F;
    *p++ = 0x1F;
    *p++ = 0x1F;
    *p++ = 0x1F;
    *p++ = 0xC7;
    *p++ = 0xC5;
    *p++ = 0x20;
    *p++ = 0x21;
    *p++ = 0x22;
    *p++ = 0x23;
    *p++ = 0x24;
    *p++ = 0x25;
    *p++ = 0x1F;
    *p++ = 0x1F;
    *p++ = 0x1F;
    *p++ = 0x1F;
    *p++ = 0x1F;
    *p++ = 0x1F;
    *p++ = 0x1F;
    lcd_write_reg(lcd_sf_x, 0, reg, start, p - start);

    //SETGIP1
    reg = 0xC9;
    p = start;
    *p++ = 0x00;
    *p++ = 0x00;
    *p++ = 0x00;
    *p++ = 0x00;
    *p++ = 0x10;
    *p++ = 0x00;
    *p++ = 0x10;
    *p++ = 0x10;
    *p++ = 0x00;
    *p++ = 0x00;
    *p++ = 0x00;
    *p++ = 0x20;
    *p++ = 0x20;
    *p++ = 0x20;
    *p++ = 0x20;
    *p++ = 0x20;
    *p++ = 0x20;
    *p++ = 0x20;
    *p++ = 0x20;
    *p++ = 0x00;
    *p++ = 0x00;
    *p++ = 0x00;
    *p++ = 0x00;
    *p++ = 0x00;
    *p++ = 0x00;
    *p++ = 0x00;
    lcd_write_reg(lcd_sf_x, 0, reg, start, p - start);

    //SETGIP2
    reg = 0xCB;
    p = start;
    *p++ = 0x01;
    *p++ = 0x10;
    *p++ = 0x00;
    *p++ = 0x00;
    *p++ = 0x07;
    *p++ = 0x01;
    *p++ = 0x00;
    *p++ = 0x0A;
    *p++ = 0x00;
    *p++ = 0x02;
    *p++ = 0x00;
    *p++ = 0x00;
    *p++ = 0x00;
    *p++ = 0x03;
    *p++ = 0x00;
    *p++ = 0x00;
    *p++ = 0x00;
    *p++ = 0x21;
    *p++ = 0x23;
    *p++ = 0x30;
    *p++ = 0x00;
    *p++ = 0x08;
    *p++ = 0x04;
    *p++ = 0x00;
    *p++ = 0x00;
    *p++ = 0x05;
    *p++ = 0x10;
    *p++ = 0x01;
    *p++ = 0x04;
    *p++ = 0x06;
    *p++ = 0x10;
    *p++ = 0x10;
    lcd_write_reg(lcd_sf_x, 0, reg, start, p - start);

    //SET_GIP_ONOFF
    reg = 0xD1;
    p = start;
    *p++ = 0x00;
    *p++ = 0x00;
    *p++ = 0x03;
    *p++ = 0x60;
    *p++ = 0x30;
    *p++ = 0x03;
    *p++ = 0x18;
    *p++ = 0x30;
    *p++ = 0x07;
    *p++ = 0x3A;
    *p++ = 0x30;
    *p++ = 0x03;
    *p++ = 0x18;
    *p++ = 0x30;
    *p++ = 0x03;
    *p++ = 0x18;
    *p++ = 0x30;
    *p++ = 0x03;
    *p++ = 0x18;
    lcd_write_reg(lcd_sf_x, 0, reg, start, p - start);

    //SET_GIP_ONOFF_WB
    reg = 0xD2;
    p = start;
    *p++ = 0x00;
    *p++ = 0x30;
    *p++ = 0x07;
    *p++ = 0x3A;
    *p++ = 0x32;
    *p++ = 0xBC;
    *p++ = 0x20;
    *p++ = 0x32;
    *p++ = 0xBC;
    *p++ = 0x20;
    *p++ = 0x32;
    *p++ = 0xBC;
    *p++ = 0x20;
    *p++ = 0x32;
    *p++ = 0xBC;
    *p++ = 0x20;
    *p++ = 0x30;
    *p++ = 0x10;
    *p++ = 0x20;
    *p++ = 0x30;
    *p++ = 0x10;
    *p++ = 0x20;
    *p++ = 0x30;
    *p++ = 0x10;
    *p++ = 0x20;
    *p++ = 0x30;
    *p++ = 0x10;
    *p++ = 0x20;
    lcd_write_reg(lcd_sf_x, 0, reg, start, p - start);

    //SETGIP8_CKH1 CKH_ON/OFF_CKH0-CKH7_odd
    reg = 0xD4;
    p = start;
    *p++ = 0x00;
    *p++ = 0x00;
    *p++ = 0x03;
    *p++ = 0x14;
    *p++ = 0x00;
    *p++ = 0x03;
    *p++ = 0x20;
    *p++ = 0x00;
    *p++ = 0x09;
    *p++ = 0x82;
    *p++ = 0x10;
    *p++ = 0x8A;
    *p++ = 0x03;
    *p++ = 0x11;
    *p++ = 0x0B;
    *p++ = 0x84;
    *p++ = 0x21;
    *p++ = 0x8C;
    *p++ = 0x05;
    *p++ = 0x22;
    *p++ = 0x0D;
    *p++ = 0x86;
    *p++ = 0x32;
    *p++ = 0x8E;
    *p++ = 0x07;
    *p++ = 0x00;
    *p++ = 0x00;
    *p++ = 0x00;
    *p++ = 0x00;
    *p++ = 0x00;
    *p++ = 0x00;
    lcd_write_reg(lcd_sf_x, 0, reg, start, p - start);

    //---------------- PAGE0 --------------
    reg = 0xDE;
    p = start;
    *p++ = 0x00;
    lcd_write_reg(lcd_sf_x, 0, reg, start, p - start);

    // RAM_CTRL
    reg = 0xD7;
    p = start;
    *p++ = 0x20;
    *p++ = 0x00;
    *p++ = 0x41;
    lcd_write_reg(lcd_sf_x, 0, reg, start, p - start);

    //---------------- PAGE1 --------------
    reg = 0xDE;
    p = start;
    *p++ = 0x01;
    lcd_write_reg(lcd_sf_x, 0, reg, start, p - start);

    ////MCMD_CTRL
    reg = 0xCA;
    p = start;
    *p++ = 0x00;
    lcd_write_reg(lcd_sf_x, 0, reg, start, p - start);

    //---------------- PAGE2 --------------
    reg = 0xDE;
    p = start;
    *p++ = 0x02;
    lcd_write_reg(lcd_sf_x, 0, reg, start, p - start);

    //OSC DIV
    reg = 0xC5;
    p = start;
    *p++ = 0x03; //FPS 60HZ (0x03) to 30HZ (0x0B) ,47HZ(0x0F),42HZ(0x0E)
    lcd_write_reg(lcd_sf_x, 0, reg, start, p - start);

    //---------------- PAGE0 --------------
    reg = 0xDE;
    p = start;
    *p++ = 0x00;
    lcd_write_reg(lcd_sf_x, 0, reg, start, p - start);

    //Color Pixel Format
    reg = 0x3A;
    p = start;
    *p++ = 0x05; //565
    lcd_write_reg(lcd_sf_x, 0, reg, start, p - start);

    //TE ON
    reg = 0x35;
    p = start;
    *p++ = 0x00;
    lcd_write_reg(lcd_sf_x, 0, reg, start, p - start);

    //SLP OUT
    reg = 0x11;
    lcd_write_reg(lcd_sf_x, 0, reg, NULL, 0);
    co_delay_ms(120);

    //DISP ON
    reg = 0x29;
    lcd_write_reg(lcd_sf_x, 0, reg, NULL, 0);

    co_delay_ms(50);
}

void lcd_enter_sleep(void)
{
    char cmd;
    char data[20];
    char len;
    cmd = 0x28;
    len = 0;
    lcd_write_reg(lcd_sf_x, 0, cmd, data, len);
    co_delay_ms(120);
    cmd = 0x10;
    len = 0;
    lcd_write_reg(lcd_sf_x, 0, cmd, data, len);
    co_delay_ms(50);
}

void lcd_exit_sleep(void)
{
    char cmd;
    char data[20];
    char len;
    cmd = 0x11;
    len = 0;
    lcd_write_reg(lcd_sf_x, 0, cmd, data, len);
    co_delay_ms(120);
    cmd = 0x29;
    len = 0;
    lcd_write_reg(lcd_sf_x, 0, cmd, data, len);
}

#endif
