/* ----------------------------------------------------------------------------
 * Copyright (c) 2020-2030 Boling Limited. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *   1. Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright notice,
 *      this list of conditions and the following disclaimer in the documentation
 *      and/or other materials provided with the distribution.
 *   3. Neither the name of Boling nor the names of its contributors
 *      may be used to endorse or promote products derived from this software
 *      without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * -------------------------------------------------------------------------- */

/**
 * @file     omsh_app_config.h
 * @brief    mesh app config header file
 * @date     01. OCT. 2023
 * @author   Boling SW Team
 *
 * @defgroup CONFIG CONFIG
 * @ingroup  APP
 * @brief    mesh app config header file
 * @details  mesh app config header file

 * @version
 * Version 1.0
 *  - Initial release
 *
 *
 * @{
 */

#ifndef __OMSH_APP_CONFIG_H__
#define __OMSH_APP_CONFIG_H__

#ifdef __cplusplus
extern "C"
{
#endif


/*******************************************************************************
 * INCLUDE
 */
#include "features.h"


/*******************************************************************************
 * CONVERT TO APP DEFINE
 */

#if CONFIG_APP_MESH_FIRMS
#define APP_MESH_FIRMS          (1)
#endif

#if CONFIG_APP_MESH_TMALL
#define APP_MESH_TMALL          (1)
#endif


#if CONFIG_APP_MESH_PTS
#define APP_MESH_PTS            (1)
#endif

#if CONFIG_BLE_MESH_LOG_EN
#define APP_MESH_LOG            (1)
#else
#define APP_MESH_LOG            (0)
#endif

#if CONFIG_BLE_MESH_RELAY
#define APP_FEAT_RELAY          (1)
#else
#define APP_FEAT_RELAY          (0)
#endif

#if CONFIG_BLE_MESH_GATT_PROXY
#define APP_FEAT_PROXY          (1)
#else
#define APP_FEAT_PROXY          (0)
#endif

#if CONFIG_BLE_MESH_LPN
#define APP_FEAT_LPN            (1)
#else
#define APP_FEAT_LPN            (0)
#endif

#if CONFIG_BLE_MESH_FRIEND
#define APP_FEAT_FRND           (1)
#else
#define APP_FEAT_FRND           (0)
#endif

#ifdef __cplusplus
}
#endif

#endif /* __OMSH_APP_CONFIG_H__ */

/** @} */