#ifndef __BSP_UART_H
#define __BSP_UART_H


#include "common.h"


#define PAD_UART0_TXD               4

#define PAD_UART0_RXD               3

#define PINMUX_UART0_TX             PINMUX_PAD4_UART0_TX_CFG

#define PINMUX_UART0_RX             PINMUX_PAD3_UART0_RX_CFG



/// Test tx pad for uart1
#define PAD_UART1_TXD               5
/// Test rx pad for uart1
#define PAD_UART1_RXD               6
/// Test cts pad for uart1
#define PAD_UART1_CTS               7
/// Test rts pad for uart1
#define PAD_UART1_RTS               8

#define PINMUX_UART1_TX             PINMUX_PAD5_UART1_TX_CFG

#define PINMUX_UART1_RX             PINMUX_PAD6_UART1_RX_CFG

#define PINMUX_UART1_RTS            PINMUX_PAD8_UART1_RTS_CFG

#define PINMUX_UART1_CTS            PINMUX_PAD7_UART1_CTS_CFG

/// Test uart
#define TEST_USART                  OM_USART1
/// Test uart baudrate
#define USART_BAUDRATE              115200




extern void bsp_uart1_gpio_init(void);

extern void bsp_uart_block_init(void);

extern void bsp_uart_block_demo(void);

extern void bsp_uart_int_init(void);

extern void bsp_uart_int_demo(void);

extern void bsp_uart_dma_init(void);

extern void bsp_uart_dma_demo(void);

extern void bsp_uart_flow_init(void);

extern void bsp_uart_flow_demo(void);






#endif
